#if !defined(BRCHECKB_H) && !defined(__BEDRC__)
#define BRCHECKB_H
//========================================================================================
//
//     File:			BRCheckB.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 18, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef BRBUTTON_H
#include "BRButton.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(BRMOUSEA_H)
#include "BRMouseA.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(BRGRHELP_H)
#include "BRGrHelp.h"
#endif

//----------------------------------------------------------------------------------------
// STRUCT BR_SCheckBoxResource
//----------------------------------------------------------------------------------------

struct BR_SCheckBoxResource : BR_SCheckedButtonResource
{
};

//========================================================================================
//	CLASS BR_CCheckBox
//========================================================================================

class BR_CCheckBox : public BR_CCheckedButton
{
public:
	typedef short int CheckState;
	enum StateConstants { kOff = 0, kOn = 1};
	
	BR_CCheckBox(BR_CView* enclosure,
				 BR_CBureaucrat* supervisor,
				 BR_Distance width,
				 BR_Distance height,
				 BR_Coordinate x,
				 BR_Coordinate y,
				 ViewSizing horizontalSizing,
				 ViewSizing verticalSizing,
				 ViewId viewId,
				 const BR_TString<BR_Char>& text,
				 BR_Boolean automatic = TRUE);

	BR_CCheckBox(BR_CView* enclosure,
				 BR_CBureaucrat* supervisor,
				 const BR_CModule& module,
				 BR_SResource& resource);

	virtual~ BR_CCheckBox();

	CheckState GetState() const;
	virtual void SetState(CheckState newState);

	BR_SETCLASSNAME(BR_CCheckBox);
};

#endif
