#if !defined(BRBITMAP_H) && !defined(__BEDRC__)
#define BRBITMAP_H
//========================================================================================
//
//     File:			BRBitmap.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/22/90
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef BRCANVAS_H
#include "BRCanvas.h"
#endif

#ifndef BRGRIMPL_H
#include "BRGrImpl.h"
#endif

//========================================================================================
//	Forward class declaration
//========================================================================================
#ifdef BR_BUILD_MAC
//class BR_CBedMacPrivateOffscreen;				// a forward reference since we use it before defining it
class BR_CDrawEnvironmentSaveRestore;
#endif

//========================================================================================
//	class BR_CBitmap
//========================================================================================

class BR_CBitmap : public BR_CCanvas
{
public:
	enum UseTempStorage
	{
		kDontUseTemporaryStorage = FALSE, 
		kUseTemporaryStorage = TRUE
	};

public:	
	BR_CBitmap(const BR_CModule& module,
			   BR_ResourceId resourceId);

	BR_CBitmap(BR_CView *view,
				BR_Distance width,
				BR_Distance height,
				BR_Boolean useTemporaryStorage);

	BR_CBitmap(BR_CView *view,
			   BR_CBitmap& bitmap,
			   const BR_CRectangle &bounds,
			   BR_Boolean useTemporaryStorage = kDontUseTemporaryStorage);

	virtual	~BR_CBitmap();

	virtual void 	GetDrawArea(BR_CRectangle& area) const;

	virtual void	OpenPane(BR_CDrawStateData& drawStateData);
	// creates the internal grafport structures used when drawing on a BitMap.

	virtual void	ResumePane(const BR_CDrawStateData& drawStateData);
	// Locks the pixels of the offscreen so they can float in memory
	
	BR_Distance GetWidth() const;
	BR_Distance GetHeight() const;

	void Draw(BR_CCanvas& canvas,
			  BR_Coordinate x,
			  BR_Coordinate y,
			  const BR_CRectangle &sourceRect,
			  BR_RasterOperation mode = BEDROP_SRCCOPY);
	// Draws a part of the bitmap defined by sourceRect on the Canvas, staring at x,y point.
			  
	void Draw(BR_CCanvas& canvas,
			  BR_Coordinate x,
			  BR_Coordinate y,
			  BR_RasterOperation mode = BEDROP_SRCCOPY);
	// Draws the whole bitmap on the Canvas, staring at x,y point.

	void Stretch(BR_CCanvas& canvas,
				 BR_Coordinate x,
				 BR_Coordinate y,
				 BR_Distance width,
				 BR_Distance height,
				 const BR_CRectangle &sourceRect,
				 BR_RasterOperation mode = BEDROP_SRCCOPY);
	
	void Stretch(BR_CCanvas& canvas,
				 BR_Coordinate x,
				 BR_Coordinate y,
				 BR_Distance width,
				 BR_Distance height,
				 BR_RasterOperation mode = BEDROP_SRCCOPY);
	//	Same as the above but also stretch the resulting image so that it's widht by
	//  height.

protected:
	void 		InitBitmap(BR_Boolean useTemporaryStorage);
	void 		InitSize();
	BR_Boolean 	fUseTemporaryStorage;

private:
	BR_CPoint 	fBitmapSize;
	
//----------------------------------------------------------------------------------------
//	Windows
// ---------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	BR_CBitmap(HANDLE hbm);

	HBITMAP 	GetBitmapHandle() const;
	void 		SetBitmapHandle(HBITMAP hNew);

	
protected:
	virtual HDC 	BedWinCreateDC(BR_CView& pane);
	virtual void 	BedWinDeleteDC(BR_CView& pane,
						  			HDC hDC);
private:
	HBITMAP fBitmapHandle;
#endif

//----------------------------------------------------------------------------------------
//	Macintosh
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	virtual void 	GetResolution(BR_CPoint& ptResolution) const;

	virtual void SuspendPane(BR_CDrawStateData& drawStateData);
	// Unlocks the pixels of the offscreen so they can float in memory

	virtual void ClosePane(const BR_CDrawStateData& drawStateData);
	// tosses the internal grafport structures used when drawing on a BitMap.

	GrafPtr 		BedMacGetGrafPort() const;
	virtual void 	BedMacViewToCanvasOwner(BR_CPoint &aPoint) const;
	
	virtual BR_Boolean SetBits(Handle bitmapFromResource);
	virtual BR_Boolean BedMacGetBitMap(BitMap*& someMap) const;
	
	BR_CBedMacPrivateOffscreen *GetOffscreenBitmap() const;
	void 						SetOffscreenBitmap(BR_CBedMacPrivateOffscreen *offscreenBitMap);
	void 						DeleteOffscreenBitmap();

private:
	BR_CBedMacPrivateOffscreen* fOffscreenBitMap;
	// for saving the device in BeginDrawing
	// which means you can't nest BeginDrawing calls on the
	// same bitmap

	BR_CDrawEnvironmentSaveRestore* fSaveDraw;

#endif

	BR_SETCLASSNAME(BR_CBitmap);
};

#ifdef BR_BUILD_MAC
//------------------------------------------------------------------------
// BR_CBitmap::GetOffscreenBitmap
//------------------------------------------------------------------------
inline BR_CBedMacPrivateOffscreen *BR_CBitmap::GetOffscreenBitmap() const
{
	return fOffscreenBitMap;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CBitmap::SetOffscreenBitmap
//----------------------------------------------------------------------------------------
inline void BR_CBitmap::SetOffscreenBitmap(BR_CBedMacPrivateOffscreen *offscreenBitMap)
{
	if (fOffscreenBitMap)
		delete fOffscreenBitMap;
		
	fOffscreenBitMap = offscreenBitMap;
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CBitmap::GetWidth
//----------------------------------------------------------------------------------------
inline BR_Distance BR_CBitmap::GetWidth() const
{
	return fBitmapSize.fX;
}

//----------------------------------------------------------------------------------------
//	BR_CBitmap::GetHeight
//----------------------------------------------------------------------------------------
inline BR_Distance BR_CBitmap::GetHeight() const
{
	return fBitmapSize.fY;
}

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CBitmap::GetBitmapHandle
//----------------------------------------------------------------------------------------
inline HBITMAP BR_CBitmap::GetBitmapHandle() const
{
	return fBitmapHandle;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CBitmap::SetBitmapHandle
//----------------------------------------------------------------------------------------
inline void BR_CBitmap::SetBitmapHandle(HBITMAP hNew)
{
	fBitmapHandle = hNew;
}
#endif

//========================================================================================
//	class BR_CTemporaryBitmap
//========================================================================================
class BR_CTemporaryBitmap : public BR_CBitmap
{
public:
	BR_CTemporaryBitmap(BR_CView *view,
						BR_Distance width,
						BR_Distance height);

	BR_CTemporaryBitmap(BR_CView *view,
						BR_CBitmap& bitmap,
						const BR_CRectangle& bounds);

	virtual~ BR_CTemporaryBitmap();
};

//========================================================================================
//	class BR_CFramedBitmap
//========================================================================================
class BR_CFramedBitmap : public BR_CBitmap
{
public:
	BR_CFramedBitmap(const BR_CModule& module,
					 BR_ResourceId resourceId,
					 unsigned short numberOfRows,
					 unsigned short numberOfColumns);

	virtual~ BR_CFramedBitmap();
	BR_Boolean GetFrameRect(BR_CRectangle& area,
							unsigned short theRow,
							unsigned short theColumn) const;

private:
	unsigned short fNumberOfRows;
	unsigned short fNumberOfColumns;

	BR_SETCLASSNAME(BR_CFramedBitmap);
};

#endif


