#if !defined(BRBEDROC_H) && !defined(__BEDRC__)
#define BRBEDROC_H
//========================================================================================
//
//     File:			BRBedroc.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRFONT_H
#include "BRFont.h"
#endif

#ifndef BRCURSOR_H
#include "BRCursor.h"
#endif

#ifndef BRSYSTEM_H
#include "BRSystem.h"
#endif

//========================================================================================
// CLASS BR_CBedrock
//========================================================================================

class BR_CBedrock : public BR_CSystem
{
public:
	BR_CBedrock();
	virtual~ BR_CBedrock();
	virtual BR_CFont* GetSystemFont() const;
	virtual BR_CCursor* GetCursor(BR_ResourceId id) const;
	static BR_CBedrock* GetBedrock();

private:
	BR_CCursor fArrow;
	BR_CCursor fCross;
	BR_CCursor fIBeam;
	BR_CCursor fSize;
	BR_CCursor fSizeNESW;
	BR_CCursor fSizeNS;
	BR_CCursor fSizeNWSE;
	BR_CCursor fSizeWE;
	BR_CCursor fUpArrow;
	BR_CCursor fWait;
	BR_CFont fSystemFont;
	static BR_CBedrock* gBedrock;


#ifdef BR_BUILD_MAC
public:
	static GrafPort* BedMacGetScratchPort();
	
private:
	static GrafPort* gMacScratchPort;
#endif


#ifdef BR_BUILD_WIN
private:
	static BR_Boolean RegisterClass(unsigned short wClassName,
									FARPROC fpWindowProc,
									WORD wStyle);

	static BR_Boolean RegisterSubClass(unsigned short wClassName,
									   unsigned short wOldClassName,
									   FARPROC fpWindowProc,
									   FARPROC& fpOldProc,
									   WORD& wExtraBytes);
#endif

	BR_SETCLASSNAME(BR_CBedrock);
};

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CBedrock::BedMacGetScratchPort
//----------------------------------------------------------------------------------------

inline GrafPort* BR_CBedrock::BedMacGetScratchPort()
{
	return gMacScratchPort;
}
#endif

#endif
