#if !defined(BRAPPTAS_H) && !defined(__BEDRC__)
#define BRAPPTAS_H
//========================================================================================
//
//     File:			BRAppTas.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/11/92
//
//     COPYRIGHT 1992,93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BREXCTAS_H
#include "BRExcTas.h"
#endif

#ifndef   BRMEMDEB_H
#include "BRMemDeb.h"
#endif

#ifndef   BRWINAPP_H
#include "BRWinApp.h"
#endif


//========================================================================================
// Type definitions
//========================================================================================

typedef void (*BR_NewHandlerFunction)();


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CMemoryHeap;
class BR_CApplication;


//========================================================================================
// CLASS BR_CApplicationTaskGlobals
//
//	This class lays out globals that Bedrock DLLs "share".  Assume that Bedrock is
//	partitioned into the three traditional DLLs (bclutil, bcl, bcladv), and that we
//  add a fourth DLL by removing BEL from bclutil.  Furthermore, we'd like BEL to be
//	usable by applications that may not be built upon the other DLLs.  BEL needs to have
//  task specific globals, without making assumptions about the DLLs and applications that
//	use it.  We achieve this by requiring the following:
//
//		1) We can "reserve" a fSpace in the application's data segment just above the
//		header and below the static data area (alternatively, we can say that we are
//		reserving the first portion of the static data area).
//		2) Within this fSpace, we can reserve fSpace for components like BEL.
//
//	The layout of the data members below defines the fReserved layout.
//========================================================================================

class BR_CApplicationTaskGlobals : public BR_CExceptionTaskGlobals
{
public:
	BR_CApplicationTaskGlobals();
	~BR_CApplicationTaskGlobals();
	
	static BR_CApplicationTaskGlobals*	GetTaskGlobals();

#ifdef BR_STATIC_TASK_GLOBALS
	static BR_CApplicationTaskGlobals&	gApplicationTaskGlobals;
#endif

	// The order of the data members is signficant.  See above.
	
#if defined(BR_DEBUG) && defined(BR_BUILD_WIN)
	BR_SBedMemoryDebugGlobals		gBedMemoryDebugGlobals;
#endif

#ifdef BR_BUILD_WIN
	BR_SBedWinApplicationGlobals	gBedWinApplicationGlobals;
#endif

#ifdef BR_BUILD_MAC
    enum
    {
		kDefaultHeapSize = 100 * 1024,
		kDefaultHeapIncrementSize = 20 * 1024
    };
	BR_CMemoryHeap				*gMemoryHeap;
#endif

	BR_CApplication     		*gApplication;	// The application that's running the task
    BR_NewHandlerFunction  		gNewHandler;    // The new handler
	unsigned long      			gLastRequested; // The last requested block size     
	
#ifdef BR_BUILD_MAC
	static void			SetMemoryHeap(BR_CMemoryHeap *aMemoryHeap);
	static void			InitializeMemoryHeap();
	static void			TerminateMemoryHeap();
#endif

private:
	static void 			DefaultNewHandler();
};

//----------------------------------------------------------------------------------------
//	BR_CApplicationTaskGlobals::GetTaskGlobals
//----------------------------------------------------------------------------------------

inline BR_CApplicationTaskGlobals* BR_CApplicationTaskGlobals::GetTaskGlobals()
{
	return (BR_CApplicationTaskGlobals*) BR_CBedTaskGlobals::GetTaskGlobals();
}

#endif
