#if !defined(BRAPPLEE_H) && !defined(__BEDRC__)
#define BRAPPLEE_H
//========================================================================================
//
//     File:			BRAppleE.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	2/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRMESSAG_H
#include "BRMessag.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__APPLEEVENTS__)
#include <AppleEvents.h>
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CModule;

//template<class tCharacter>
//class BR_TString;


#ifdef BR_BUILD_MAC
//========================================================================================
// Resource Id constants for the apple event dispatch table resources
//========================================================================================

#define BR_RequiredAEDispatchTableResourceId 1

#define BR_UserAEDispatchTableResourceId 1000
#endif


#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_SAppleEventDispatchTable
//========================================================================================

struct BR_SAppleEventDispatchTable
{
	short fNumberOfEntries;
	struct
	{
		BR_ResourceType fEventClass;
		BR_ResourceType fEventId;
		long fMessageId;
	} fTable[1];
};
#endif


#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_CVoidPtrSet
//========================================================================================

class BR_CVoidPtrSet : public _BR_CAutoDestructObject
{
};

#endif

#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_CHandleSet
//========================================================================================

class BR_CHandleSet
{
};

#endif

#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_CAppleEvent
//========================================================================================

class BR_CAppleEvent : public BR_CMessage
{
public:
	BR_CAppleEvent();
	BR_CAppleEvent(const BR_CAppleEvent &appleEvent);
	BR_CAppleEvent &operator=(const BR_CAppleEvent &appleEvent);
	virtual ~BR_CAppleEvent();
	
	BR_CAppleEvent(const AppleEvent &appleEvent);
	
	static void Initialize(const BR_CModule &module);
	static void Terminate(const BR_CModule &module);
	static void ThrowExceptionIfAppleEventError(const BR_CAppleEvent *appleEvent,
												OSErr error);

	virtual void GetAddress(AEAddressDesc& theAddress) const;		
	virtual void SetAddress(const AEAddressDesc& theAddress);

	virtual short GetPriority() const;
	virtual void SetPriority(short thePriority);

	virtual long GetReturnID() const;
	virtual void SetReturnID(long returnID);
	
	virtual long GetSendingMode() const;
	virtual void SetSendingMode(long sendingMode);

	virtual long GetTimeoutVal() const;
	virtual void SetTimeoutVal(long theTimeoutVal);

	virtual long GetTransactionID() const;
	virtual void SetTransactionID(long transactionID);

	virtual short ReadShort(AEKeyword key) const;
									
	virtual long ReadLong(AEKeyword key) const;
								 
	virtual void ReadString(AEKeyword key, BR_TString<BR_Char>& string) const;
								 
	virtual BR_CVoidPtrSet *ReadPtrList(AEKeyword key,
										DescType type,
										Size maximumSize) const;

	virtual BR_CHandleSet *ReadHandleList(AEKeyword key,
										  DescType theType) const;

	virtual void ReadParameter(AEKeyword key, DescType desiredType, AEDesc& data) const;

	virtual void ReadParameterPtr(AEKeyword key,
								  DescType desiredType,
								  DescType& actualType,
								  void *data,
								  long maximumSize,
								  long& actualSize) const;

protected:

private:
	static pascal OSErr AppleEventsDispatch(AppleEvent *message,
											AppleEvent *reply,
											long appleEventInfo);

	AppleEvent fAppleEvent;
	long fSendingMode;
	short fPriority;
	long fTimeout;
};
#endif

#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_CAppleEventMessanger
//========================================================================================

class BR_CAppleEventMessanger : public BR_CMessanger
{
public:
	BR_CAppleEventMessanger();
	BR_CAppleEventMessanger(const BR_CAppleEventMessanger &messanger);
	BR_CAppleEventMessanger &operator=(const BR_CAppleEventMessanger &messanger);
	virtual ~BR_CAppleEventMessanger();
	
	BR_CAppleEventMessanger(BR_CAppleEvent *message,
							BR_CAppleEvent *reply,
							MessageId messageId);

	virtual BR_CBureaucrat *GetTarget();
};
#endif

#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_XAppleEvent
//========================================================================================

class BR_XAppleEvent : public BR_XBedException
{
public:
	BR_XAppleEvent();
	BR_XAppleEvent(const BR_CAppleEvent *appleEvent);
	BR_XAppleEvent(const BR_CAppleEvent *appleEvent, PlatformError error);
	virtual ~BR_XAppleEvent();

	const BR_CAppleEvent *GetAppleEvent() const;
	
private:
	const BR_CAppleEvent *fAppleEvent;
};
#endif

#endif
