#if !defined(BRADORN2_H) && !defined(__BEDRC__)
#define BRADORN2_H
//========================================================================================
//
//     File:			BRAdorn2.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	2/25/93
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRADORN1_H
#include "BRAdorn1.h"
#endif

#ifndef BRWALLPA_H
#include "BRWallpa.h"
#endif

#ifndef BRFONT_H
#include "BRFont.h"
#endif

#ifndef BRPEN_H
#include "BRPen.h"
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif

//========================================================================================
//	class BR_CShapeAdorner
//========================================================================================

class BR_CShapeAdorner : public BR_CBaseShapeAdorner
{
public:
	virtual void 	PreDraw(BR_CView *view);
	virtual void 	PostDraw(BR_CView *view);

	virtual		~BR_CShapeAdorner();

	void			GetShapeBounds(BR_CRectangle& bounds) const;
	void			SetShapeBounds(const BR_CRectangle& bounds);
	
protected:
	BR_CShapeAdorner(AdornerId adornerId,
					BR_Boolean autoDelete,
					BR_Boolean sharedAdorner,
				  	BR_CPen::PenThickness penThickness,
				  	const BR_CColor& penColor,
				  	BR_CPen::PenStyle penStyle,
				  	const BR_CColor& fillColor);

	BR_CShapeAdorner(const BR_CModule& module,
				  	BR_SResource& resource);

private:
	BR_CDeferredWallPaper 		fWallPaper;
	BR_CGraphicsToolSelector 	fWallPaperSelector;
	BR_CRectangle				fShapeBounds;
	
	BR_SETCLASSNAME(BR_CShapeAdorner);
};

//----------------------------------------------------------------------------------------
//	BR_CShapeAdorner::GetShapeFrame
//----------------------------------------------------------------------------------------
inline void BR_CShapeAdorner::GetShapeBounds(BR_CRectangle& bounds) const
{
	bounds = fShapeBounds;
}

//----------------------------------------------------------------------------------------
//	BR_CShapeAdorner::SetShapeFrame
//----------------------------------------------------------------------------------------
inline void BR_CShapeAdorner::SetShapeBounds(const BR_CRectangle& bounds)
{
	fShapeBounds = bounds;
}

//========================================================================================
//	struct BR_SShapeAdornerRes
//========================================================================================

struct BR_SShapeAdornerRes : BR_SBaseShapeAdornerRes
{
	BR_CColor::RGBValue fBackgroundRGBValue;
};

//========================================================================================
//	class BR_CRectangleAdorner
//========================================================================================

class BR_CRectangleAdorner : public BR_CShapeAdorner
{
public:
	BR_CRectangleAdorner(AdornerId adornerId,
						BR_Boolean autoDelete,
						BR_Boolean sharedAdorner,
					  	const BR_CRectangle& shapeBounds,
					  	BR_CPen::PenThickness penThickness,
					  	const BR_CColor& penColor,
					  	BR_CPen::PenStyle penStyle,
					  	const BR_CColor& fillColor);

	BR_CRectangleAdorner(const BR_CModule& module,
					 	 BR_SResource& resource);

	virtual~ BR_CRectangleAdorner();

	virtual void Draw(BR_CView *view, const BR_CRectangle &area);

	BR_SETCLASSNAME(BR_CRectangleAdorner);
};

//========================================================================================
//	struct BR_SRectangleAdornerRes
//========================================================================================

struct BR_SRectangleAdornerRes : BR_SShapeAdornerRes
{
	BR_SRectangle 		fShapeBounds;
};

//========================================================================================
//	class BR_CRoundRectAdorner
//========================================================================================

class BR_CRoundRectAdorner : public BR_CRectangleAdorner
{
public:
	BR_CRoundRectAdorner(AdornerId adornerId,
					  BR_Boolean autoDelete,
					 BR_Boolean sharedAdorner,
					  const BR_CRectangle& shapeBounds,
					  BR_Distance roundRectWidth,
					  BR_Distance roundRectHeight,
					  BR_CPen::PenThickness penThickness,
					  const BR_CColor& penColor,
					  BR_CPen::PenStyle penStyle,
					  const BR_CColor& fillColor);

	BR_CRoundRectAdorner(const BR_CModule& module,
					  	BR_SResource& resource);

	virtual~ BR_CRoundRectAdorner();

	virtual void Draw(BR_CView *view, const BR_CRectangle &area);

private:
	BR_Distance fRoundRectWidth;
	BR_Distance fRoundRectHeight;

	BR_SETCLASSNAME(BR_CRoundRectAdorner);
};

//========================================================================================
//	struct BR_SRoundRectAdornerRes
//========================================================================================

struct BR_SRoundRectAdornerRes : BR_SRectangleAdornerRes
{
	BR_Distance fRoundRectWidth;
	BR_Distance fRoundRectHeight;
};

#ifdef BR_BUILD_MAC
//========================================================================================
//	class BR_CMacDefaultButtonAdorner
//========================================================================================

class BR_CMacDefaultButtonAdorner : public BR_CRoundRectAdorner
{
public:
	BR_CMacDefaultButtonAdorner();
	virtual ~BR_CMacDefaultButtonAdorner();
	
	virtual void Draw(BR_CView *view, const BR_CRectangle &area);
	
	BR_SETCLASSNAME(BR_CMacDefaultButtonAdorner);
};
#endif

//========================================================================================
//	class BR_CEllipseAdorner
//========================================================================================

class BR_CEllipseAdorner : public BR_CShapeAdorner
{
public:
	BR_CEllipseAdorner(AdornerId adornerId,
					BR_Boolean autoDelete,
					BR_Boolean sharedAdorner,
					const BR_CRectangle& shapeBounds,
					BR_CPen::PenThickness penThickness,
					const BR_CColor& penColor,
					BR_CPen::PenStyle penStyle,
					const BR_CColor& fillColor);

	BR_CEllipseAdorner(const BR_CModule& module,
						BR_SResource& resource);

	virtual~ BR_CEllipseAdorner();

	virtual void Draw(BR_CView *view, const BR_CRectangle &area);

	BR_SETCLASSNAME(BR_CEllipseAdorner);
};

//========================================================================================
//	struct BR_SEllipseAdornerRes
//========================================================================================

struct BR_SEllipseAdornerRes : BR_SShapeAdornerRes
{
	BR_SRectangle 		fShapeBounds;
};

//========================================================================================
//	class BR_CGroupBox
//========================================================================================

class BR_CGroupBox : public BR_CAdorner
{
public:
	BR_CGroupBox(AdornerId adornerId);

	virtual		~BR_CGroupBox();

	virtual void	PreDraw(BR_CView *view);
	virtual void 	Draw(BR_CView *view, const BR_CRectangle &area);
	virtual void	PostDraw(BR_CView *view);

private:
	BR_CDeferredWallPaper 		fWallPaper;
	BR_CGraphicsToolSelector 	fWallPaperSelector;
	BR_CDeferredPen				fPen;
	BR_CGraphicsToolSelector 	fPenSelector;
	BR_CGraphicsToolSelector	fFontSelector;
	short						fHalfFontHeight;
	
	BR_SETCLASSNAME(BR_CGroupBox);
};

//========================================================================================
//	class BR_CEraseAdorner
//========================================================================================

class BR_CEraseAdorner : public BR_CAdorner
{
public:
	BR_CEraseAdorner();

	BR_CEraseAdorner(const BR_CModule& module,
						BR_SResource& resource);

	virtual		~BR_CEraseAdorner();

	virtual void 	Draw(BR_CView *view, const BR_CRectangle &area);

	BR_SETCLASSNAME(BR_CEraseAdorner);
};

//========================================================================================
//	struct BR_SEraseAdorner
//========================================================================================

struct BR_SEraseAdorner : BR_SAdornerResource
{
};

//========================================================================================
//	class BR_CDrawAdorner
//========================================================================================

class BR_CDrawAdorner : public BR_CAdorner
{
public:
	BR_CDrawAdorner();

	BR_CDrawAdorner(const BR_CModule& module,
						BR_SResource& resource);

	virtual	~BR_CDrawAdorner();

	virtual void 	Draw(BR_CView *view, const BR_CRectangle &area);

	BR_SETCLASSNAME(BR_CDrawAdorner);
};

//========================================================================================
//	struct BR_SDrawAdorner
//========================================================================================

struct BR_SDrawAdorner : BR_SAdornerResource
{
};

#endif