name Allen-Bradley 4500 (Metric)

N >4
G 2
X ->43
Y ->43
Z ->43
I ->43
J ->43
Q ->43
R ->43
P ->43
F >41
A >42 F
H 4
D >2
T >5
M >2
S >4

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    
ModalLetters X Y Z F                  # List of letters that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    


Feed G<1>                             # Linear move                       
Rapid F<200>                          # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Peck                                  # Pecking canned/manual cycle       
none                                    
end

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
G<90> G<94> G<0> G<17>
G<92> X<WorkH> Y<WorkV> Z<WorkD>
End

1stToolChange                         # First tool change                 
T<Tool>
H<0>
M<19>
M<6>
M<Direct> S<Speed>
X<H> Y<V> F<200> M<Cool>
H<Lcomp>
Z<VClear> F<60>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> A<Plunge>
H<Dcomp>
G<92> A<5000>
G<Side> X<H> Y<V> F<FRate>
end

ExactStop
G<4> F<600>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V> 
Z<D> F<60>
end

ToolChange                            # Secondary tool changes            
T<Tool> M<9>
H<0>
M<19>
M<6>
M<Direct> S<Speed>
X<H> Y<V> F<200> M<Cool>
H<Lcomp>
Z<VClear> F<60>
End

EndCode                               # End of the program                
T<Tool1> M<9>
H<0>
M<19>
X<WorkH> Y<WorkV> Z<WorkD> F<200>
M<2>
End

name ACL Output (Metric)

c 00
g 00
p >8
x ->4.>3  
y ->4.>3
z ->4.>3
X ->4.>3  
Y ->4.>3  
Z ->4.>3  
I ->4.>3 ""
J ->4.>3 ""
K ->4.>3 ""
f >3.>3
i 00
t >2
l >2
u 00
G >2
e 00
h 00


HCode x                               # X or X U  'Horizontal char.       
VCode y                               # Y or Y V  'Vertical char.         
Dcode z                               # Depth char.                       
FeedCode f                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

LineCode                              # Linear move                       
g<0> x<H> y<V> z<D>
end

CwCode                                # CW circular move                  
c<0> I<Hctr> J<Vctr> K<D>
I<0.0> J<0.0> K<1.0>
x<H> y<V> z<D>
end

CcwCode                               # CCW circular move                 
c<0> I<Hctr> J<Vctr> K<D>
I<0.0> J<0.0> K<1.0>
x<H> y<V> z<D>
end


  # Tape start code:
StartCode                             # Start of the program              
p<Program#>
f<FRate> i<0>
End


1stToolChange                         # First tool change                 
t<Tool> l<Lcomp>
End

Infeed                                # Enable cutter comp                
u<0> G<Side>
g<0> x<H> y<V>
end


Outfeed                               # Disable cutter comp               
u<0> G<40>
g<0> x<H> y<V>
end

ToolChange                            # Secondary tool changes            
g<0> x<H> y<V> z<ToolD>
t<Tool> l<Lcomp>
End

EndCode                               # End of the program                
e<0>
h<0>
End

Replace "c" with "CIRCLE"
Replace "g" with "GOTO"
Replace "p" with "PARTNO "
Replace "i" with "IPM"
Replace "u" with "CUTCOM"
Replace "G41" with "LEFT"
Replace "G42" with "RIGHT"
Replace "G40" with "OFF"
Replace "t" with "LOADTL "
Replace "e" with "END"
Replace "h" with "FINI"
Replace "f" with "FEDRAT "
Replace "x" with ""
Replace "y" with ""
Replace "z" with "" 
Replace "G0" with ""
Replace "l" with ""

name ANILAM Crusader Series M    <<< EVENT STYLE >>> (Metric)

% 00       
g 00
r 00
G >2       
X ->4.>3   
Y ->4.>3   
Z ->4.>3   
A ->4.>3   
I ->4.>3 X    
J ->4.>3 Y  
K ->4.>3   
Q ->4.>3   
R ->4.>3   
P >40      
f >3.1     
F >3.1
H >2       
D >2       
T >2 add 1000
t >2 T    
M >2       
S >4
V >2
v ->4.>3 ""

c 00
e 00
w 00       

ModalLetters X Y Z F f                # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode f                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed g<0>                             # Linear move                       
Rapid r<0>                            # Rapid positioning word            
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
                        
Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap 7                                # Left handed tapping cycle         
V<20> v<Frate>
V<21> v<Vclear>
V<22> v<Dwell>
V<24> v<RPlane>
r<0> X<H> Y<V> 
G<82>
Z<D>
r<0> X<H> Y<V>
end cancel

Drill 5                               # Drilling canned/manual cycle      
V<20> v<Frate>
V<21> v<Vclear>
r<0> X<H> Y<V>
G<81>
r<0> Z<D>
r<0> X<H> Y<V>
end cancel

Peck 7                                # Pecking canned/manual cycle       
V<20> v<Frate>
V<21> v<Vclear>
V<23> v<VBite>
V<24> v<RPlane>
r<0> X<H> Y<V>
G<83> 
r<0> Z<D> 
r<0> X<H> Y<V>
end cancel

Tap 7                                 # Tapping canned/manual cycle       
V<20> v<Frate>
V<21> v<Vclear>
V<23> v<VBite>
V<24> v<RPlane>
r<0> X<H> Y<V>
G<87> 
r<0> Z<D>
r<0> X<H> Y<V> 
end cancel

Ream 6                                # Reaming canned/manual cycle       
V<20> v<Frate>
V<21> v<Vclear>
V<24> v<RPlane>
r<0> X<H> Y<V>
G<85> 
r<0> Z<D> 
r<0> X<H> Y<V>
end cancel

Bore 7                                # Boring canned/manual cycle        
V<20> v<Frate>
V<21> v<Vclear>
V<23> v<VBite>
V<24> v<RPlane>
r<0> X<H> Y<V>
G<86> 
r<0> Z<D> 
r<0> X<H> Y<V>
end cancel

Back 7                                # Back boring canned/manual cycle   
V<20> v<Frate>
V<21> v<Vclear>
V<22> v<Dwell>
V<24> v<RPlane>
r<0> X<H> Y<V>
G<89> 
r<0> Z<D>
r<0> X<H> Y<V>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

LineCode                              # Linear move                       
f<Frate>
g<0> X<H> Y<V> Z<D>
end

Rapidcode                             # Rapid move                        
r<0> X<H> Y<V> Z<D>
end

CwCode                                # CW circular move                  
c<0>
g<0> I<HCtr> J<VCtr> 
g<0> X<H> Y<V>
c<0>
end

CcwCode                               # CCW circular move                 
w<0>
g<0> I<HCtr> J<VCtr>
g<0> X<H> Y<V>
w<0>
end

StartCode                             # Start of the program              
%<0>                          
End

1stToolChange                         # First tool change                 
T<Tool> 
r<0> X<ToolDiam> Z<0>                   
t<0>
f<FRate>
g<0> Z<0>
G<92>
r<0> X<0> Y<0>
t<Tool>
r<0> X<H> Y<V>
f<0> Z<D>
End

Infeed                                # Enable cutter comp                
G<Side> 
f<Frate>
g<0> X<H> Y<V>
end

Outfeed                               # Disable cutter comp               
G<40>
g<0> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
t<0>
r<0> Z<0>
T<Tool> 
r<0> X<ToolDiam> Z<0>                    #Change Z to normal setup height.
t<0>
f<FRate>
g<0> Z<D>
t<Tool>
End

EndCode                               # End of the program                
t<0>
r<0> Z<0>
r<0> X<0> Y<0>
e<0>
%<0>
End

Replace "c" with "ARC CW"
Replace "w" with "ARC CCW"
Replace "e" with "END"
Replace "f" with "FEED "
Replace "r" with "RA"
Replace "g" with "FA"
Replace "FEED 0.0" with ""

name APTCL  (Metric)

c 00
g >2
G >2
h 00
r 00
d >2
p >8
x ->4.3 "" 
y ->4.3 ,
z ->4.3 ,
X ->4.>3  
Y ->4.>3  
Z ->4.>3  
i ->4.>3 ""
j ->4.>3 ,
k ->4.>3 ,
F >3.>3 ,
q 00
R ->4.>3 ,
f >3.3
t >2
l >2
e 00
s >4
m >2
a >4.>3            
b >4.>3 ,          
o 00
n >4.>3 ,
) 00


ModalLetters f                        # List of letters that are modal    
ModalGs                               # List of g codes that are modal    

HCode x                               # X or X U  'Horizontal char.       
VCode y                               # Y or Y V  'Vertical char.         
Dcode z                               # Depth char.                       
FeedCode f                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
              
Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

Drill 1                               # Drilling canned/manual cycle      
G<81> z<D> F<FRate> q<0> R<Vclear>
g<1> x<H> y<V>
end cancel

Peck 1                                # Pecking canned/manual cycle       
G<83> z<D> F<Frate> q<0> R<Vclear> o<0> n<VBite>
g<1> x<H> y<V>
end cancel

Tap 1                                 # Tapping canned/manual cycle       
G<84> z<D> F<Frate> q<0> R<Vclear>
g<1> x<H> y<V>
end cancel

Ream 1                                # Reaming canned/manual cycle       
G<85> z<D> F<FRate> q<0> R<Vclear>
g<1> x<H> y<V>
end cancel

Bore 1                                # Boring canned/manual cycle        
G<86> z<D> F<FRate> q<0> R<Vclear>
g<1> x<H> y<V>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

RapidCode                             # Rapid move                        
g<0>
g<1> x<H> y<V> z<D>
end

LineCode                              # Linear move                       
f<FRate>
g<1> x<H> y<V> z<D>
end

CwCode                                # CW circular move                  
c<0> i<Hctr> j<Vctr> k<D>
i<0.0> j<0.0> k<1.0>
x<H> y<V> z<D>
end

CcwCode                               # CCW circular move                 
c<0> i<Hctr> j<Vctr> k<D>
i<0.0> j<0.0> k<1.0>
x<H> y<V> z<D>
end

StartCode                             # Start of the program              
p<Program#>
End

1stToolChange                         # First tool change                 
t<Tool> l<Lcomp>
s<Speed> m<Direct>
a<ToolDiam> b<ToolRad>
m<Cool>
r<0> x<Val1> y<Val2> z<Val3>
g<0>
g<1> x<H> y<V> z<D>
End

Infeed                                # Enable cutter comp                
G<Side>
g<1> x<H> y<V>
end


Outfeed                               # Disable cutter comp               
G<40>
g<1> x<H> y<V>
end

ToolChange                            # Secondary tool changes            
g<0> 
g<1> x<Val1> y<Val2> z<Val3>
m<9>
m<1>
t<Tool> l<Lcomp>
s<Speed> m<Direct>
a<ToolDiam> b<ToolRad>
m<Cool>
r<0> x<Val1> y<Val2> z<Val3>
g<0>
g<1> x<H> y<V> z<D>
End

EndCode                               # End of the program                
g<0>
g<1> x<Val1> y<Val2> z<Val3>
m<9>
e<0>
h<0>
End

Ask <Val1> "Enter X axis home position: " "10.0"
Ask <Val2> "Enter Y axis home position: " "10.0"
Ask <Val3> "Enter Z axis home position: " "10.0"


Replace "r" with "FROM/"
Replace "c" with "CIRCLE/"
Replace "g0" with "RAPID"
Replace "g1" with "GOTO/"
Replace "p" with "PARTNO/"
Replace "G41" with "CUTCOM/LEFT"
Replace "G42" with "CUTCOM/RIGHT"
Replace "G40" with "CUTCOM/OFF"
Replace "t" with "LOADTL/ "
Replace "e" with "END"
Replace "h" with "FINI"
Replace "f" with "FEDRAT/IPM,"
Replace "x" with ""
Replace "y" with ""
Replace "z" with "" 
Replace "l" with ",OSETNO,"
Replace "s" with "SPINDL/RPM,"
Replace "m3" with ",CLW"
Replace "m4" with ",CCLW"
Replace "m8" with "COOLNT/ON"
Replace "m9" with "COOLNT/OFF"
Replace "m7" with "COOLNT/MIST"
Replace "q" with ",IPM"
Replace "G81" with "CYCLE/DRILL"
Replace "G83" with "CYCLE/DEEP"
Replace "G84" with "CYCLE/TAP"
Replace "G85" with "CYCLE/REAM"
Replace "G86" with "CYCLE/BORE"
Replace "G80" with "CYCLE/OFF"
Replace "o" with ", INCR"
Replace "a" with "CUTTER/"
Replace "m1" with "OPSTOP"

name Bandit 4 (Metric)

% 00
N >4
G >2
O >4
X ->4.>3
Y ->4.>3
Z ->4.>3
I ->4.>3
J ->4.>3
K ->4.>3
Q ->4.>3
R ->4.>3
F >4.1
D >2  
T >2  
M >2  
S >4  

ModalLetters X Y Z F                  # List of letters that are modal    
ModalGs 73 74 76 80 81 82 83 84 85    # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ;                             # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
               
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Frate> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>
G<90>
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
O<0>        
G<0> Z<0>
O<Tool>
M<Direct>
M<Cool>
G<45> O<Work>
G<0> X<H> Y<V>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
O<0>
G<0> Z<0>
X<0> Y<0>
M<9>
M<5>
O<Tool>
M<Direct>
M<Cool>
G<45> O<Work>
G<0> X<H> Y<V>
End

EndCode                               # End of the program                
O<0>
G<0> Z<0>
M<02>
%<0>
End

name Cincinnati Milacron 850MC SX   *** 3 axis *** (Metric)

% 00
: 00      
/ 00      
O >2      
N >4      
G >2      
e 00
X ->4.>3  
Y ->4.>3  
Z ->4.>3  
I ->4.>3  
J ->4.>3  
K ->4.>3  
Q ->4.>3  
R ->4.>3  
P >40 
S >4    
F >3.1    
H >2      
D >2      
b 00
T >2      
c 00
M >2      
U ->4.>3
V ->4.>3
j >1 J
m >6
) 00

ModalLetters X Y Z F R                # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment (MSG,                         # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Ask <Val10> "Enter 1 for full retract peck cycle, or 0 for chip-break: " "1"

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> K<VBite> R<Vclear> F<FRate> j<Val10>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> U<0> V<SClear> I<0> K<0> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>         
:<0> G<0>                       
m<Program#> )<0>
End

Replace "e" with "="
Replace "b" with "["
Replace "c" with "]"
Replace "m" with "(MSG,PROGRAM NO. "

1stToolChange                         # First tool change                 
T<Tool> M<6>
S<Speed> F<FRate> M<Direct> M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
T<Tool> M<6>
S<Speed> F<FRate> M<Direct> M<Cool>
End

EndCode                               # End of the program                
M<2>
%<0>
End

name Deckel with Dialog II Control  (Metric)
    
N 4
% 00
? 00
a 1          
b 1          
c 1          
d 1          
G 2
f >32 F      
s +-2 S      
D +-2
h 2          
A +>43                      
X +->43
Y +->43
Z +->43
z +->43 Z    
I +->43
J +->43
F >32
K +->43
T 2
i 2          
j 2          
M 2
S +2
u +->43 Z    
v +->43 Z    
V 2
w +->43 Z        

ModalGs 1                             # List of g codes that are modal    
ModalLetters X Y Z F                  # List of letters that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
Rapid G<0>                            # Rapid positioning word            

RapidCode                             # Rapid move                        
N<Block> G<0> X<H> Y<V> Z<D>
end

LineCode                              # Linear move                       
N<Block> G<1> X<H> Y<V> Z<D>
end

CwCode                                # CW circular move                  
N<Block> G<2> F<FRate> X<H> Y<V> I<IVal> J<JVal>
end

CcwCode                               # CCW circular move                 
N<Block> G<3> F<FRate> X<H> Y<V> I<IVal> J<JVal>
end

Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

Drill                                 # Drilling canned/manual cycle      
N<Block> G<80>            
N<Block> G<0> X<H> Y<V>
N<Block> G<81> f<FRate> s<Speed> z<D> V<Dwell> w<RPlane>  
end

Back                                  # Back boring canned/manual cycle   
N<Block> G<80>
N<Block> G<0> X<H> Y<V>
N<Block> G<82> f<FRate> s<Speed> z<D> u<VBite> v<.05> V<Dwell> w<VClear>
end

Peck                                  # Pecking canned/manual cycle       
N<Block> G<80>
N<Block> G<0> X<H> Y<V>
N<Block> G<83> f<FRate> s<Speed> z<D> u<VBite> v<0> V<Dwell> w<VClear>
end

Tap                                   # Tapping canned/manual cycle       
N<Block> G<80>
N<Block> G<0> X<H> Y<V>
N<Block> G<84> f<FRate> s<Speed> z<D> w<VClear>
end

Ream                                  # Reaming canned/manual cycle       
N<Block> G<80>
N<Block> G<0> X<H> Y<V>
N<Block> G<85> f<FRate> s<Speed> z<D> V<Dwell> w<VClear>
end

Bore                                  # Boring canned/manual cycle        
N<Block> G<80>
N<Block> G<0> X<H> Y<V>
N<Block> G<86> f<FRate> s<Speed> z<D> V<Dwell> w<VClear>
end

Cancel                                # Cancel a canned/manual cycle      
N<Block> G<80>
end

StartCode                             # Start of the program              
b<1>      
b<1>      
b<1>
b<1>
b<1>
%<0>      
a<1>      
End

1stToolChange                         # First tool change                 
N<Block> T<Tool>
N<Block> S<Speed> M<Cool> F<FRate>
End

Infeed                                # Enable cutter comp                
N<Block> G<Side> D<DComp> h<45> A<0> X<H> Y<V> i<01> j<60> M<60>
end 

OutFeed                               # Disable cutter comp               
N<Block> X<H> Y<V>
N<Block> G<40> G<45> A<0>
end

ToolChange                            # Secondary tool changes            
N<Block> T<Tool> 
N<Block> S<Speed> M<Cool> F<FRate>
End

EndCode                               # End of the program                
N<Block> M<30>
b<1>                             
?<1>                             
d<1>                             
End

replace "b1" with ""
replace "a1" with "($P00/0000)" 
replace "d1" with "0000"
replace "M3 S" with "S+"         
replace "M4 S" with "S-"         
replace " M5" with ""            
replace "h" with "G"
replace "i" with "G"
replace "j" with "G"

name Dyna 2400 Conversational (Metric)

o 2                                # "START INS" program number
N 3 ""                             # Line number without "N"
t >2                               # "TOOL"
C >2                               # Arcs
X C13 S8 ->2.4 X                   # Line X-Value  "GO X"
Y C13 S8 ->2.4 Y                   # Line Y-Value  "GO Y"  
Z C13 S8 ->2.4 Z                   # Line Z-Value  "GO Z"
x C13 S8 ->2.4 x                   # Rapid X-Value "GOfX"
y C13 S8 ->2.4 y                   # Rapid Y-Value "GOfY"
z C13 S8 ->2.4 z                   # Rapid Z-Value "GOfZ"
I C13 S8 ->2.4 I                   # Arc X-Center  "   X"
J C13 S8 ->2.4 J                   # Arc Y-Center  "   Y"
a C13 S8 ->2.4 a                   # Arc Sweep Angle "   a"
i C13 S8 ->2.4 i                   # Canned Cycle X " X="
j C13 S8 ->2.4 j                   # Canned Cycle Y " Y="
c C13 S8 >2.4 c                    # Canned Cycle Clearance " ZH="
d C13 S8 >2.4 d                    # Canned Cycle Depth " Zd="
D 2                                # "DRILL PECK="
F C14 S5 >3.1 F                    # "FR XY" In Inches
P C14 S5 >3.1 P                    # "FR  Z" In Inches
M 2                                # Miscellaneous Codes
$ 00                               # For Internal use No code output

Comment ;                             # Begin End comment char.           

Replace "X" with "GO X"            # Replacements for lines
Replace "Y" with "   Y"
Replace "Z" with "   Z"

Replace "x" with "GOfX"            # Replacements for rapids
Replace "y" with "   Y"
Replace "z" with "   Z"

Replace "I" with "   X"            # Replacements for arcs
Replace "J" with "   Y"

Replace "F" with "FR XY ="         # Replacements for feed rates
Replace "P" with "FR  Z ="

Replace "D" with "DRIL PECK="      # Replacements for canned cycles
Replace "c" with " ZH="
Replace "d" with " Zd="
Replace "i" with " X= "
Replace "j" with " Y= "

Replace "C0" with "ZERO AT"        # Replacements for arcs
Replace "C2" with "GR"
Replace "C3" with "GR"
Replace "C1" with ">REF COODS"

Replace "o" with "START INS "      # Replacement for program number

Replace "M10" with "SETUP >zcxyu"  # Misc. "Conversational" replacements
Replace "M01" with "HALT"
Replace "M03" with "SPINDLE   ON"
Replace "M04" with "SPINDLE   ON"
Replace "M05" with "SPINDLE  OFF"
Replace "M11" with "CONTROL  1"
Replace "M12" with "SKIP TO  005"
Replace "M30" with "END NEWPART"

Replace "t" with "TOOL  "          # Replacement for tool

Replace " $" with ""               # Replacement for deleting space from EOB
Replace "$" with ""

ModalGs                               # List of g codes that are modal    

Sequence#s N 1 1 0                    # Char, freq, incr & start          
First#? Y                             # Y or N  'Output 1st sequence no.  
Last#? Y                              # Y or N  'Output last sequence no. 

ModalLetters Y Z y z                  # List of letters that are modal    

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    
                         
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode R                             # I J or R or I J K L               
Each $<0>                             # End of block word                 

LTap 5                                # Left handed tapping cycle         
D<0>
c<RPlane>
d<D>
i<H>
j<V>
end

Drill 5                               # Drilling canned/manual cycle      
D<0>
c<RPlane>
d<D>
i<H>
j<V>
end

Peck 5                                # Pecking canned/manual cycle       
D<0>
c<RPlane>
d<D>
i<H>
j<V>
end

Tap 5                                 # Tapping canned/manual cycle       
D<0>
c<RPlane>
d<D>
i<H>
j<V>
end

Cancel                                # Cancel a canned/manual cycle      
end

StartCode                             # Start of the program              
o<Program#>
End

1stToolChange                         # First tool change                 
t<Tool>
F<FRate>
P<Plunge>
M<10>
M<1>
M<3>
End

RapidCode                             # Rapid move                        
x<H>
y<V>
z<D>
end

LineCode                              # Linear move                       
X<H>
Y<V>
Z<D>
end

Infeed                                # Enable cutter comp                
X<H>
Y<V>
Z<D>
end

Outfeed                               # Disable cutter comp               
X<H>
Y<V>
Z<D>
end

CWCODE                                # CW circular move                  
C<0>
I<HCtr>
J<VCtr>
C<2> a<Sweep>
C<1>
end

CCWCODE                               # CCW circular move                 
C<0>
I<HCtr>
J<VCtr>
C<3> a<Sweep>
C<1>
end

ExactStop
end

ToolChange                            # Secondary tool changes            
M<5>
t<Tool>
F<FRate>
P<Plunge>
M<3>
End

EndCode                               # End of the program                
M<5>
M<11>
M<30>
End

name FADAL   (Metric)

% 00 
/ 00 
O >4 
L >4
N >4 
G >2 
S >4 
H >2 
D >2 
M >2 
T >2 
R ->4.>3 
z ->4.>3 Z
E >2
X ->4.>3  
Y ->4.>3  
Z ->4.>3  
I ->4.>3
J ->4.>3
K ->4.>3
F >4.>2 
Q ->4.>3
P ->4.>3
( 00
d >4.>3
e >4.>3
f >4.>3

replace "d" with "Tool Radius: "
replace "e" with "Tool Diam: "
replace "f" with "Tool Corner: "

ask <val1> "Enter work offset number: " "1"

ModalLetters X Y Z F                  # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 7 9 8                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
                
Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> G<99> R<Vclear> z<D> F<Frate> Q<VBite> X<H> Y<V>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> G<99> R<Vclear> z<D> F<FRate> Q<VBite> X<H> Y<V>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> G<99> R<Vclear> z<D> F<Speed> Q<VBite> X<H> Y<V>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Back                                  # Back boring canned/manual cycle   
G<76> G<99> R<Vclear> z<D> F<FRate> Q<Sclear> X<H> Y<V>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>             
O<Program#>      
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
M<6> T<Tool> (<0> d<ToolRad> e<ToolDiam> f<corner>
G<0> G<90> S<Speed> M<Direct> E<Val1> X<H> Y<V> 
H<Lcomp> M<Cool> Z<D>
End

Infeed                                # Enable cutter comp                
G<1> G<Side> X<H> Y<V> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
M<5> M<9>
G<0> G<49> G<90> Z<0>
M<6> T<Tool> (<0> d<ToolRad>
G<0> G<90> S<Speed> M<Direct> E<Val1> X<H> Y<V> 
H<Lcomp> M<Cool> Z<D>
End

EndCode                               # End of the program                
M<5> M<9>
G<0> G<49> G<90> Z<0>
E<0> X<0> Y<0>
M<6> T<Tool1>
M<2>
%<0>
End

name FADAL 4 Axis (Metric)

% 00            
/ 00            
O >4            
L >4
N >4            
G >2            
S >4            
H >2            
D >2            
M >2            
T >2            
R ->4.>3        
z ->4.>3 Z
E >2
X ->4.>3          
Y ->4.>3          
Z ->4.>3          
A ->3.>3 Limit -359.999 0 Incsign
I ->4.>3         
J ->4.>3         
K ->4.>3         
F >4.>2          
Q ->4.>3         
P ->4.>3         
( 00
d >4.>3
e >4.>3
f >4.>3

replace "d" with "Tool Radius: "
replace "e" with "Tool Diam: "
replace "f" with "Tool Corner: "

ask <val1> "Enter work offset number: " "1"

ModalLetters X Y Z F A                # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 7 9 8                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> G<99> R<Vclear> z<D> F<Frate> Q<VBite> X<H> Y<V>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> G<99> R<Vclear> z<D> F<FRate> Q<VBite> X<H> Y<V>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> G<99> R<Vclear> z<D> F<Speed> Q<VBite> X<H> Y<V>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Back                                  # Back boring canned/manual cycle   
G<76> G<99> R<Vclear> z<D> F<FRate> Q<Sclear> X<H> Y<V>  
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

Index X                               # Index the rotary table            
G<0> G<49> G<90> Z<0>
X<H> Y<V> A<RotAngle>
E<Val1>
H<Lcomp> M<Cool> Z<D>
end

UnWind                                # Unwind the rotary table           
G<0> G<49> G<90> Z<0>
A<0>
E<Val1>
H<Lcomp> M<Cool> Z<D>
G<0> X<LastH> Y<LastV> A<LastRotAng>
G<1> Z<LastD>
end

StartCode                             # Start of the program              
%<0>                            
O<Program#>                     
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
M<6> T<Tool> (<0> d<ToolRad> e<ToolDiam> f<corner>
G<0> G<90> S<Speed> M<Direct> E<Val1> X<H> Y<V> A<Rotangle>
H<Lcomp> M<Cool> Z<D>
End

Infeed                                # Enable cutter comp                
G<1> G<Side> X<H> Y<V> A<Rotangle> F<FRate>
end


Outfeed                               # Disable cutter comp               
G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
M<5> M<9>
G<0> G<49> G<90> Z<0>
M<6> T<Tool> (<0> d<ToolRad>
G<0> G<90> S<Speed> M<Direct> E<Val1> X<H> Y<V> A<Rotangle>
H<Lcomp> M<Cool> Z<D>
End

EndCode                               # End of the program                
M<5> M<9>
G<0> G<49> G<90> Z<0>
E<0> X<0> Y<0>
M<6> T<Tool1>
M<2>  
%<0>
End

name Fanuc 6MB (Metric)

% 00      
/ 00      
O >4      
N >4      
G >2      
X ->4.>3  
Y ->4.>3  
Z ->4.>3  
A ->4.>3  
I ->4.>3  
J ->4.>3  
K ->4.>3  
Q ->4.>3  
R ->4.>3  
P >40     
F >3.1    
H >2      
D >2      
T >2      
M >2      
S >4      
c 00

ModalLetters X Y Z F R                # List of letters that are modal    
ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
               
Spaces? N                             # Y or N  'Spaces between words     
Incremental? Y                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Frate> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>                   
O<Program#>
c<0>
G<91> G<28> Z<0>
G<90> G<80> G<40> G<17>
End

Replace "c" with "(TOOL 1 IN SPINDLE)"

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
M<Direct> S<Speed>
G<0> G<Work> X<H> Y<V> 
T<NextTool>
G<43> Z<D> H<Lcomp>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> D<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
G<91> G<28> Z<0> M<9>
M<6>
M<Direct> S<Speed>
G<90> G<0> X<H> Y<V>
T<NextTool>
G<43> Z<D> H<Lcomp>
M<Cool>
End

EndCode                               # End of the program                
G<91> G<28> Z<0> M<9>
G<91> G<28> X<0> Y<0> M<5>
T<Tool1>
M<6> 
M<30>
%<0>
End

name Fanuc 11M (Metric)

% 00              
/ 00              
O >4              
N >4              
G >2              
X ->4.>3          
Y ->4.>3          
Z ->4.>3          
A ->4.>3          
I ->4.>3          
J ->4.>3          
K ->4.>3          
Q ->4.>3          
R ->4.>3          
P >40             
F >3.1            
H >2              
D >2              
T >2              
M >2              
S >4              

ModalLetters X Y Z F R                # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
                         
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>                           
O<Program#>                    
G<90> G<80> G<40> G<17>        
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
T<Tool> M<6>
M<Direct> S<Speed>
G<0> G<Work> X<H> Y<V> 
G<43> Z<D> H<Lcomp>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> D<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
N<Block> T<Tool> M<6>
M<Direct> S<Speed>
G<0> X<H> Y<V>
G<43> Z<D> H<Lcomp>
M<Cool>
End

EndCode                               # End of the program                
G<90> G<0> G<49> Z<0>
M<6> T<Tool1>
X<0> Y<0>
M<2>
%<0>
End

name Fanuc 11M 4 Axis (Metric)

% 00 
/ 00 
O >4 
N >4 
G >2 
X ->4.>3
Y ->4.>3
Z ->4.>3
A ->3.>3 Limit -180 180
I ->4.>3
J ->4.>3
K ->4.>3
Q ->4.>3
R ->4.>3
P ->4.>3
F >3.2
H >2  
D >2  
T >2  
M >2  
S >4  

ModalLetters X Y Z F                  # List of letters that are modal    
ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
               
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Speed>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

Index X                               # Index the rotary table            
G<0> G<28> G<91> Z<0>
G<90> G<0> G<Work> X<H> Y<V> A<RotAngle>  
G<43> Z<D> H<Lcomp>
End

UnWind                                # Unwind the rotary table           
G<0> G<28> G<91> Z<0>
G<90> G<0> A<0>  
G<43> Z<D> H<Lcomp>
G<0> X<LastH> Y<LastV> A<LastRotAng>
G<1> Z<LastD>
End

StartCode                             # Start of the program              
O<Program#>
G<91> G<28> Z<0>
G<90>
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
/<0> N<Block> T<Tool> M<6>
G<0> G<40> G<80> G<Work> X<H> Y<V> A<RotAngle>  
G<43> Z<D> H<Lcomp> M<Direct> S<Speed>
M<Cool> T<NextTool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> D<DComp> F<FRate>  (apply cuttercomp)
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
M<9>
G<0> G<28> G<91> Z<0>
N<Block> M<6>
G<0> G<90> G<Work> X<H> Y<V> A<RotAngle>
G<43> Z<D> H<Lcomp> M<Direct> S<Speed>
M<Cool> T<NextTool>
End

EndCode                               # End of the program                
G<0> G<28> G<91> Z<0>
G<28> G<91> X<0> Y<0> M<6> A<0>
G<90> 
M<30>
End

name HAAS 4 axis (Metric)

% 00
/ 00
O >4
N >4
G >2
X ->4.>3
Y ->4.>3
Z ->4.>3
A ->4.>3 Limit -8000 8000
I ->4.>3
J ->4.>3
K ->4.>3
Q ->4.>3
R ->4.>3
P >40 
F >3.1
H >2  
D >2  
T >2  
M >2  
S >4  

ModalLetters X Y Z F A                # List of letters that are modal    
ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
              
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Frate> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

Index X                               # Index the rotary table            
G<0> G<49> G<90> Z<0>
G<Work> X<H> Y<V> A<Rotangle>
G<43> Z<D> H<Lcomp> M<Cool>
End

StartCode                             # Start of the program              
%<0>                     
O<Program#>              
G<90> G<80> G<40> G<17>  
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
T<Tool> M<6>
M<Direct> S<Speed>
G<0> G<Work> X<H> Y<V> A<Rotangle>
Z<D> H<Lcomp>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> D<DComp> A<Rotangle> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
G<0> G<49> Z<0> M<9>
N<Block> T<Tool> M<6>
G<0> G<90> G<Work> X<H> Y<V> S<Speed> M<Direct> A<Rotangle>
G<43> Z<D> H<Lcomp> M<Cool>
End

UnWind                                # Unwind the rotary table           
G<0> G<49> G<90> Z<0>
A<0>
G<43> Z<D> H<Lcomp> M<Cool>
G<0> X<LastH> Y<LastV> A<LastRotAng>
G<1> Z<LastD>
End

EndCode                               # End of the program                
G<0> G<49> G<90> Z<0> M<9>
G<28> G<91> Y<0> Z<0> A<0>
M<30>
%<0>
End

name Heidenhain TNC 155 Conversational (Metric)

O >4                      
e >4                      
i 00                      
N >4 ""                   
t >2                      
u >2                      
L 00                      
l +->4.>3 L               
C >2                      
X +->4.>3
Y +->4.>3
Z +->4.>3 Force
G >2
d >2.1                            
H 00 Z                            
W >2                              
Q ->4.>3                          
R ->4.>3 Force Modal              
r >2                              
F >31 Force Modal                 
M >2 Force Modal
m 00 M                            
S >4.1
s ->4.>3                          
z ->4.>3                          
w >4.>3                           

RevSigns s Q                          # List of letters to reverse signs  

Comment ( )                           # Begin End comment char.           

Replace "O" with "BEGIN PGM "     
Replace "i" with "INCH"
Replace "e" with "END PGM "
Replace "R0 " with "R "
Replace "G41 " with "RL "
Replace "G42 " with "RR "
Replace "G40 " with "R0 F M"
Replace "t" with "TOOL DEF "
Replace "u" with "TOOL CALL "
Replace "W0" with "R F M"         
Replace "W" with "R F M"          
Replace "r0" with "R F6000 M"     
Replace "r" with "R F6000 M"      

Replace "G2 " with "DR- "         
Replace "G3 " with "DR+ "
Replace "C1 " with "CC "
Replace "C0 " with "C "

Replace "d" with "CYCL DEF "      
Replace "EF 0.0 " with "EF 0.0 DRILL"
Replace "EF 1.0" with "EF 1.0 PECKING"
Replace "EF 2.0" with "EF 2.0 TAPPING"
Replace "s" with "SET UP "
Replace "z" with "DEPTH "
Replace "Q" with "PECKG "
Replace "w" with "DWELL "

ModalGs                               # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? Y                             # Y or N  'Output 1st sequence no.  
Last#? Y                              # Y or N  'Output last sequence no. 

ModalLetters X Y                      # List of letters that are modal    

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Feed L<10>                            # Linear move                       
Rapid L<10> r<0>                      # Rapid positioning word            

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    
                         
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

LTap 5                                # Left handed tapping cycle         
d<2>   
d<2.1> s<RPlane>
d<2.2> z<D>
d<2.3> w<Dwell>
d<2.4> F<FRate>
L<10> X<H> Y<V> R<0> F<600> M<99>
end

Drill 6                               # Drilling canned/manual cycle      
d<0>          
d<0.1> s<RPlane>
d<0.2> z<D>
d<0.3> Q<D>
d<0.4> w<Dwell>
d<0.5> F<FRate>
L<10> X<H> Y<V> R<0> F<600> M<99>
end

Peck 7                                # Pecking canned/manual cycle       
d<1>    p<0>
d<1.1> s<RPlane>
d<1.2> z<D>
d<1.3> Q<VBite>
d<1.4> w<Dwell>
d<1.5> F<FRate>
L<10> X<H> Y<V> r<99>
L<10> X<H> Y<V> W<99>
end

Tap 5                                 # Tapping canned/manual cycle       
d<2>   p<0>
d<2.1> s<RPlane>
d<2.2> z<D>
d<2.3> w<Dwell>
d<2.4> F<FRate>
L<10> X<H> Y<V> R<0> F<600> M<99>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
O<Program#> i<0>
End

1stToolChange                         # First tool change                 
t<Tool> l<0> R<ToolRad>
u<Tool> H<Lcomp> S<Speed>
L<10> X<H> Y<V> R<0> F<600> M<6>
L<10> Z<D> r<13>
End

Infeed                                # Enable cutter comp                
L<10> X<H> Y<V> G<Side> F<FRate> m<0>           
end

LineCode                              # Linear move                       
L<10> X<H> Y<V> Z<D> R<0> F<FRate> m<0>     
end

CWCODE                                # CW circular move                  
C<1> X<HCtr> Y<VCtr>
C<0> X<H> Y<V> G<2> W<0>                   
end

CCWCODE                               # CCW circular move                 
C<1> X<HCtr> Y<VCtr>
C<0> X<H> Y<V> G<3> W<0>                  
end

ExactStop
end

Outfeed                               # Disable cutter comp               
L<10> G<40> X<H> Y<V>   
end

ToolChange                            # Secondary tool changes            
L<10> Z<0> R<0> F<600> M<91>
t<Tool> l<0> R<ToolRad>
u<Tool> H<Lcomp> S<Speed>
L<10> X<H> Y<V> R<0> F<600> M<6>
L<10> Z<D> R<0> F<600> M<13>
End

EndCode                               # End of the program                
L<10> Z<0> R<0> F<600> M<91>
L<10> X<0> Y<0> M<2>
e<Program#> i<0>
End

name HURCO (Metric)

% 00              
O >4              
N >4              
G >2              
X ->4.>3          
Y ->4.>3          
x ->4.>3 X        
y ->4.>3 Y        
Z ->4.>3          
A ->4.>3          
I ->4.>3          
J ->4.>3          
K ->4.>3          
Q ->4.>3          
R ->4.>3          
P >40             
F >3.1            
H >2              
D >2              
T >2              
M >2              
S >4              
E 00

ModalLetters X Y Z F                  # List of letters that are modal    

ModalGs 0 1 2 3 73 74 75 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
                         
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

CwCode                                # CW circular move                  
G<2> G<17> x<H> y<V> I<HCtr> J<VCtr> F<FRate>
end

CcwCode                               # CCW circular move                 
G<3> G<17> x<H> y<V> I<HCtr> J<VCtr> F<FRate>
end

StartCode                             # Start of the program              
%<0>                           
G<0> G<17> G<71> G<90>         
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
S<Speed> T<Tool> M<6>
G<75> M<Direct>
G<0> X<H> Y<V> M<Cool>
Z<RPlane>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> H<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
G<0> Z<RPlane>
M<25>
G<90> X<ToolH> Y<ToolV> M<5>
S<Speed> M<Tool> M<6>
G<75> M<Direct>
G<0> X<H> Y<V> M<Cool>
G<0> Z<RPlane>
End

EndCode                               # End of the program                
G<0> Z<RPlane>
M<25>
G<90> X<ToolH> Y<ToolV> M<5>
M<2>
E<0>
%<0>
End

name Maho XY Plane (G17) (Metric)

% 00
N >5
G >2
X ->4.>3   
x ->4.>3 X 
Y ->4.>3   
y ->4.>3 Y 
Z ->4.>3   
z ->4.>3 Z 
I ->4.>3   
J ->4.>3   
K ->4.>3   
B ->4.>3   
F >3.1     
T >2       
M >2       
S >4       
W 00    

ModalLetters X Y z Z F                # List of letters that are modal    
ModalGs 0 1 2 3 81 83 84              # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

Drill 2                               # Drilling canned/manual cycle      
G<81> z<D> B<Rplane> F<Frate> Y<Vclear>
G<79> x<H> z<Sclear> y<V>
G<79> x<H> z<Sclear> y<V>
end        

Peck                                  # Pecking canned/manual cycle       
G<83> Z<D> B<RPlane> F<Frate> Y<Vclear> I<VBite> K<VBite>
G<79> x<H> z<Sclear> y<V> 
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> Z<D> B<RPlane> F<Frate> Y<Vclear> 
G<79> x<H> z<Sclear> y<v>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> Z<D> B<RPlane> F<Frate> Y<Vclear>
G<79> x<H> z<Sclear> y<V>
end cancel

Bore                                  # Boring canned/manual cycle        
end cancel

Back                                  # Back boring canned/manual cycle   
end cancel

Cancel                                # Cancel a canned/manual cycle      
end

StartCode                             # Start of the program              
%<0>        
N<Program#> 
G<18>
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
T<Tool> M<6>
M<Direct> S<Speed>
G<Work>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<1> Y<D> F<Plunge>
G<43> X<H> Y<V> F<FRate>
G<Side>
end

Outfeed                               # Disable cutter comp               
G<40>
G<1> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
G<0> X<ToolH> Y<ToolV> Z<ToolD> M<9>
T<Tool> M<6>
M<Direct> S<Speed>
G<Work>
End

EndCode                               # End of the program                
G<0> X<ToolH> Y<ToolV> Z<ToolD> M<9>
M<30>
W<0>
End

Replace "%" with "%PM"

name Mazak M32 ISO (Metric)

% 00   
/ 00   
O >4   
N >4   
G >2   
X ->43 
Y ->43 
Z ->43 
A ->43 
I ->43 
J ->43 
K ->43 
Q ->43 
R ->43 
F >44  
H >3   
D >3   
T >3   
M >2   
S >5   

ModalLetters X Y Z F R                # List of letters that are modal    
ModalGs                               # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

ZRestart? Y                           # Y or N  'New cycle if diff. depths

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>
O<Program#>
G<90> G<80> G<40> G<17>
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
G<28> Z<0> T<Tool> M<6>
M<Direct> S<Speed>
G<90> G<0> G<Work> X<H> Y<V> 
G<43> Z<D> H<Lcomp>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> D<DComp> F<FRate>
end


Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
M<9>
G<0> G<28> Z<0>
M<1>
T<Tool> M<6>
M<Direct> S<Speed>
G<90> G<0> G<WORK> X<H> Y<V>
G<43> Z<D> H<Lcomp>
M<Cool>
End

EndCode                               # End of the program                
M<9>
G<0> G<28> Z<0>
M<6> T<Tool1>
G<90> G<0> X<0> Y<0>
M<02>
%<0>
End
