name SURFCAM Ultimate Lathe Post (Metric)

  # (6/28/93) Surfware Inc. This file is a generic '*.L' file and can be used
  # as a template and appended to 'POSTFORM.L'.  Comments begin with two spaces
  # followed by a pound sign '#'.

  # Several functions are commented to initially restrict their use. To include
  # these functions, delete the first three characters at the beginning of the
  # command line '  #' which are  space, space, pound sign.

                  # Actual output ranges
% 00              # '%'
O >4              # 'O0 - O9999'
N >4              # 'N0 - N9999'
G >2              # 'G0 - G99'
X ->4.>3          # 'X-9999.999 - X9999.999'
Y ->4.>3          # 'Y-9999.999 - Y9999.999'
Z ->4.>3          # 'Z-9999.999 - Z9999.999'
A ->4.>3          # 'A-9999.999 - A9999.999' 
I ->4.>3          # 'I-9999.999 - I9999.999' 
J ->4.>3          # 'J-9999.999 - J9999.999' 
K ->4.>3          # 'K-9999.999 - K9999.999' 
Q ->4.>3          # 'Q-9999.999 - Q9999.999' 
R ->4.>3          # 'R-9999.999 - R9999.999' 
P >40             # 'P0 - P9999'
F >3.1            # 'F0.0 - F999.9'
H >2              # 'H0 - H99'
D >2              # 'D0 - D99' 
T >2              # 'T0 - T99' 
M >2              # 'M0 - M99' 
S >4              # 'S0 - S9999' 

 # Ask <Val1> "Cutoff speed" "200"    # Input up to 10 var. prior to posting
 # ByDiameter? N                      # Y or N  'Output X val. by diameter
 # Drive \dirname\                    # Output path                       
 # Dummy *                            # Columnar dummy line char.         
 # Each $<0>                          # End of block word                 
 # EOB 35                             # End of block char.                
 # Replace "d" with "DIAMETER"        # Search and replace up to 32 phrases
 # Replace "r" with "RADIUS"            supports upper and lower case
 # RevSigns Z K                       # List of letters to reverse signs  
 # RevTurret2 Y                       # Reverse X values for 2nd turret   
 # Spaces 64                          # Columnar line length              
 # Spaces? N                          # Y or N  'Spaces between words     
 # Tolerance .0002                    # Round off tolerance               
 # Tools                              # Specifies incremental tool changes

ModalLetters X Y Z F                  # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
 # HCode2 U                           # 2nd horizontal turret letter address
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   
FeedType 95 94                        # IPR & IPM g codes                 
SpeedType 96 97                       # CSS and RPM g codes               

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
LComp 43 49                           # On & Off codes                    
DComp 41 42 40                        # Left, Right & Cancel m codes      
 # CDC P Q                            # Cincinnati style DComp vectors    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
CtrCode K I                           # I J or R or I J K L               
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
 # 2ndCircleCode M<99>                # Second word for circular motion   
 # MaxRad 99 .001                     # Maximum arc radius & chordal dev. 
 # MinRad .0005                       # Minimum arc radius                

Inc/Abs G 91 90                       # Inc & Abs char. & values          
Incremental? N                        # Y or N  'Inc or abs output        

 # ZRestart? N                        # Y or N  'New cycle if diff. depths

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>                            
O<Program#>                     
G<90> G<80> G<40> G<17>         
End


ExactStop
G<4>
end

1stToolChange                         # First tool change                 
T<Tool> M<6>
G<FeedType> G<SpeedType> M<Direct> S<Speed>
G<0> G<Work> X<H> Y<V>
Z<D> H<Lcomp>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> F<Plunge>
G<Side> X<H> Y<V> H<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
N<Block> T<Tool> M<6>
G<FeedType> G<SpeedType> M<Direct> S<Speed>
G<0> X<H> Y<V>
G<43> Z<D> H<Lcomp>
M<Cool>
End

EndCode                               # End of the program                
M<6> T<Tool1>
G<0> G<90> G<49>
E<0> X<0> Y<0>
M<30>
%<0>
End

 # Optional sequences:
 
 # CwCode                             # CW circular move                  
 # G<2> X<V> Z<H> I<Ival> K<Kval> F<Frate>
 # G<199>
 # End

 # CcwCode                            # CCW circular move                 
 # G<3> X<V> Z<H> I<Ival> K<Kval> F<Frate>
 # G<299>
 # End

 # Custom1                            # 1st Custom canned/manual cycle    
 # G<78> Z<H> F<FRate>
 # end cancel

 # Custom2                            # 2nd Custom canned/manual cycle    
 # G<84> Z<H> F<FRate>
 # end cancel

 # Custom3                            # 3rd Custom canned/manual cycle    
 # G<85> Z<H> F<FRate>
 # end cancel

 # LineCode                           # Linear move                       
 # G<1> X<V> Z<H> 
 # G<499>
 # End

 # RapidCode                          # Rapid move                        
 # G<0> X<V> Z<H> 
 # G<399>
 # End

