name GE 550 Lathe (Absolute) (Metric)

N 3
G 2
X ->43
Z ->43
I ->43
K ->43
F >33
T 3
S 2
M 2

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 43 44 45                      # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            

CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid F<80>                           # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<32>
End

Drill                                 # Drilling canned/manual cycle      
Z<Depth> F<FRate>  
Z<H>
end
Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
Z<H> F<FRate>   
end cancel
Ream                                  # Reaming canned/manual cycle       
Z<H> F<FRate>   
end cancel

Bore                                  # Boring canned/manual cycle        
Z<H> F<FRate>    
Z<SClear>
end

Cancel                                # Cancel a canned/manual cycle      
end

StartCode                             # Start of the program              
G<1> X<WorkV> Z<WorkH> F<80>
End

1stToolChange                         # First tool change                 
G<92> X<0> Z<Length>
G<90> T<Tool> M<Direct>
G<94> S<Speed> M<Cool>
G<1> X<V> Z<H> F<80>
End

ToolChange                            # Secondary tool changes            
G<1> X<0> Z<LastLength> F<80>
T<0> M<1>
G<92> X<0> Z<Length>
G<90> T<Tool> M<Direct>
G<94> S<Speed> M<Cool>
G<1> X<V> Z<H> F<80>
End

EndCode                               # End of the program                
G<1> X<0> Z<LastLength> F<80> M<24>
M<25>
T<0> M<1>
G<1> X<EndV> Z<EndH> F<80>
M<30>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate> 
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate> 
end
