name Fanuc 0T  (Metric)

% 00
O >4
N >3
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
P ->4.>3
A 60 P
Q ->4.>3
q >4 Q
R ->4.>3
F >3.>6
T 2
t 2
S >4
M >2

ModalGs 0 1 2 3 73 76 80 81 82 83 84 85  # List of g codes that are modal    

First#? N                             # Y or N  'Output 1st sequence no.  
Sequence#s N 0 1 1                    # Char, freq, incr & start          
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
Dcomp 41 42 40                        # Left, Right & Cancel m codes      
                     
ByDiameter? Y                         # Y or N  'Output X val. by diameter
RevX? Y
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<3>                               # Circular move clockwise           
Ccw G<2>                              # Circular move counter clockwise   

Drill                                 # Drilling canned/manual cycle      
G<74> R<Depth>
G<74> Z<Depth> F<FRate>                   
end

Peck                                  # Pecking canned/manual cycle       
G<74> R<Depth>
G<74> Z<H> Q<SBite> F<FRate> 
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>   
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>   
end cancel

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>  
end

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> R<StartAng> P<Depth> q<Peck1> F<Frate>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>
O<Program#>
end

1stToolChange                         # First tool change                 
T<Tool>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Tool> t<Lcomp> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> Z<ToolH> T<Tool> t<0> M<9>
M<1>
T<Tool>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Tool> t<Lcomp> M<Cool>
End

EndCode                               # End of the program                
G<0> X<ToolH> Z<ToolH> T<Tool> t<0> M<9>
M<5>
M<30>
%<0>
End

Infeed                                # Enable cutter comp                
G<1> G<Side> X<V> Z<H> F<FRate>        
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>        
end

Replace "t" with ""
