name Citizen F10 Screw machine. (Metric)

O >4
N >3
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
P ->4.>3
Q ->4.>3
R ->4.>3
F >3.>5
T >2
S >2
M >2

ModalGs 0 1 2 3 4                     # List of g codes that are modal    
Sequence#s N 1 10 10                  # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 52 53 52                      # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                
ByDiameter? Y                         # Y or N  'Output X val. by diameter
RevX? N         
RevZ? Y         
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

Drill                                 # Drilling canned/manual cycle      
G<0> X<-1>
G<1> Z<H> U<0> F<FRate>
G<0> Z<SClear> T<0>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>
end

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>
end

AutoThread                            # Automatic thread canned cycle     
G<33>
End

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
O<Program#>
G<0> G<21> G<99> M<6>
G<69>
G<50> X<-.06> Z<0>
End

1stToolChange                         # First tool change                 
G<FeedType> G<SpeedType> M<Direct> S<Speed>                                                
G<0> Z<SClear>
T<Tool>
G<68>
M<Cool>
G<0> X<V> Z<SClear>
T<Comp> 
End 

ToolChange                            # Secondary tool changes            
T<0>
T<Tool>
G<FeedType> G<SpeedType> M<Direct> S<Speed>
M<Cool>
G<0> Z<SClear>
G<68>
T<Comp> 
End

EndCode                               # End of the program                
M<7>
G<0> X<-.06> Z<0> T<0>
M<2>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>     
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H>              
end
