name HAAS 4 axis (Metric)

% 00
/ 00
O >4
N >4
G >2
X ->4.>3
Y ->4.>3
Z ->4.>3
A ->4.>3 Limit -8000 8000
I ->4.>3
J ->4.>3
K ->4.>3
Q ->4.>3
R ->4.>3
P >40 
F >3.1
H >2  
D >2  
T >2  
M >2  
S >4  

ModalLetters X Y Z F A                # List of letters that are modal    
ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
              
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Frate> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

Index X                               # Index the rotary table            
G<0> G<49> G<90> Z<0>
G<Work> X<H> Y<V> A<Rotangle>
G<43> Z<D> H<Lcomp> M<Cool>
End

StartCode                             # Start of the program              
%<0>                     
O<Program#>              
G<90> G<80> G<40> G<17>  
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
T<Tool> M<6>
M<Direct> S<Speed>
G<0> G<Work> X<H> Y<V> A<Rotangle>
Z<D> H<Lcomp>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> D<DComp> A<Rotangle> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
G<0> G<49> Z<0> M<9>
N<Block> T<Tool> M<6>
G<0> G<90> G<Work> X<H> Y<V> S<Speed> M<Direct> A<Rotangle>
G<43> Z<D> H<Lcomp> M<Cool>
End

UnWind                                # Unwind the rotary table           
G<0> G<49> G<90> Z<0>
A<0>
G<43> Z<D> H<Lcomp> M<Cool>
G<0> X<LastH> Y<LastV> A<LastRotAng>
G<1> Z<LastD>
End

EndCode                               # End of the program                
G<0> G<49> G<90> Z<0> M<9>
G<28> G<91> Y<0> Z<0> A<0>
M<30>
%<0>
End
