name Fanuc 3000C (Metric)

N >4
G 2
X ->43
Y ->43
Z ->43
I ->43
J ->43
Q ->43
R ->43
P ->43
F >32
K ->43
H 2 
D 2
T 2
M 2
S 2

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 10 10                  # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    
Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>  
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
G<17> G<40> G<80> G<91>
G<45> X<0> H<62>
G<45> Y<0> H<63>
End

1stToolChange                         # First tool change                 
S<Speed>
G<91> G<45> Z<0> H<LComp> M<Direct> 
G<90> G<92> X<0> Y<0> Z<1> M<Cool>
G<0> X<H> Y<V>
Z<Rplane>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> F<Plunge>  
G<Side> X<H> Y<V> H<DComp> F<FRate>
end 

ExactStop
G<4> X<.01>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>  
Z<D> 
end

ToolChange                            # Secondary tool changes            
G<91> M<9>
G<28> Z<0> M<5>
T<Tool> 
M<6> S<Speed>
G<91> G<45> Z<0> H<LComp> M<Direct> 
G<90> G<92> X<0> Y<0> Z<1> M<Cool>
G<0> X<H> Y<V>
Z<Rplane>
End

EndCode                               # End of the program                
G<91> M<9>
G<28> Z<0> M<5>
G<28> X<0> Y<0> 
T<1>
M<6> 
M<30>
End
