name FADAL   (Metric)

% 00 
/ 00 
O >4 
L >4
N >4 
G >2 
S >4 
H >2 
D >2 
M >2 
T >2 
R ->4.>3 
z ->4.>3 Z
E >2
X ->4.>3  
Y ->4.>3  
Z ->4.>3  
I ->4.>3
J ->4.>3
K ->4.>3
F >4.>2 
Q ->4.>3
P ->4.>3
( 00
d >4.>3
e >4.>3
f >4.>3

replace "d" with "Tool Radius: "
replace "e" with "Tool Diam: "
replace "f" with "Tool Corner: "

ask <val1> "Enter work offset number: " "1"

ModalLetters X Y Z F                  # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 7 9 8                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
                
Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> G<99> R<Vclear> z<D> F<Frate> Q<VBite> X<H> Y<V>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> G<99> R<Vclear> z<D> F<FRate> Q<VBite> X<H> Y<V>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> G<99> R<Vclear> z<D> F<Speed> Q<VBite> X<H> Y<V>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> G<99> R<Vclear> z<D> F<FRate> X<H> Y<V>
end cancel

Back                                  # Back boring canned/manual cycle   
G<76> G<99> R<Vclear> z<D> F<FRate> Q<Sclear> X<H> Y<V>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>             
O<Program#>      
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
M<6> T<Tool> (<0> d<ToolRad> e<ToolDiam> f<corner>
G<0> G<90> S<Speed> M<Direct> E<Val1> X<H> Y<V> 
H<Lcomp> M<Cool> Z<D>
End

Infeed                                # Enable cutter comp                
G<1> G<Side> X<H> Y<V> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
M<5> M<9>
G<0> G<49> G<90> Z<0>
M<6> T<Tool> (<0> d<ToolRad>
G<0> G<90> S<Speed> M<Direct> E<Val1> X<H> Y<V> 
H<Lcomp> M<Cool> Z<D>
End

EndCode                               # End of the program                
M<5> M<9>
G<0> G<49> G<90> Z<0>
E<0> X<0> Y<0>
M<6> T<Tool1>
M<2>
%<0>
End
