name Dyna 2400 Conversational (Metric)

o 2                                # "START INS" program number
N 3 ""                             # Line number without "N"
t >2                               # "TOOL"
C >2                               # Arcs
X C13 S8 ->2.4 X                   # Line X-Value  "GO X"
Y C13 S8 ->2.4 Y                   # Line Y-Value  "GO Y"  
Z C13 S8 ->2.4 Z                   # Line Z-Value  "GO Z"
x C13 S8 ->2.4 x                   # Rapid X-Value "GOfX"
y C13 S8 ->2.4 y                   # Rapid Y-Value "GOfY"
z C13 S8 ->2.4 z                   # Rapid Z-Value "GOfZ"
I C13 S8 ->2.4 I                   # Arc X-Center  "   X"
J C13 S8 ->2.4 J                   # Arc Y-Center  "   Y"
a C13 S8 ->2.4 a                   # Arc Sweep Angle "   a"
i C13 S8 ->2.4 i                   # Canned Cycle X " X="
j C13 S8 ->2.4 j                   # Canned Cycle Y " Y="
c C13 S8 >2.4 c                    # Canned Cycle Clearance " ZH="
d C13 S8 >2.4 d                    # Canned Cycle Depth " Zd="
D 2                                # "DRILL PECK="
F C14 S5 >3.1 F                    # "FR XY" In Inches
P C14 S5 >3.1 P                    # "FR  Z" In Inches
M 2                                # Miscellaneous Codes
$ 00                               # For Internal use No code output

Comment ;                             # Begin End comment char.           

Replace "X" with "GO X"            # Replacements for lines
Replace "Y" with "   Y"
Replace "Z" with "   Z"

Replace "x" with "GOfX"            # Replacements for rapids
Replace "y" with "   Y"
Replace "z" with "   Z"

Replace "I" with "   X"            # Replacements for arcs
Replace "J" with "   Y"

Replace "F" with "FR XY ="         # Replacements for feed rates
Replace "P" with "FR  Z ="

Replace "D" with "DRIL PECK="      # Replacements for canned cycles
Replace "c" with " ZH="
Replace "d" with " Zd="
Replace "i" with " X= "
Replace "j" with " Y= "

Replace "C0" with "ZERO AT"        # Replacements for arcs
Replace "C2" with "GR"
Replace "C3" with "GR"
Replace "C1" with ">REF COODS"

Replace "o" with "START INS "      # Replacement for program number

Replace "M10" with "SETUP >zcxyu"  # Misc. "Conversational" replacements
Replace "M01" with "HALT"
Replace "M03" with "SPINDLE   ON"
Replace "M04" with "SPINDLE   ON"
Replace "M05" with "SPINDLE  OFF"
Replace "M11" with "CONTROL  1"
Replace "M12" with "SKIP TO  005"
Replace "M30" with "END NEWPART"

Replace "t" with "TOOL  "          # Replacement for tool

Replace " $" with ""               # Replacement for deleting space from EOB
Replace "$" with ""

ModalGs                               # List of g codes that are modal    

Sequence#s N 1 1 0                    # Char, freq, incr & start          
First#? Y                             # Y or N  'Output 1st sequence no.  
Last#? Y                              # Y or N  'Output last sequence no. 

ModalLetters Y Z y z                  # List of letters that are modal    

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    
                         
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode R                             # I J or R or I J K L               
Each $<0>                             # End of block word                 

LTap 5                                # Left handed tapping cycle         
D<0>
c<RPlane>
d<D>
i<H>
j<V>
end

Drill 5                               # Drilling canned/manual cycle      
D<0>
c<RPlane>
d<D>
i<H>
j<V>
end

Peck 5                                # Pecking canned/manual cycle       
D<0>
c<RPlane>
d<D>
i<H>
j<V>
end

Tap 5                                 # Tapping canned/manual cycle       
D<0>
c<RPlane>
d<D>
i<H>
j<V>
end

Cancel                                # Cancel a canned/manual cycle      
end

StartCode                             # Start of the program              
o<Program#>
End

1stToolChange                         # First tool change                 
t<Tool>
F<FRate>
P<Plunge>
M<10>
M<1>
M<3>
End

RapidCode                             # Rapid move                        
x<H>
y<V>
z<D>
end

LineCode                              # Linear move                       
X<H>
Y<V>
Z<D>
end

Infeed                                # Enable cutter comp                
X<H>
Y<V>
Z<D>
end

Outfeed                               # Disable cutter comp               
X<H>
Y<V>
Z<D>
end

CWCODE                                # CW circular move                  
C<0>
I<HCtr>
J<VCtr>
C<2> a<Sweep>
C<1>
end

CCWCODE                               # CCW circular move                 
C<0>
I<HCtr>
J<VCtr>
C<3> a<Sweep>
C<1>
end

ExactStop
end

ToolChange                            # Secondary tool changes            
M<5>
t<Tool>
F<FRate>
P<Plunge>
M<3>
End

EndCode                               # End of the program                
M<5>
M<11>
M<30>
End

