name Bridgeport Boss 5 (Metric)

: >4
N >4
G >2
X ->3.>3
Y ->3.>3
Z ->3.>3
A >4.>3 Z
I ->3.>3
J ->3.>3
Q ->3.>3
R ->3.>3
P ->3.>3
F >31
H >4
D >2
T >4
M >2
S >4

ModalLetters F Z                      # List of letters that are modal    
ModalGs 0 1 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 5 15                   # Char, freq, incr & start          
First#? Y                             # Y or N  'Output 1st sequence no.  

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment '                             # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> A<D> R<Vclear> F<FRate>  
end cancel
Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> A<D> R<Vclear> F<FRate>  
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> A<D> Q<VBite> R<Vclear> F<FRate>  
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> A<D> R<Vclear> F<FRate>     
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> A<D> R<Vclear> F<FRate>   
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> A<D> R<Vclear> F<FRate>   
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> A<D> R<Vclear> F<FRate>   
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
End

1stToolChange                         # First tool change                 
G<0> G<90> X<ToolH> Y<ToolV> G<75> T<Tool> M<6>
X<H> Y<V>
Z<VClear> 
End

Infeed                                # Enable cutter comp                
G<1> Z<D> F<Plunge>
G<Side> X<H> Y<V> F<FRate>
end

ExactStop
G<4> Q<0.01>
end

Outfeed                               # Disable cutter comp               
G<40> G<1> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
G<0> G<90> G<75> X<ToolH> Y<ToolV> T<Tool> M<6>
G<0> X<H> Y<V> 
Z<VClear>
End

EndCode                               # End of the program                
Z<RPlane>
M<9>
G<0> X<ToolH> Y<ToolV>
M<2>
End
