name Aciera  (Metric)

/ 00
N >4
X ->4.>3
Y ->4.>3
Z ->4.>3
I ->4.>3
J ->4.>3
L >4.>3
R ->4.>3
Q ->4.>3
P ->4.>3
F >22
K ->4.>3
S >4
M 2
T 2
H >2
D >2
G 2

ModalGs 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

ModalLetters F                        # List of letters that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 44                           # On & Off codes                    
Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

Drill                                 # Drilling canned/manual cycle      
G<0> X<H> Y<V>
G<1> Z<D> F<FRate> 
G<0> Z<RPLane>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<76> X<H> Y<V> Z<D> R<Vclear> Q<SClear> F<FRate> 
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> Q<SClear> F<FRate> 
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
End

1stToolChange                         # First tool change                 
G<0> Z<3>
G<0> X<H> Y<V>
M<Direct> S<Speed> T<1>
G<0> Z<VClear>
M<9>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> F<Plunge>
G<1> G<Side> X<H> Y<V> F<FRate> 
end

ExactStop
G<4> L<.01>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
M<9>
G<0> Z<3>
M<6> T<Tool>
M<Direct> S<Speed>
G<0> X<H> Y<V>
G<0> Z<VClear>
M<9>
End

EndCode                               # End of the program                
G<0> Z<3>
M<2>
End
