name Allen-Bradley 4500 (Metric)

N >4
G 2
X ->43
Y ->43
Z ->43
I ->43
J ->43
Q ->43
R ->43
P ->43
F >41
A >42 F
H 4
D >2
T >5
M >2
S >4

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    
ModalLetters X Y Z F                  # List of letters that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    


Feed G<1>                             # Linear move                       
Rapid F<200>                          # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Peck                                  # Pecking canned/manual cycle       
none                                    
end

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
G<90> G<94> G<0> G<17>
G<92> X<WorkH> Y<WorkV> Z<WorkD>
End

1stToolChange                         # First tool change                 
T<Tool>
H<0>
M<19>
M<6>
M<Direct> S<Speed>
X<H> Y<V> F<200> M<Cool>
H<Lcomp>
Z<VClear> F<60>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> A<Plunge>
H<Dcomp>
G<92> A<5000>
G<Side> X<H> Y<V> F<FRate>
end

ExactStop
G<4> F<600>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V> 
Z<D> F<60>
end

ToolChange                            # Secondary tool changes            
T<Tool> M<9>
H<0>
M<19>
M<6>
M<Direct> S<Speed>
X<H> Y<V> F<200> M<Cool>
H<Lcomp>
Z<VClear> F<60>
End

EndCode                               # End of the program                
T<Tool1> M<9>
H<0>
M<19>
X<WorkH> Y<WorkV> Z<WorkD> F<200>
M<2>
End
