name Mitsubishi Wire H Series (Metric)
                                                                   
% 00       
/ 00       
L >4       
N >4       
G 2        
X ->4.>3   
Y ->4.>3   
Z ->4.>3   
I ->4.>3   
J ->4.>3   
K ->4.>3   
A +->3.>3  
E >3       
P >40      
F >3.1     
H >3       
D >2       
M >2       

ModalLetters X Y Z F                  # List of letters that are modal    
ModalGs 0 1 2 3                       # List of g codes that are modal    


Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<02>                              # Circular move clockwise           
Ccw G<03>                             # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
                
Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

StartCode                             # Start of the program              
%<0>                           
L<Program#>                    
G<90>                          
G<92> X<WorkH> Y<WorkV>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> F<FRate> H<DComp> M<90>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V> F<20.0> M<91>
end

1stToolChange                         # First tool change                 
E<Tool>
M<80>
M<82>
M<84>
end

ToolChange                            # Secondary tool changes            
M<00>
G<90>
G<92> X<WorkH> Y<WorkV>
E<Tool>
M<80>
M<82>
M<84>
End

EndCode                               # End of the program                
M<02>
%<0>
End
