name Elox EDM 4 Axis (Metric)
                                                                   
% 00
O >4
N >4
G >2
X ->3.>5
Y ->3.>5
U ->3.>5 IncFrom X
V ->3.>5 IncFrom Y
I ->3.>5
J ->3.>5
K ->3.>5
L ->3.>5
F >3.1
H >2
M >2

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X U                             # X or X U  'Horizontal char.       
VCode Y V                             # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode I J K L                       # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

StartCode                             # Start of the program              
%<0>
O<1>
G<90> G<18>
End

1stToolChange                         # First tool change                 
G<0> X<H> Y<V>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> H<DComp> F<FRate>  
end

ExactStop
G<4>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>  
end

ToolChange                            # Secondary tool changes            
G<0> X<H> Y<V>
End

EndCode                               # End of the program                
G<0> G<90>
X<0> Y<0>
M<30>
%<0>
End
