name SURFCAM Ultimate Mill Post

  # (6/28/93) Surfware Inc. This file is a generic '*.M' file and can be used
  # as a template and appended to 'POSTFORM.M'.  Comments begin with two spaces
  # followed by a pound sign '#'.

  # Several functions are commented to initially restrict their use. To include
  # these functions, delete the first three characters at the beginning of the
  # command line '  #' which are  space, space, pound sign.

                  # Actual output ranges
% 00              # '%'
O >4              # 'O0 - O9999'
N >4              # 'N0 - N9999'
G >2              # 'G0 - G99'
X ->3.>4          # 'X-999.9999 - X999.9999'
Y ->3.>4          # 'Y-999.9999 - Y999.9999'
Z ->3.>4          # 'Z-999.9999 - Z999.9999'
A ->3.>4          # 'A-999.9999 - A999.9999' 
I ->3.>4          # 'I-999.9999 - I999.9999' 
J ->3.>4          # 'J-999.9999 - J999.9999' 
K ->3.>4          # 'K-999.9999 - K999.9999' 
Q ->3.>4          # 'Q-999.9999 - Q999.9999' 
R ->3.>4          # 'R-999.9999 - R999.9999' 
P >40             # 'P0 - P9999'
F >3.1            # 'F0.0 - F999.9'
H >2              # 'H0 - H99'
D >2              # 'D0 - D99' 
T >2              # 'T0 - T99' 
M >2              # 'M0 - M99' 
S >4              # 'S0 - S9999' 

 # Ask <Val1> "Cutoff speed" "200"    # Input up to 10 var. prior to posting
 # Drive \dirname\                    # Output path                       
 # Dummy *                            # Columnar dummy line char.         
 # Each $<0>                          # End of block word                 
 # EOB 35                             # End of block char.                
 # Replace "d" with "DIAMETER"        # Search and replace up to 32 phrases
 # Replace "r" with "RADIUS"            supports upper and lower case
 # RevSigns Z K                       # List of letters to reverse signs  
 # Spaces 64                          # Columnar line length              
 # Spaces? N                          # Y or N  'Spaces between words     
 # Tolerance .0002                    # Round off tolerance               
 # Tools                              # Specifies incremental tool changes

ModalLetters X Y Z F                  # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
LComp 43 49                           # On & Off codes                    
DComp 41 42 40                        # Left, Right & Cancel m codes      
 # CDC P Q                            # Cincinnati style DComp vectors    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
 # VRapid /<0>                        # Adds word prior to rapid moves    
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
CtrCode I J                           # I J or R or I J K L               
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
 # 2ndCircleCode M<99>                # Second word for circular motion   
 # MaxRad 99 .001                     # Maximum arc radius & chordal dev. 
 # MinRad .0005                       # Minimum arc radius                

Inc/Abs G 91 90                       # Inc & Abs char. & values          
Incremental? N                        # Y or N  'Inc or abs output        

 # ZRestart? N                        # Y or N  'New cycle if diff. depths

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>                             
O<Program#>                      
G<90> G<80> G<40> G<17>          
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
T<Tool> M<6>
M<Direct> S<Speed>
G<0> G<Work> X<H> Y<V>             
Z<D> H<Lcomp>                      
M<Cool>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> F<Plunge>
G<Side> X<H> Y<V> H<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
Z<D>
end

ToolChange                            # Secondary tool changes            
G<49> G<0> Z<0> M<9>
T<Tool> M<6>
M<Direct> S<Speed>
G<0> X<H> Y<V>
G<43> Z<D> H<Lcomp>
M<Cool>
End

EndCode                               # End of the program                
G<0> G<90> G<49>
M<6> T<Tool1>
X<0> Y<0>
M<30>
%<0>
End

 # Optional sequences:

 # CwCode                             # CW circular move                  
 # G<2> X<H> Y<V> I<Ival> J<Jval> F<Frate>
 # G<199>
 # End

 # CcwCode                            # CCW circular move                 
 # G<3> X<H> Y<V> I<Ival> J<Jval> F<Frate>
 # G<299>
 # End
   
 # Custom1                            # 1st Custom canned/manual cycle    
 # G<71> X<H> Y<V> Z<D> R<Vclear> F<FRate>
 # end cancel

 # Custom2                            # 2nd Custom canned/manual cycle    
 # G<73> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
 # end cancel

 # Custom3                            # 3rd Custom canned/manual cycle    
 # G<74> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
 # end cancel

 # Index X                            # Index the rotary table            
 # G<0> Z<10.0> M<9>                   
 # A<Rotangle>                         
 # Z<Rplane> M<Cool>                   
 # End                                 

 # LineCode                           # Linear move                       
 # G<1> X<H> Y<V> Z<D> 
 # G<499>
 # End

 # RapidCode                          # Rapid move                        
 # G<0> X<H> Y<V> Z<D> 
 # G<399>
 # End

 # Unwind                             # Unwind the rotary table           
 # G<0> G<28> G<49> Z<0>
 # G<0> G<90> A<0>
 # G<43> H<LComp> z<D>
 # G<0> X<LastH> Y<LastV> A<Lastrotangle>
 # G<1> Z<LastD>
 # End

