name Cincinnati Milacron 850MC SX   *** 3 axis ***

% 00
: 00      
/ 00      
O >2      
N >4      
G >2      
e 00
X ->3.>4  
Y ->3.>4  
Z ->3.>4  
I ->3.>4  
J ->3.>4  
K ->3.>4  
Q ->3.>4  
R ->3.>4  
P >40 
S >4    
F >3.1    
H >2      
D >2      
b 00
T >2      
c 00
M >2      
U ->3.>4
V ->3.>4
j >1 J
m >6
) 00

ModalLetters X Y Z F R                # List of letters that are modal    

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment (MSG,                         # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Ask <Val10> "Enter 1 for full retract peck cycle, or 0 for chip-break: " "1"

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> K<VBite> R<Vclear> F<FRate> j<Val10>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate> 
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> U<0> V<SClear> I<0> K<0> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>         
:<0> G<0>                       
m<Program#> )<0>
End

Replace "e" with "="
Replace "b" with "["
Replace "c" with "]"
Replace "m" with "(MSG,PROGRAM NO. "

1stToolChange                         # First tool change                 
T<Tool> M<6>
S<Speed> F<FRate> M<Direct> M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
T<Tool> M<6>
S<Speed> F<FRate> M<Direct> M<Cool>
End

EndCode                               # End of the program                
M<2>
%<0>
End
