name Bandit II

/ 00
N >4
G >2
X ->3.>4
Y ->3.>4
Z ->3.>4
I ->3.>4
J ->3.>4
F >3.>1
T 2
M 2

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

ModalLetters X Y F                    # List of letters that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   
Rapid /<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
CtrCode I J                           # I J or R or I J K L               
LComp 43 49                           # On & Off codes                    

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> Z<D>   
/<0> X<H> Y<V>
end cancel

Drill                                 # Drilling canned/manual cycle      
Z<D>
/<0> Z<RPlane>
/<0> X<H> Y<V>  
/<0> Z<VClear>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<D>      
/<0> X<H> Y<V>
end cancel

Ream                                  # Reaming canned/manual cycle       
Z<D>
Z<VClear>   
/<0> Z<RPlane>
/<0> X<H> Y<V>
/<0> Z<VClear>
end

Bore                                  # Boring canned/manual cycle        
G<86> Z<D>     
/<0> X<H> Y<V>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> Z<D>   
/<0> X<H> Y<V>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
End

1stToolChange                         # First tool change                 
/<0> N<500>
G<91>
/<0> X<H> Y<V>
T<Tool>
/<0> Z<RPlane>
End

ToolChange                            # Secondary tool changes            
T<0>
/<0> N<800>
/<0> N<900>
/<0> N<500>
G<91>
/<0> X<H> Y<V>
T<Tool>
/<0> Z<RPLane>
End

Infeed                                # Enable cutter comp                
Z<D> F<Plunge>
X<H> Y<V>
end

ExactStop
end

Outfeed                               # Disable cutter comp               
X<H> Y<V> 
Z<D>
end

EndCode                               # End of the program                
/<0> G<6>
N<65>
T<0>
/<0> N<800>
M<0>
End
