name Allen Bradley 8400

% 00
N >4
G >2
O >4
X ->3.>4
Y ->3.>4
Z ->3.>4
I ->3.>4
J ->3.>4
K ->3.>4
Q ->3.>4
R ->3.>4
F >4.1
D >2
T >2
M >2
S >4

ModalLetters X Y Z F                  # List of letters that are modal    
ModalGs 73 74 76 80 81 82 83 84 85    # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ;                             # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
               
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

  # "Last Fixture" (AB-8400) must be set to a non-zero number in order
    to use fixture offsets.

StartCode                             # Start of the program              
%<0> 
G<90>
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
O<0>                                    #Unloads Tool offsets (l and d)
G<0> Z<0>
O<Tool>
M<Direct>
M<Cool>
G<45> O<Work>
G<0> X<H> Y<V>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> F<FRate>
end


Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
O<0>
G<0> Z<0>
X<0> Y<0>
M<9>
M<5>
O<Tool>
M<Direct>
M<Cool>
G<45> O<Work>
G<0> X<H> Y<V>
End

EndCode                               # End of the program                
O<0>
G<0> Z<0>
M<02>
%<0>
End
