name Yasnac 2000B

% 00
N >4 Mult 10
G >2
X ->3.>4
Z ->3.>4
I ->3.>4
K ->3.>4
U ->3.>4
W ->3.>4
P ->3.>4
A 60 P
Q ->3.>4
q ->3.>4 Q
R ->3.>4
F >3.>3
T 2 Limit 1 8                          # Valid Tool #'s 01-08
t 2 "" Limit 0 16                      # Valid offset #'s 00-16 
S >4
M >2

RevSigns X I                          # List of letters to reverse signs  
ModalGs 0 1 2 3 73 76 80 81 82        # List of g codes that are modal    

Spaces? N                             # Y or N  'Spaces between words     
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 
Sequence#s N 0 1 1                    # Char, freq, incr & start          
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                   
ByDiameter? Y                         # Y or N  'Output X val. by diameter
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<3>                               # Circular move clockwise           
Ccw G<2>                              # Circular move counter clockwise   

Drill                                 # Drilling canned/manual cycle      
G<1> Z<H> F<Frate>     
G<0> Z<SClear>
end

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> R<StartAng> P<Depth> q<Peck1> F<Frate>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<78> Z<H> F<FRate>                 
end cancel

Ream                                  # Reaming canned/manual cycle       
G<1> Z<H> F<FRate>                  
G<0> Z<SClear>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>   
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>   
end

StartCode                             # Start of the program              
N<Block>
G<50> X<8.0> Z<5.0>
end

1stToolChange                         # First tool change                 
T<Tool> t<Lcomp>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> X<8.0> Z<5.0> M<5>
T<LastTool> t<00>
N<Block>
G<50> X<8.0> Z<5.0>
T<Tool> t<Lcomp>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

EndCode                               # End of the program                
G<0> X<8.0> Z<5.0>
G<28> W<0> M<5>
G<28> U<0> T<00> t<00>
M<30>
%<0>
End
