macro_file BASIC;
/* ******************************************************************************
															 MULTI-EDIT MACRO FILE

Name: BASIC

Description:	Provides support for the BASIC language

BAS_IND - Smart indent for BASIC
BASSETX - Setup macro for BASIC language files (Templates for BASIC)

								(C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */

macro BAS_IND {
/* ******************************************************************************
																MULTI-EDIT MACRO

Name: BAS_IND

Discription: Performs semi-smart indenting for BASIC source code.

						 Looks for the beginning keywords:  For If While Sub Do Def
									 If it finds them it will INDENT

						 Looks for the ending keywords:     End Wend Next Then Loop
									 If it finds them it will UNDENT

							 (C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */
	str Temp_String1,Temp_String2,Temp_String3;
	int Temp_Line_Num,Temp_Col1,Temp_Col2,Next_Line_Num,using_lnums,l_num,key_word;

	key_word = 1;                                    /* initialize key word flag */
	using_lnums = 1;                                 /* initialize using line no flag */

	if(  (At_EOL == False)  ) {                          /* If we are not at the end of a line, then */
	 Cr;                                              /* do a carrige return and exit */
	 Goto END_OF_MAC;
	}

	First_Word;                                       /* get to first word */
	temp_col1 = C_Col;                               /* save col first word is on */

	temp_string1 = get_word(' |9|255');

	if(  (length(temp_string1) != 0)                    /* if the line isnt blank convert it to */
		 ) {                                            /* it to an integer to see if they are using */
		 if(  (val(temp_line_num,temp_string1) == 0)       /* line numbers if they are you must get the */
			) { using_lnums = 0;                         /* next word after the line number  */
					while(  ((xpos(cur_char,word_delimits,1) != 0)
						& (c_col < 40))  ) {
							right;
					}
					temp_col2 = c_col;                       /* save col first word after line no is on */
					Temp_String2 = Get_Word(' ');            /* read all letters until you reach a space  */
		 }
		}

	if(  ((using_lnums == 0) & (length(temp_string2) != 0))                       /* if using lnums and tstring2 isn't blank */
			) { temp_string2 = ' ' + remove_space(lower(temp_string2)) + ' '; }  /* remove leading & trailing spaces */
	if(  ((length(temp_string1)) != 0)
			) { temp_string1 = ' ' + remove_space(lower(temp_string1)) + ' '; }  /* if no lnums remove spaces from tstr1 */

			if(  (length(temp_string1) == 0)                /* if str1 is blank just do a cr */
					) {
						Eol;
						cr;
						GOTO_COL(1);
				 }

			if(  ((length(temp_string2) == 0) & (using_lnums == 0))     /* if using line nums & str2 is blank */
					) {                                                   /* you just need to write the next line no */
						call write_next_lnum;
				 }

			if(  (using_lnums == 0)
				 ) {
					 if(  (pos(temp_string2,' for if while sub do def ') != 0)    /* if you find a begin. keyword and  */
						 ) {                                                      /* your using line nos you must write */
									 key_word = 0;                                     /* the next line no and indent        */
									 call write_next_lnum;
									 goto_col(temp_col2);
									 indent;
						}
			} else { if(  (pos(temp_string1,' for if while sub do def ') != 0)    /* if you find a keyword and not using */
						 ) {                                                      /* line nos just indent  */
									 key_word = 0;
									 eol;
									 cr;
									 goto_col(temp_col1);       /* goto where you typed the keyword and go forward */
									 indent;                    /* one tab stop */
						}
			 }

		 if(  (using_lnums == 0)
				) {
					if(  (pos(temp_string2,' next then wend end loop ') != 0)        /* if you find an ending keyword then  */
						 ) {                                                         /* and your using line nos you must write */
									 key_word = 0;                                        /* the line number go back to the col you */
									 call write_next_lnum;                                 /* were at last and undent 1 tab stop */
									 goto_col(temp_col2);
									 undent;
									 if(  c_col == 1                                          /* If you undent and you were only at the first */
											) {                                                /* tab stop put cursor at the of the number */
												while(  ((xpos(cur_char,word_delimits,1) == 0))  ) {
												 right;
												}
												right;
											}
						}
			} else {
					if(  (pos(temp_string1,' next then wend end loop ') != 0)
						) {
										key_word = 0;
										eol;
										cr;
										goto_col(temp_col1);
										undent;
					 }
			}

 if(  (key_word != 0)
		) {
			 if(  (using_lnums == 0)  ) {
						if(  (length(temp_string2) != 0)
							 ) { call write_next_lnum;        /* No keywords - with line no's */
									 goto_col(temp_col2);
								 }
			 } else { if(  (length(temp_string1) != 0)      /* No keywords - no line no's - just text */
							 ) {
								eol;
								cr;
								goto_col(temp_col1);
							}
			 }
	 }

goto end_of_mac;

	write_next_lnum:                                                    /* before writing the next line no go  */
		goto_col(1);                                                      /* down and check the next line to see if */
		Down;                                                             /* another line Number below  */
		Temp_String3 = Get_Word(' ');
		Up;
		eol;
		cr;
		goto_col(1);
		if(  ((Temp_String3 == '') | (Val(Next_Line_Num,Temp_String3) != 0)) /* if there is no line number below */
				) { Text(Str(Temp_Line_Num + 10));                             /* just increment the "standard" 10 */
						} else { Text(Str(Temp_Line_Num + ((Next_Line_Num - Temp_Line_Num) / 2)));/* Otherwise make increment approx. halfway */
					}                                                        /* between the line number above and the below */
		right;
		ret;

END_OF_MAC:
	redraw;
}

/********************************MULTI-EDIT MACRO*******************************

Name: BASSETX

Description:	Initializes stuff for BASIC language editing.  See the macro
 							TEMPLATE in the file LANGUAGE.S for information on template
 							expansion.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
macro BASSETX {
	if ( "" == Global_Str("!BAS.Tmplt0") )
	Set_Global_Str("!BAS.Tmplt0", "C=1M=1"+
	"doloop until "+						/* C=1 Case insensitive. Template will expand */
	"dwo hile Įloop"+				/*      to all caps (Example:  PROCEDURE) */
	"else"+											/*    2 Case insensitive. Template will expand */
	"eilsef"+								  /*      to upper/lower (Example:  Procedure) */
	"elseif"+								    /*    3 Case first letter case sensitive  */
	"for  =  tonext"+					/*      following characters case insensitive. */
	"function  end function"+	/*      Template will expand to case of first */
	"if  thenend if"+					/*      letter. */
	"return"+										/* M=1 Minimum expansion of 1 (only one character */
	"subend sub"+							/*      is requried to expand the template */
	"while Įwend"							
	);
}
