*  QCONFIG.NE    -- Configuration file for QEDIT2 to emulate Norton Editor
*
*  First Written: 24-AUG-89   Tim Farley
*  Last Revised:  28-AUG-89   Tim Farley    Norton Editor v1.3C, QEdit 2.08.
*                 07-NOV-89   TF            Misc. edits.
*
*  ------------------------------------------------------------------------
*  NOTE:  WE RECOMMEND YOU PRINT THIS FILE OUT AND REFER TO IT AS YOU
*         RUN THE QCONFIG PROGRAM TO CONFIGURE YOUR COPY OF QEDIT.
*
*  QEdit has literally HUNDREDS more options and commands than does Norton
*  Editor.  As such, we recommend you read the QEdit manual to familiarize
*  yourself with these, before extensively customizing this file.
*
*  All Norton Editor commands that are possible in QEdit are emulated in this
*  file as closely as possible.  In addition, as many of QEdit's "default"
*  key assignments (including many WordStar-like keys) are carried over as is
*  possible.  The help screen shows only those keys that differ from the
*  defaults in the QEdit manual and reference card.
*
*  NOTE:  Between the two-key NE commands, and the two-key WordStar commands,
*         this QCONFIG file uses up all the available space in QEdit for
*         two-key commands.  If you need to define more two-keys, you will
*         have to undefine one existing one for each new one.
*
*  In addition, some QEdit commands are assigned to "Norton-like" F-key
*  sequences for consistency  (e.g., F4 H for Horizontal split).
*  These are marked with "+" in the help screen.
*
*  Within this file, where QEdit differs from Norton Editor in
*  implementation of a particular command, it is noted whenever possible.
*  ------------------------------------------------------------------------
*
*  Below are other QCONFIG options you should set to closely duplicate
*  the default NE configuration.  You will have to select these
*  from the menus within QCONFIG.  For any options not listed here, just
*  hit <RETURN> to keep the default, or configure to your preference:
*
*
*  (A)dvanced options:                              For large        For under-
*  -------------------                             block cursor:   score cursor:
*  Should QEdit change the cursor size (Y/N)? [Y] :    Y                Y
*  Do you want a large flashing cursor (Y/N)? [N] :    Y                N
*        .
*        .
*  Do you want the return command to split lines in insert mode (Y/N)? [Y] : Y
*        .
*        .
*  Do you want the ESCAPE command to invoke the menus (Y/N)? [Y] : Y
*  Do you want to invoke the editor at a specified line number (Y/N)? [N] : Y
*
*
*  (C)olor and screen:
*  -------------------
*  Statusline position: "T" for top, "B" for bottom  [T] : B
*        .
*        .
*  Number of columns to scroll horizontally for screen
*       lt/rt commands [1..400] [1] : 1
*        .
*        .
*        .                       1     2     3     4     5     6     7     8
*        .                      ===   ===   ===   ===   ===   ===   ===   ===
*  Blocked Text:        [112] : 112    26*   15*  111*   48*   32*   49*   48*
*  Error msgs:          [112] : 112    36*  116*  126*   12*   12*   28*  116*
*  Text Area:             [7] :   7     2    23    71    32    48   113   112
*  Status Line:         [112] : 112    32   113   116     2     3    23     7
** Cursor Line:          [15] :  15    10    31    79    47    63   121   127
** Messages:             [15] :  15    46   113   116     2     3    23     7
** Hi-lited items:        [9] :   9     9    26    78    43    57   123   123
** EOF line/indicator:   [15] :  15    10    31    79    47    63   121   127
*  Help screen:         [112] :  15    10    31    79    47    63   121   127
** Box borders:          [15] :  15    43   123   124    10    11    27    11
** PopUp windows:        [15] :  15    43   123   124    10    11    27    11
** Menu items:           [15] :  15    42   126   116     2    15    19     3
** Selected Menu items: [112] : 112    26    30    79    43    31   113    27
*                         ^
*  QEdit's defaults-------|       Use the column of numbers above that matches
*                                 the color set in Norton that you use:
*  Those marked with ** have
*  no real equivalent in NE.      1.  White text on Black background
*                                 2.  Green text on Black background
*  Attributes marked with *       3.  White text on Blue background
*  are not precise equivalents    4.  White text on Red background
*  to NE.  Some compromises       5.  Black text on Green background
*  had to be made to allow for    6.  Black text on Cyan background
*  differences QEdit.             7.  Blue text on White background
*                                 8.  Black text on White background
*
*  (G)eneral options:
*  ------------------
*  Do you want the del_ch command to join lines if at EOL (Y/N)? [Y] : Y
*  Do you want the PQuit, Exit and File commands to
*       return to "edit file" prompt (Y/N)? [Y] : N
*  Do you want the editor to start in wordwrap mode (Y/N)? [N] : N
*  Default right margin for wordwrap [1..512]  [72] : 65
*  Do you want the editor to start in insertmode (Y/N)? [Y] : Y
*  Do you want the editor to start in autoindent mode (Y/N)? [Y] : N
*  Do you want the editor to use "sticky" autoindent (Y/N)? [N] : Y
*        .
*        .
*  Delete white space after words with del_rt_word command (Y/N)? [Y] : N
*  Terminate files with a Control Z (Y/N)? [N] : Y
*  Do you want "backups" of saved files (Y/N)? [Y] : Y
*  Prompt for filename on open window (Y/N)? [N] : Y
*  Close window when a file is quit (Y/N)? [Y] : Y
*        .
*        .
*  Insert line blocks ABOVE the cursor line (Y/N)? [N] : Y
*
*
*  (T)ab settings:
*  ---------------
*  Do you want the editor to start in Physical Tab Expansion Mode (Y/N)? [Y] : Y
*  Do you want the editor to start in Tabs Out mode (Y/N)? [N] : Y
*  Default physical tab width [2,4, or 8] [8] : 8
*  Default Cursor tab width [2..12] [8] : 8
*        .
*        .
*  Do you want the editor to start in Smart Tabs Mode (Y/N)? [N] : N
*
*  ------------------------------------------------------------------------
*  SEE DEFAULT QCONFIG.DAT FOR FURTHER INSTRUCTIONS ON MODIFYING THIS FILE.
*
*
* function key set
*

f1                 QuickHelp

* F2 is "status" in Norton.  No such command in QEdit.
f2

* *********************************************************************
* *  F3 starts all Norton's "File Commands"                           *
* *********************************************************************
f3_e               File
*
* QEdit will only ask you Yes/No if there actually have been changes.
f3_q               PQuit
*
* SaveFile doesn't ask you a yes/no question first, ever.
f3_s               SaveFile
*
* F3-X does two different things in Norton, depending on if the screen is
* already split.  We split this into f3_h to Horizontally split the window,
* and f3_x to Xchange to other window.
f3_h               HorizontalWindow
f3_x               NextWindow
f3_n               NewFile
*
* Norton Appends text to the end of the file on this command.  QEdit
* is more flexible--it will let you read the text in at the cursor position.
f3_a               ReadBlock
*
* The following two commands have no meaning in QEdit, because QEdit
* always loads the entire file into memory.
f3_w
f3_l
f3_c               ChangeFilename

* *********************************************************************
* *  F4 starts all Norton's "Block Commands"                          *
* *********************************************************************
*
* DropAnchor might also be a choice for F4-S.  MarkCharacter is closest to NE.
f4_s               MarkCharacter
f4_r               UnmarkBlock
*
* Unlike NE, QEdit *can* UnKill text deleted with DeleteBlock.  Hence, there
* is no Yes/No question on the following.
f4_d               DeleteBlock
*
* QEdit makes no distinction between single file and multi-file block copies.
*
* Also, NE leaves the SOURCE marked, QEdit leaves the DESTINATION marked after
* the copy or move is complete.  See Copy/Cut/Paste for alternate approaches.
f4_c               CopyBlock
f4_w               CopyBlock
f4_m               MoveBlock
*
* Note:  This behaves differently than NE.  In NE, this marks the current
* line as a character block.  In QEdit, this starts/stops a LINE block.
f4_l               MarkLine
*
* F4-E is mark to end of line.  We could do that in a macro, but QEdit
* does not let you assign macros to two-keys as of version 2.08.
f4_e               MarkLine
*
* This jumps unconditionally, it does not search forward only.
f4_f               GotoBlockBeg
*
* The following are added to Norton's structure to allow you to use QEdit's
* additional features with Norton-like commands:
f4_k               MarkColumn
f4_o               Copy
f4_u               Cut
f4_p               Paste

* *********************************************************************
* *  F5 starts all Norton's "Screen Format Commands"                  *
* *********************************************************************
*
* NOTE:  Setting the line length also turns WordWrap ON in QEdit 2.08.
f5_l               SetRMargin
f5_w               ToggleWordWrap
*
* QEdit only treats blank lines as Paragraph delimiters.
* Also, QEdit will use the AutoIndent margin as a left margin when wrapping.
f5_f               WrapPara
f5_t               SetCTabWidth
f5_i               ToggleIndent
*
* C - sets Cursor size, D - sets Display color.
* S - Saves editor, K - changes Key operations.
* You can only set the these in QCONFIG, not in the editor.
* Hence, they remain unassigned here.
*
f5_c
f5_d
f5_s
f5_k

* *********************************************************************
* *  F6 starts all Norton's "Miscellaneous Commands"                  *
* *********************************************************************
f6_g               GotoLine
f6_m               Match
*
* Condensed mode could be done in a macro, with an external grep utility.
*
f6_c
*
* The INS key, and Insert versus Replace mode work a little different
* in QEdit.
f6_ins             ToggleInsert
*
* Test windows for differences could be done in a macro, with an external
* file compare utility.
*
f6_t

* *********************************************************************
* *  F7 starts all Norton's "Printer Commands"                        *
* *********************************************************************
f7_p               PrintAll
f7_b               PrintBlock
f7_e               PrintEject
f7_s               SetPrintPageSize
f7_m               SetPrintLeftMargin

* F8 is "reserved for future use" in Norton Editor
f8
f9                 Shell
* F10 is "reserved for future use" in Norton Editor
f10

* enhanced keyboard only
f11
f12

#f1                ToggleBoxDraw
#f2
#f3                Sort
#f4
#f5                MakeCtrOfScreen
#f6
#f7                ShiftLeft
#f8                ShiftRight
#f9
#f10

* enhanced keyboard only
#f11
#f12

* *********************************************************************
* *  Control-Function Keys are set to pull one of QEdit's menus that  *
* *  corresponds to the similarly numbered Norton lead-in key.  For   *
* *  instance, F3 is Norton's File command, ^F3 is QEdit's File       *
* *  Menu.  To help the user learn QEdit's pull-down system.          *
* *  Unassigned lead-in keys from NE are set to other QEdit menus.    *
* *                                                                   *
* *  Control-F1 is an exception--it's from the default QEdit config.  *
* *********************************************************************
^f1                ToggleEGA43
^f2                MacroBegin MainMenu 'W'
^f3                MacroBegin MainMenu 'F'
^f4                MacroBegin MainMenu 'B'
^f5                MacroBegin MainMenu 'O'
* There is no real equivalent for F6 in QEdit's menus, so we use "Search"
^f6                MacroBegin MainMenu 'S'
^f7                MacroBegin MainMenu 'P'
^f8                MacroBegin MainMenu 'M'
^f9                MacroBegin MainMenu 'E'
^f10               MacroBegin MainMenu 'Q'

* enhanced keyboard only
^f11
^f12

@f1                ToggleBoxType
@f2                InsertLine
@f3                Match
@f4
@f5                ScreenLeft
@f6                ScreenRight
@f7
@f8
@f9                Dos
@f10               ShowEntryScreen

* enhanced keyboard only
@f11
@f12

*
* special keys
*

cursorup           CursorUp
cursordown         CursorDown
cursorleft         CursorLeft
cursorright        CursorRight
^cursorleft        WordLeft
^cursorright       WordRight
home               BegLine
end                EndLine
*
* Note that BegScreen and EndScreen are unassigned, because ^home & ^end
* do the same thing as ^pgup & ^pgdn in Norton Editor.
*
^home              BegFile
^end               EndFile
*
* PageUp and PageDown do the same thing, no matter the cursor location,
* in QEdit.  (In Norton, they only scroll if the cursor is sitting on
* the top or bottom line, respectively).
pgup               PageUp
pgdn               PageDown
^pgdn              EndFile
^pgup              BegFile

#tab               TabLt
tab                TabRt

ins                ToggleInsert
del                DelCh

backspace          Backspace
^backspace         DelLtWord

enter              Return
^enter             ExecuteScrap

escape             Escape

grey*              Paste
grey+              Copy
grey-              Cut
#del
#ins
`
~
/

^prtsc             PasteOver
^2
^6
^[
^\
*
* Macro to edit the file whose name is sitting at the cursor in the editor
*
^]                 MacroBegin AltWordSet MarkWord Copy DefaultWordSet EditFile Paste Return
^-                 GetPrev

*
* alternate keys
*

*
* Alt-A is DropAnchor by Default.  But NE has F4 S for that.
* So lets recover QEdit's AddLine (normally F2).
@a                 AddLine

@b                 WrapPara

*
* NE's CONTINUE search forward.  QEdit just continues in same direction.
@c                 RepeatFind

*
* Alt-D is DelLine by Default.  But NE has ALT-K for that.
* So lets recover QEdit's DupLine (normally F4).
@d                 DupLine

@e                 EditFile

*
* NE's FORWARD search.
@f                 Find

@g                 DeleteBlock
@h                 QuickHelp
@i                 ToggleTabsOut
@j                 JoinLine

*
* NE's delete entire line.
@k                 DelLine

*
* NE's delete from cursor forward, on this line.
@l                 DelToEol

*
* In NE, Control-M acts the same as ENTER.  So, we have to move MacroRecord
* to Alt-M so that Control-M can be set to Return
@m                 MacroRecord

@n                 NextFile
@o                 ChangeFilename

*
* NE's insert control character, synonym on Alt-P too.
@p                 Literal

*
* Alt-Q recovers QEdit's GPQuit (normally F3).
@q                 GPQuit

*
* Alt-R for search and REPLACE.  QEdit does not integrate Find/Replace like NE
@r                 FindReplace

@s                 SplitLine

*
* Alt-T recovers QEdit's MakeTopOfScreen (normally F5).
@t                 MakeTopOfScreen

*
* UnKill is closest to NE's Undelete, but see also UndoCursorline
@u                 UnKill

*
* Flip case FORWARD to line end.  NOTE:  this unmarks the current block.
@v                 MacroBegin UnMarkBlock DropAnchor EndLine DropAnchor Flip GotoBlockBeg UnMarkBlock

*
* NE's delete by words, forward.
@w                 DelRtWord

@x                 GExit
@y                 GSave
@z                 CopyOverBlock

@1                 Upper
@2                 Lower
@3                 Flip
@4
@5
@6
@7
@8
@9
@0
@-
@=                 MacroBegin MarkWord Copy Find Paste Return Return

*
* control keys
*


*
* ^A & ^F are normally WordStar-like WordLeft and WordRight.
* Since ^F is taken by NE, we might as well surrender ^A also.
^a

^b_a               AppendScrBuff
^b_l               GetScrBuff
^b_s               StoreScrBuff

*
* NE's CONTINUE search backward.  QEdit just continues in same direction.
^c                 RepeatFind

^d                 CursorRight
^e                 CursorUp

*
* NE's REVERSE search.  We use macros to insure backward motion.
^f                 MacroBegin Find Pause Return Pause EndLine 'B' Return

^g                 DelCh

*
* The next two are the same in QEdit as in NE.
* These are the normal ASCII equivalents for Backspace and Tab
^h                 Backspace
^i                 TabRt

^j                 GotoLine

* *********************************************************************
* *  WordStar ^K (BLOCK) commands.  We recover enough of QEdit's      *
* *  default ones to cover all the features not already duplicated    *
* *  on other keys.  You might wish to delete these, or activate or   *
* *  deactivate a different set.                                      *
* *********************************************************************
^k_b               MarkBlockBegin
^k_k               MarkBlockEnd
^k_d               File
^k_q               PQuit
^k_s               SaveFile
^k_t               MarkWord
^k_r               ReadBlock
^k_w               WriteBlock
^k_z               KillFile
*  ^k_c               CopyBlock
*  ^k_e               EditFile
*  ^k_f               ChangeFilename
*  ^k_h               UnmarkBlock
*  ^k_n               NextFile
*  ^k_p               PrevFile
*  ^k_v               MoveBlock
*  ^k_x               File
*  ^k_y               DeleteBlock

*
* NE's delete from cursor backward, on this line.
^l                 MacroBegin SplitLine DelLine BegLine

*
* NE honors the ASCII equivalent to RETURN, control-M.
* We moved MacroRecord to Alt-M to accomdate this.
^m                 Return

^n                 SplitLine

* *********************************************************************
* *  WordStar ^O (OTHER) commands.  We recover enough of QEdit's      *
* *  default ones to cover all the features not already duplicated    *
* *  on other keys.  You might wish to delete these, or activate or   *
* *  deactivate a different set.                                      *
* *********************************************************************
^o_c               CloseWindow
^o_e               ToggleTabsExpand
^o_g               GrowWindow
^o_o               OneWindow
^o_s               ShrinkWindow
^o_z               ZoomWindow
*  ^o_h               HorizontalWindow
*  ^o_l               SetPrintLeftMargin
*  ^o_n               NextWindow
*  ^o_p               PrevWindow
*  ^o_r               SetRMargin
*  ^o_w               ToggleWordWrap

*
* Same in NE as it is in QEdit.
^p                 Literal

* *********************************************************************
* *  WordStar ^Q (QUICK) commands.  We recover enough of QEdit's      *
* *  default ones to cover all the features not already duplicated    *
* *  on other keys.  You might wish to delete these, or activate or   *
* *  deactivate a different set.                                      *
* *********************************************************************
^q_l               UndoCursorline
^q_p               PrevPosition
^q_t               ToggleSmartTabs
*  ^q_a               FindReplace
*  ^q_b               GotoBlockBeg
*  ^q_c               EndFile
*  ^q_d               EndLine
*  ^q_e               BegScreen
*  ^q_f               Find
*  ^q_i               ToggleIndent
*  ^q_k               GotoBlockEnd
*  ^q_r               BegFile
*  ^q_s               BegLine
*  ^q_x               EndScreen
*  ^q_y               DelToEol

*
* We use ^R for reverse search and REPLACE.  NE's search & replace is
* integrated into the single ^F command.  QEdit does not do this.
^r                 MacroBegin FindReplace Pause Return Pause Return CursorRight 'B' Pause Return

^s                 CursorLeft
^t                 DelRtWord

*
* UnKill is closest to NE's Undelete, but see also UndoCursorline
^u                 UnKill

*
* Flip case BACK to line beginning.  NOTE:  this unmarks the current block.
^v                 MacroBegin UnMarkBlock MarkCharacter BegLine MarkCharacter Flip GotoBlockEnd UnMarkBlock

*
* NE's delete by words, backward.
^w                 DelLtWord

^x                 CursorDown
^y                 DelLine

*
* ^W and ^Z are normally WordStar-like ScrollUp & ScrollDown.
* Since ^W is taken by NE, we might as well surrender ^Z also.
^z

*
* other enhanced only keys
*
@'
@,
@.
@/
@;
@[
@\
@]
@`
@backspace
@enter
@escape
@grey*
@grey+
@grey-
@grey/
@greycursordown
@greycursorleft
@greycursorright
@greycursorup
@greydel
@greyend
@greyhome
@greyins
@greypgdn
@greypgup
@greyenter
@tab

greyenter          Return
^greyenter         ExecuteScrap
^centercursor
^cursordown        LineDown
^cursorup          LineUp
^del

^grey*
^grey+
^grey-
^grey/
^ins
^tab

centercursor

*
* EOF: QCONFIG.NE
*
