*  QCONFIG.B     -- Configuration file for QEDIT2 to emulate Brief
*
*  First Written: ??-Sep-88   Randy Wallin, Pompano Beach, FL
*  Last Revised:  25-Jul-89   Steve Lynch   Misc fixes.
*                 04-Oct-89   Tim Farley    For QEdit 2.08, QEdit OS/2 1.1
*                 07-Nov-89   TF            Misc edits.
*
*  ------------------------------------------------------------------------
*  NOTE:  WE RECOMMEND YOU PRINT THIS FILE OUT AND REFER TO IT AS YOU
*         RUN THE QCONFIG PROGRAM TO CONFIGURE YOUR COPY OF QEDIT.
*
*  ------------------------------------------------------------------------
*  If you're a BRIEF user, you'll like Qedit's small size (all you need is
*  the Q.EXE file) - so it's something easy to carry from customer to customer.
*  
*  NOTE:  See below in file for comments on the specific assignments.
*
*         The following QEdit commands are not assigned in this file,
*         due to conflicts with Brief assignments.  You may wish to pick
*         some keys to assign these to:
*
*         Command            Default QEdit Key      Notes
*         --------------     ------------------     --------------
*         AddLine            F2                     See ^Enter
*         CopyOverBlock      Alt-Z
*         Dos                Alt-F9
*         DupLine            F4
*         GetPrev            Ctrl-_
*         GPQuit             F3
*         InsertLine         Alt-F2
*         MakeCtrOfScreen    Shift-F5
*         ToggleTabsOut      Alt-I
*         UnKill             Control-U
*         UnMarkBlock        Alt-U                  Also ^K_H
*         WriteBlock         Alt-W                  Also ^K_W
*
*  ------------------------------------------------------------------------
*  SEE DEFAULT QCONFIG.DAT FOR FURTHER INSTRUCTIONS ON MODIFYING THIS FILE.
*

f1                      prev_window
f2                      grow_window
f3                      horizontal_window
f4                      close_window
f5                      find
f6                      find_replace
f7                      macro_record        
f8                      executescrap                                   
f9                      macro_read
f10                     pquit

* enhanced keyboard only
f11
f12

*
* these next two imitate BRIEF's tab-in/tab-out commands 
#f1                     shiftleft
#f2                     shiftright
#f3
#f4                     maketopofscreen
#f5                     repeat_find
#f6                     repeatfind
#f7                     pause
#f8
#f9
#f10                    show_entry_screen

* enhanced keyboard only
#f11
#f12

^f1                    toggleEGA43
^f2                    sort
^f3
^f4
^f5
^f6
^f7                     macro_write
^f8                     toggleboxdraw
^f9                     toggleboxtype
^f10                    g_exit

* enhanced keyboard only
^f11
^f12

@f1                     
@f2                     match
@f3                     insert_date
@f4                     insert_time
@f5                     macrobegin find pause return 'B' return
@f6                     macrobegin find_replace pause return 'B' return
@f7                     screen_left
@f8                     screen_right

* Use the next two lines if you have QCP and QMAC.
* @f10 - does a global save - then compiles the current file
@f9  macrobegin dos 'QCP /2 ' current_filename return
@f10 macrobegin save_file onewindow unmarkblock dropanchor editfile 'errors.lst' return quit gotoblockbeg unmarkblock dos 'QCP/G /O.\errors.lst

*
* if you don't use QCP and QMAC - use this
* take note: if you use Clipper - change the "foxpcomp" to Clipper
*@f10    macro_begin gsave dos 'foxpcomp -e ' current_filename ' >fixit.err' return return horizontal_window edit_file 'fixit.err' return find "error" return return

* enhanced keyboard only
@f11
@f12

*
* special keys
*

cursorup                cursor_up
cursordown              cursor_down
cursorleft              cursor_left
cursorright             cursor_right
^cursorleft             word_left
^cursorright            word_right
home                    beg_line
end                     end_line
^home                   begscreen                                      
^end                    endscreen                                      
pgup                    page_up
pgdn                    page_down
^pgdn                   endfile                                        
^pgup                   begfile                                        

#tab                    tab_lt
tab                     tab_rt

ins                     paste
del                     del_ch

backspace               backspace
^backspace              del_lt_word

enter                   return
^enter                  macrobegin addline begline                     

escape                  escape
* BRIEF default uses the * as the undo key (makes it hard for dBase folks to
* enter comments - for those who still do.) - so we changed the undo to the 
* ` (below the ~)
grey*                   input_ch
grey+                   copy
grey-                   cut
#del                    del_rt_word
#ins                    macro_begin main_menu "o" "i" paste main_menu "o" "i"

`                       undo_cursorline
~                       input_ch
/                       input_ch
^prtsc                  pasteover
^2
^6
^[                      half_pgdn
* the following macro is defined to ^] in the default QCONFIG.DAT
^\                      MacroBegin AltWordSet MarkWord Copy DefaultWordSet EditFile Paste Return
^]                      half_pgup
^-                      pquit

*
* alternate keys
*

@a                      markcharacter                                  
@b_a                    append_scrbuff
@b_l                    get_scrbuff
@b_s                    storescrbuff
@c                      markcolumn                                     
@d                      del_line
@e                      edit_file
@f                      currentfilename				       
@g                      goto_line
@h                      quick_help
@i                      toggle_insert
@j                      join_line
@k                      del_to_eol
@l                      mark_line
@m                      dropanchor                                     
@n                      next_file
@o                      change_filename
@p                      macro_begin main_menu 'p'
@q                      literal                                        
@r                      read_block
@s                      find
@t                      find_replace
@u                      undocursorline                                 
@v                      toggle_tabs_expand
@w                      savefile                                       
@x                      gexit                                          
@y                      gsave
@z                      shell
@1                      Upper
@2                      Lower
@3                      Flip
@4
@5
@6
@7
@8
@9
@0
@-                      prev_file
@=                      MacroBegin MarkWord Copy Find Paste Return Return

*
* control keys
*


^a                      align
^b                      makebotofscreen
^c                      page_down
^d                      scrollup
^e                      macro_begin main_menu "F" "L" "*.prg" beg_line
^f
^g                      del_ch
^g_b                    goto_block_beg
^g_e                    goto_block_end
^h                      backspace
^i                      toggle_indent
^j                      goto_line
^k_b                    mark_block_begin
^k_c                    copy_block
^k_d                    exit
^k_e                    edit_file
^k_f                    change_filename
^k_h                    unmark_block
^k_k                    mark_block_end
^k_n                    next_file
^k_p                    prev_file
^k_q                    pquit
^k_r                    read_block
^k_s                    save_file
^k_t                    MarkWord
^k_v                    move_block
^k_w                    write_block
^k_x                    file
^k_y                    delete_block
^k_z                    kill_file
^l                      literal
^m                      macrobegin splitline begline cursordown        
^n                      split_line
^o_c                    close_window
^o_l                    set_print_left_margin
^o_n                    next_window
^o_o                    one_window
^o_p                    prev_window
^o_g                    grow_window
^o_r                    set_rmargin
^o_s                    shrink_window
^o_h                    horizontal_window
^o_w                    toggle_wordwrap
^o_z                    zoom_window
^p                      literal
^q_a                    wrap_para
^q_b                    goto_block_beg
^q_c                    end_file
^q_d                    end_line
^q_e                    beg_screen
^q_f                    find
^q_i                    toggle_indent
^q_k                    goto_block_end
^q_l                    undo_cursorline
^q_p                    prev_position
^q_r                    beg_file
^q_s                    beg_line
^q_t                    toggle_smart_tabs
^q_x                    end_screen
^q_y                    del_to_eol
^r                      page_up
^s                      g_save
^t                      maketopofscreen                                
^u                      scrolldown                                     
^v                      toggle_insert
^w                      togglebakups                                   
^x                      scroll_up
^y                      del_line
^z                      scroll_down


*
* other enhanced only keys
*
@'
@,
@.
@/
@;
@[
@\
@]
@`
@backspace
@enter
@escape
@grey*
@grey+
@grey-
@grey/
@greycursordown
@greycursorleft
@greycursorright
@greycursorup
@greydel
@greyend
@greyhome
@greyins
@greypgdn
@greypgup
@enter
@tab

greyenter       return
^greyenter      ExecuteScrap
@greyenter
^centercursor
^cursordown     linedown
^cursorup       lineup
^del

^grey*
^grey+
^grey-
^grey/
^ins
^tab

centercursor

*
* EOF: QCONFIG.B
*
