/*
 * $Header:   J:/devkit.dos/vcs/srcsmpl/wshout/src/wshout.h_v   1.2.1.0   26 Apr 1993 18:02:00   rcq  $
 */

/*
 * Filename: WSHOUT.H
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History:
 * 08-Sep-92	gakio	Removed do_shout().
 * 09-Sep-92	gakio	Added identifiers for About Box.
 * 12-Nov-92	gakio	Added ShoutBlockingHook().
 * 25-Jan-92	gakio	Added port argument to ResolveAndConnectHost() & 
 *			 GetSocketAndBind().
 * 25_Apr-93    rcq     removed MS hdrs included (put in source modules)
 *			 added definition of PRBUF_LEN, added multiple
 *			 include protection and "ifdef __cplusplus" stuff
 */

#ifndef _WSHOUT_INC_
#define _WSHOUT_INC_

/* Windows 3.0 include files */
#include <windows.h>
#define _INC_WINDOWS
#include <winsock.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Global Variables defined in WSHOUT.C */
extern	HANDLE	hInst;			/* Instance handle */
extern	HWND	hOurWnd;		/* Main Window Handle */
extern	int	ret;			/* work variable */

#define PRBUF_LEN	50
extern	char	prbuf[PRBUF_LEN];	/* work buffer */

/* Menu IDs	*/
#define IDM_START	101
#define IDM_ABOUT	102
#define IDM_STOP	103
#define IDM_EXIT	104
#define IDM_SETTINGS	105

/* Dialog Box Control IDs	*/
#define IDD_HNAME	200
#define IDD_CONNECT	IDOK
#define IDD_CANCEL	IDCANCEL
#define IDD_WRITES	208
#define IDD_BYTES	210
#define IDD_BITS	212
#define IDD_HELP	214
#define IDD_SENT	230
#define IDD_WRITE	232
#define IDD_TIME	234
#define IDD_COMMENT	236
#define IDD_COHOST	240

/* Settings Dialog Box Control IDs	*/
#define IDS_BUFFLEN	300
#define IDS_PORTNO	301
#define IDS_BLOCK	302
#define IDS_NOBLOCK	304
#define IDS_TCP		306
#define IDS_UDP		308
#define IDS_CLIENT	310
#define IDS_SERVER	312
#define IDS_DEFAULT	314

/* About Box Control IDs	*/
#define IDA_COPYRIGHT	400
#define IDA_APP_VERSION	402
#define IDA_DLL_VERSION	404

/* Program control IDs	*/
#define	WM_SELECT		WM_USER+16

/* Global variables  */
#define	SOCK_DISCARD	9	/* use the UDP ttytst source port for test */
#define SOCK_SHOUT	32766	/* TCP port used for SHOUT & LISTEN	   */
#define BUF_SIZE	8192
#define WRITE_TIMER	1

/* Function prototypes	*/
int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
long FAR PASCAL ShoutWndProc(HWND, WORD, WORD, LONG);
BOOL FAR PASCAL About(HWND, WORD, WORD, LONG);
BOOL FAR PASCAL DialogProc(HWND, WORD, WORD, LONG);
BOOL FAR PASCAL Settings(HWND, WORD, WORD, LONG);
BOOL InitApp(HANDLE);
void CheckThisBoxOn(HWND, int);
void CheckThisProtoBoxOn(HWND, int);
void CheckThisProgBoxOn(HWND, int);
void ClearBoxes(HWND);
SOCKET ResolveAndConnectHost(LPSTR, HWND, int, int);
SOCKET GetSocketAndBind(HWND, int, int); 
long UWriteData(SOCKET, HWND, int);
long UReadData(SOCKET, HWND, int);
long TWriteData(SOCKET, HWND, int);
long TReadData(SOCKET, HWND, int);
int ShoutBlockingHook (void);
int PASCAL FAR WSAsperror (HANDLE, int, char far *, int);
void wshout_err (HWND, int, char far *);

#define bcopy(a,b,c)	_fmemcpy(b,a,c)
char * _calloc (unsigned, unsigned);
void _free (void *);

#ifdef _cplusplus
}
#endif /* __cplusplus */

#endif /* ifndef _WSHOUT_INC_ */

/*
 * $Log:   J:/devkit.dos/vcs/srcsmpl/wshout/src/wshout.h_v  $
 * 
 *    Rev 1.2.1.0   26 Apr 1993 18:02:00   rcq
 * added new error message display, updated headers, general cleaning
 * 
 *    Rev 1.2   28 Jan 1993 14:27:50   GAKIO
 * Added ShoutBlockingHook().
 * Added port number argument to ResolveAndConnectHost() and
 *  GetSocketAndBind().
 * 
 *    Rev 1.1   04 Nov 1992 14:23:58   GAKIO
 * Moved SOCKET sd to wshout.c.
 * 
 *    Rev 1.0   05 Oct 1992 17:19:48   GAKIO
 * Initial revision.
 * 
 *    Rev 1.1   08 Sep 1992 16:03:38   arnoff
 * gakio	Added ClearBoxes() to initialize the edit boxes
 * gakio	Removed do_shout().
 * 
 *    Rev 1.0   26 Aug 1992 12:39:32   arnoff
 *  
 */
