/*
 * $Header:   J:/devkit.dos/vcs/srcsmpl/wshout/src/wshout.c_v   1.3.1.0   26 Apr 1993 18:01:52   rcq  $
 */

/*
 * Filename: WSHOUT.C
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 10-Apr-90	daveb	Ported from jbvb's 2.04pl1 prod tctest\shout.c.
 * 21-May-90	jog and over to OS/2 without changing a thing; beauteous
 * 25-May-90	jog cleaned up a bit, print how much have written if get 
 *	    error when still writing
 * 13-Jun-90	jog made arg parsing if/else rather than switch/case, 
 *	    cleaned up some more..., prototype main() 
 * 14-Jun-90	jog AF_INET -> PF_INET
 * 06-Jun-90	jog added stdlib.h, string.h
 * 04-Feb-91	jog io.h, data_buffer hold ints, use BUF_SIZE, 
 *	    total_time is "double"
 * 20-Aug-91	gakio	Ported to Windows 3.0
 * 26-Mar-92	gakio	Modified to use Dialog Box as main window.
 * 26-May-92	gakio	Removed reference to <ioctl.h>. Handled by winsock.h.
 * 12-Jun-92	gakio	Modified to run on WinsockAPI.
 * 20-Aug-92	gakio	Changed all MessageBoxes to the type MB_APPLMODAL.
 * 21-Aug-92	gakio	Changed the name of this file from main.c to wshout.c
 * 24-Aug-92	gakio	Added WM_SYSCOMMAND to dialog to enable minimized icon
 * 28-Aug-92	gakio	Added ClearBoxes() to initialize the edit boxes
 * 09-Sep-92	gakio	Added DLL Version verification, and dynamic updating
 *			 of the About box.
 * 10-Sep-92	gakio	Don't need second closesocket() in case IDD_CANCEL.
 * 11-Sep-92	gakio	WSAStartup returns 0 OR error code!
 * 02-Nov-92	gakio	Moved SOCKET sd here from wshout.h.
 * 11-Nov-92	gakio	Fixed Cancel Blocking Call paradigm.
 * 12-Nov-92	gakio	Added ShoutBlockingHook().
 * 14-Jan-92	gakio	Fixed cancellation of nonblocking accept() and recv()
 * 25-Jan-92	gakio	Added global iPortNo to make port no user configurable
 *			 Added port argument to ResolveAndConnectHost() & 
 *			 GetSocketAndBind().
 * 25-Apr-93	rcq	cleaned up header, removed prbuf1 reference, added
 *			 MSC headers (which were in .H file) and new err msg
 *			 function wshout_err() added and calls to it.
 */

/* MSC Include files: */
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "wshout.h"

#define MAJOR_VERSION	1
#define MINOR_VERSION	2
#define WSA_MAKEWORD(x,y)	((y) * 256 + (x)) /* HI:Minor, LO:Major */

HANDLE	hInst;			/* Handle for Instance */
HWND	hOurWnd;		/* Handle for Main Window */
HWND	hMainDlg;		/* Handle for Main Dialog Box */

int ret;			/* Work variable */
char	prbuf[PRBUF_LEN];	/* Work buffer to format text for display */

SOCKET sd;			/* Connection socket descriptor		*/
long temporary_option   = 0L;	/* Blocking mode is the default		*/
long blocking_option    = 0L;	/* Global indicator of blocking mode	*/
int run_cancelled	= 0;	/* Indicates when cancel button is hit	*/
int len = 1024;			/* # of bytes to write at a time	*/
BOOL	running = FALSE;	/* State of the program			*/
const int iTCP = 1;		/* Specifies TCP Shout			*/
const int iUDP = 2;		/* Specifies UDP Shout			*/
int iProto	= 1;		/* TCP Shout is the default		*/
int iPortNo	= SOCK_SHOUT;	/* TCP via SOCK_SHOUT is the default	*/
int temporary_protocol  = 1;	/* Used in Settings()			*/
int iShout  = 1;
int iListen = 2;
int iClientOrServer = 1;	/* Shout is default			*/
int tClientOrServer = 1;	/* Used in Settings()			*/
char HostModeBuf[20];		/* Holds the mode string		*/
WORD VersionReqd;
LPWSADATA lpmyWSAData;

int PASCAL
WinMain (HANDLE hInstance,HANDLE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{

    HWND hWnd;
    MSG msg;
    BOOL InitApp(HANDLE);

    if (!hPrevInstance)
	if (!InitApp(hInstance))
	    return (NULL);

    hInst = hInstance;

    hWnd = CreateWindow("MainMenu",
	"Windows Shout",
	WS_OVERLAPPEDWINDOW | WS_SYSMENU | WS_MINIMIZEBOX,
	CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInstance,
        NULL);

    if (!hWnd)
	return (NULL);

    hOurWnd = hWnd;
    
    while (GetMessage(&msg, NULL, NULL, NULL)) {
	TranslateMessage(&msg); /* Translate  virtual key codes */
	DispatchMessage(&msg);	/* Dispatch message to window	*/
    }

    return (msg.wParam);
}

BOOL InitApp(HANDLE hInstance)
{
    HANDLE hMemory;
    PWNDCLASS pWndClass;
    BOOL bSuccess;

    hMemory = LocalAlloc(LPTR, sizeof(WNDCLASS));
    pWndClass = (PWNDCLASS) LocalLock(hMemory);
    pWndClass->hCursor = LoadCursor(NULL, IDC_ARROW);
    pWndClass->hIcon = LoadIcon(hInstance, (LPSTR) "SHOUT");
    pWndClass->lpszMenuName = (LPSTR) "MainMenu";
    pWndClass->lpszClassName = (LPSTR) "MainMenu";
    pWndClass->hbrBackground = GetStockObject(WHITE_BRUSH);
    pWndClass->hInstance = hInstance;
    pWndClass->style = NULL;
    pWndClass->lpfnWndProc = ShoutWndProc;

    bSuccess = RegisterClass(pWndClass);

    LocalUnlock(hMemory);
    LocalFree(hMemory);
    return (bSuccess);
}

long FAR PASCAL ShoutWndProc(HWND hWnd, WORD message,WORD wParam, LONG lParam)
{
    FARPROC lpDialogBoxProc;

    switch (message){
	case WM_CREATE:
	    
	    /* Put up the dialog box */
	    lpDialogBoxProc = MakeProcInstance(DialogProc, hInst);
	    DialogBox (hInst, (LPSTR) "MainDialog", hWnd, lpDialogBoxProc) ;
	    FreeProcInstance(lpDialogBoxProc);
	    PostMessage(hWnd, WM_DESTROY, 0, 0L);
	    break;
	    
	case WM_DESTROY:
	    PostQuitMessage(0);
	    break;
	
	default:
	    return(DefWindowProc(hWnd, message, wParam, lParam));
	}
    return NULL;

}


BOOL FAR PASCAL DialogProc(HWND hOurDlg, WORD message, WORD wParam, LONG lParam)
{
    FARPROC lpProcAbout;
    FARPROC lpProcSettings;
    long lret;
    WORD wMajorVersion, wMinorVersion;
    char hostnm[64];		/* Work buffer to contain hostname */
 
    switch (message) {
	case WM_INITDIALOG:
	    /* Select a default host */
	    SetDlgItemText(hOurDlg, IDD_HNAME, "");
	    SendDlgItemMessage(hOurDlg,		/* dialog handle	*/
		IDD_HNAME,			/* where to send msg	*/
		EM_SETSEL,			/* select characters	*/
		NULL,				/* additional info	*/
		MAKELONG(0, 0x7fff));		/* entire contents	*/
	    SetFocus(GetDlgItem(hOurDlg, IDD_HNAME));
	    
	    /* Perform initializations */
	    hMainDlg = hOurDlg;  /* Remember our window handle */
	    SetDlgItemText(hOurDlg, IDD_COHOST,"Shout to:");
	    wMajorVersion = MAJOR_VERSION;
	    wMinorVersion = MINOR_VERSION;
	    VersionReqd=WSA_MAKEWORD(wMajorVersion, wMinorVersion);
  
	    lpmyWSAData = (LPWSADATA)_calloc(1, sizeof(WSADATA));
	    
	    ret = WSAStartup(VersionReqd, lpmyWSAData);
	    
	    if (ret != 0){
		wshout_err (hOurDlg, WSAGetLastError(), "WSAStartup()");
	    }
	    
	    return (TRUE); /* Indicates the focus is set to a control	*/

	case WM_CLOSE:
	    PostMessage(hOurDlg, WM_COMMAND, IDM_EXIT, 0L);
	    break;
	    
	case WM_SYSCOMMAND:
	    /* Pass these messages to main window so that the icon is
		displayed when the window is minimized */
	    SendMessage(hOurWnd, message, wParam, lParam);
	    break;
	    
	case WM_COMMAND:
	    switch (wParam) {
	    case IDD_CONNECT:		/* Connect button clicked	*/
	    case IDM_START:		/* Start menu selected		*/
		run_cancelled = FALSE;
		/* Do not re-enter */
		if (running){
		    MessageBox(hOurWnd,"Shout is already running !",
			"Shout", MB_OK | MB_APPLMODAL | MB_ICONEXCLAMATION);
		    return FALSE;
		}
		ClearBoxes(hOurDlg);
		running = TRUE;

		if (iClientOrServer == iShout) {
		   /* Ensure hostname is available	*/
		   if (GetDlgItemText (hOurDlg, IDD_HNAME, hostnm, 80) < 2) {
		       MessageBeep(0);
		       SetDlgItemText(hOurDlg, 
			              IDD_COMMENT,"No hostname specified");
		       running = FALSE;
		       break;
		   }
		   sd = ResolveAndConnectHost((char FAR *)hostnm,hOurDlg,iProto,
		                              iPortNo);
		   if (sd == SOCKET_ERROR) {/* Couldn't create socket */
		       running = FALSE;
		       break;
		   }
	        }
		else {
		   sd = GetSocketAndBind(hOurDlg, iProto, iPortNo);
		   if (sd == SOCKET_ERROR) {
		    running = FALSE;
		    break;
		   }
	        }
		
		/* Set the I/O mode of the socket */
		if (blocking_option) {
		    lret = 1L;  /* Nonblocking mode */
		    ioctlsocket(sd, FIONBIO, (u_long FAR *) &lret);
		}
		else {
		    lret = 0L; /* blocking mode */
		    ioctlsocket(sd, FIONBIO, (u_long FAR *) &lret);
		}
		
		if (iClientOrServer == iShout) {  /* SHOUT */
		    /* Create data and write to the socket */
		    if (iProto == iTCP) 
			lret = TWriteData(sd, hOurDlg, len);
		    else /* UDP */
			lret = UWriteData(sd, hOurDlg, len);
		}
		else {	/* LISTEN */
		    if (iProto == iTCP)
			lret = TReadData(sd,hOurDlg, len);
		    else /* UDP */
			lret = UReadData(sd,hOurDlg, len);
		}
		
		closesocket(sd);
		running = FALSE;
		break;
		
	    case IDD_CANCEL: /* the Cancel button clicked */
		if (running) {
		    /* Stop writing to network */
		    ret = WSACancelBlockingCall();
		    run_cancelled = TRUE;
		    if (ret == SOCKET_ERROR) {
			/* WSANOTINITIALISED or WSAENETDOWN or WSAEINVAL */
			if (h_errno == WSAENETDOWN) {
			    /* Watch out for hAcceptSock! */
			    /* close what is left of the connection */
			    closesocket(sd);
			}
		    }
		}
		break;
		
	    case IDM_EXIT:
		ret = WSACleanup();
		if (ret == SOCKET_ERROR && h_errno == WSAEINPROGRESS){
		    MessageBox(hOurWnd, 
			"Data transfer in progress.\nStop transfer first.",
			"WndProc()", MB_OK | MB_APPLMODAL|MB_ICONINFORMATION);
		    break; /* A socket is currently blocked */
		}
		
		_free((char NEAR *) lpmyWSAData);
		EndDialog(hOurDlg, TRUE) ; /*  Exit the application    */
		break;
		
	    case IDM_ABOUT:
		lpProcAbout = MakeProcInstance(About, hInst);
		DialogBox(hInst, "AboutBox", hOurDlg, lpProcAbout);
		FreeProcInstance(lpProcAbout);
		break;
		
	    case IDM_SETTINGS:
		lpProcSettings = MakeProcInstance(Settings, hInst);
		DialogBox(hInst, "SettingsDialog", hOurDlg, lpProcSettings);
		FreeProcInstance(lpProcSettings);
		break;
		
	    default:
		break;
		
	    } /* switch (wParam) */
	    break;
	} /* switch (message) */
    return FALSE;
}


/* This processes the messages for the About dialog box */
BOOL FAR PASCAL About(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
    char tempBuf[15];
    
    switch (message) {
    case WM_INITDIALOG:
	SetDlgItemText(hDlg, IDA_COPYRIGHT,(LPSTR)lpmyWSAData->szDescription);

	wsprintf(tempBuf, "%d.%2d\n",MAJOR_VERSION, MINOR_VERSION);
	SetDlgItemText(hDlg, IDA_APP_VERSION, (LPSTR) tempBuf);

	wsprintf(tempBuf, "%d.%2d\n", 
	         lpmyWSAData->wVersion%256,lpmyWSAData->wVersion/256);
	SetDlgItemText (hDlg, IDA_DLL_VERSION, (LPSTR) tempBuf);
	return (FALSE);

    case WM_COMMAND:
	if (wParam == IDOK
	|| wParam == IDCANCEL) {
	EndDialog(hDlg, TRUE);
	return (TRUE);
	}
	break;
    }
    return (FALSE);
}

/* This processes the messages for the Settings dialog box */
BOOL FAR PASCAL Settings(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
    int buffer_len = len;
    int port_no    = iPortNo;
    
    switch (message) {
    case WM_INITDIALOG:
	/* Select a default send() buffer length */
	SetDlgItemInt(hDlg, IDS_BUFFLEN, len, 0);

	/* Select a default port number */
	SetDlgItemInt(hDlg, IDS_PORTNO, iPortNo, 0);

	if (iClientOrServer == iShout)		/* Program		*/
	    CheckThisProgBoxOn(hDlg, IDS_CLIENT);
	else
	    CheckThisProgBoxOn(hDlg, IDS_SERVER);
	
	if (iProto == iTCP)			/* Protocol		*/
	    CheckThisProtoBoxOn(hDlg, IDS_TCP);
	else
	    CheckThisProtoBoxOn(hDlg, IDS_UDP);
	
	if (!blocking_option)			/* Blocking mode	*/
	    CheckThisBoxOn(hDlg, IDS_BLOCK);
	else
	    CheckThisBoxOn(hDlg, IDS_NOBLOCK);
	
	SendDlgItemMessage(hDlg,		/* dialog handle	*/
		IDS_PORTNO,			/* where to send msg	*/
		EM_SETSEL,			/* select characters	*/
		NULL,				/* additional info	*/
		MAKELONG(0, 0x7fff));		/* entire contents	*/
	    
	SendDlgItemMessage(hDlg,		/* dialog handle	*/
		IDS_BUFFLEN,			/* where to send msg	*/
		EM_SETSEL,			/* select characters	*/
		NULL,				/* additional info	*/
		MAKELONG(0, 0x7fff));		/* entire contents	*/
	SetFocus(GetDlgItem(hDlg, IDS_BUFFLEN));
	return (TRUE);

    case WM_COMMAND:
	switch (wParam){
	case IDS_CLIENT:
	    /* USer has set to Shout */
	    CheckThisProgBoxOn(hDlg, IDS_CLIENT);
	    tClientOrServer = iShout;
	    SetDlgItemText(hMainDlg, IDD_COHOST,"Foreign host:");
	    SetDlgItemText(hMainDlg, IDD_HNAME,"");
	    break;
	case IDS_SERVER:
	    /* USer has set to Listen */
	    CheckThisProgBoxOn(hDlg, IDS_SERVER);
	    tClientOrServer = iListen;
	    SetDlgItemText(hMainDlg, IDD_COHOST,"Listening to:");
	    SetDlgItemText(hMainDlg, IDD_HNAME,"[Hit 'Start']");
	    break;
	case IDS_TCP:
	    /* USer has set to TCP */
	    CheckThisProtoBoxOn(hDlg, IDS_TCP);
	    temporary_protocol = iTCP;
	    break;
	case IDS_UDP:
	    /* USer has set to UDP */
	    CheckThisProtoBoxOn(hDlg, IDS_UDP);
	    temporary_protocol = iUDP;
	    break;
	case IDS_BLOCK:
	    /* User has set to blocking mode */
	    CheckThisBoxOn(hDlg, IDS_BLOCK);
	    temporary_option = 0L;
	    break;
	case IDS_NOBLOCK:
	    /* User has set to nonblocking mode */
	    CheckThisBoxOn(hDlg, IDS_NOBLOCK);
	    temporary_option = 1L;
	    break;
	case IDOK:
	    /* User has finished modifying settings */
	    buffer_len = GetDlgItemInt(hDlg, IDS_BUFFLEN, NULL, 0);
	    if (buffer_len == 0 || buffer_len > 8192) {
		MessageBox(hOurWnd, "Buffer length must be between 1 and 8K",
			   "Settings()", 
			   MB_OK | MB_APPLMODAL | MB_ICONSTOP);
		return (FALSE);
	    }
	    
	    port_no = GetDlgItemInt(hDlg, IDS_PORTNO, NULL, 0);
	    if (port_no == 0) {
		MessageBox(hDlg, "Port number must be between 0 and 65,535",
			   "Settings()", 
			   MB_OK | MB_APPLMODAL | MB_ICONSTOP);
		return (FALSE);
	    }
	    len     = buffer_len;
	    iPortNo = port_no;
	    blocking_option = temporary_option;
	    iProto	    = temporary_protocol;
	    iClientOrServer = tClientOrServer;
	    
	case IDCANCEL:
	    /* User does not want to change settings */
	    EndDialog(hDlg, TRUE);
	    return (TRUE);
	    
	default:
	    break;
	}

    default:
	break;
    }
    return (FALSE);
}

void 
CheckThisBoxOn(HWND hDlg, int ButtonID)
{
    switch (ButtonID) {
    case IDS_BLOCK:
	CheckDlgButton(hDlg, IDS_BLOCK, 1);
	CheckDlgButton(hDlg, IDS_NOBLOCK, 0);
	break;
    case IDS_NOBLOCK:
	CheckDlgButton(hDlg, IDS_BLOCK, 0);
	CheckDlgButton(hDlg, IDS_NOBLOCK, 1);
	break;
    default:
	break;
    }
    return;
}

void 
CheckThisProtoBoxOn(HWND hDlg, int ButtonID)
{
    switch (ButtonID) {
    case IDS_TCP:
	CheckDlgButton(hDlg, IDS_TCP, 1);
	CheckDlgButton(hDlg, IDS_UDP, 0);
	break;
    case IDS_UDP:
	CheckDlgButton(hDlg, IDS_TCP, 0);
	CheckDlgButton(hDlg, IDS_UDP, 1);
	break;
    default:
	break;
    }
    return;
}

void 
CheckThisProgBoxOn(HWND hDlg, int ButtonID)
{
    switch (ButtonID) {
    case IDS_CLIENT: /* Shout */
	CheckDlgButton(hDlg, IDS_CLIENT, 1);
	CheckDlgButton(hDlg, IDS_SERVER, 0);
	break;
    case IDS_SERVER: /* Listen */
	CheckDlgButton(hDlg, IDS_CLIENT, 0);
	CheckDlgButton(hDlg, IDS_SERVER, 1);
	break;
    default:
	break;
    }
    return;
}

/* This is how we handle "fake blocking"--this 
   routine checks the message queue, and returns
   a positive value if it found a message to work on.
 */
int
ShoutBlockingHook (void)
{
  MSG msg;		/* lets us pull messages via PeekMessage */
  int ret = PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);

  if (ret) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return ret;
}

char *
_calloc (nelem, elsize)
 unsigned nelem, elsize;
{
	 HANDLE hMem;
	 PSTR ptr;
	 unsigned size = nelem * elsize;

	if ((hMem = LocalAlloc(LPTR, size)) == NULL)
		return (char *) 0;
	if ((ptr = LocalLock(hMem)) == NULL) {
		LocalFree(hMem);
		return (char *) 0;
	}
	return (char *) ptr;
}

void
_free (void *cP)
{
	(void) LocalFree(LocalHandle((WORD) cP));
}

void 
ClearBoxes(HWND hOurDlg)
{
    wsprintf(prbuf,"         \n");
    SetDlgItemText(hOurDlg, IDD_WRITE, (LPSTR) prbuf);
    SetDlgItemText(hOurDlg, IDD_SENT, (LPSTR) prbuf);
    SetDlgItemText(hOurDlg, IDD_TIME, (LPSTR) prbuf);
    SetDlgItemText(hOurDlg, IDD_WRITES,(LPSTR) prbuf);
    SetDlgItemText(hOurDlg, IDD_BYTES, (LPSTR) prbuf);
    SetDlgItemText(hOurDlg, IDD_BITS,  (LPSTR) prbuf);
    
    return;
}

/*
 * Function: wshout_err()
 *
 * Description:
 *
 *  takes an error number and string, gets error text for error number
 *  prepends the user string to it and displays it in the dialog comment
 *  box.  This function could be adapted for use in other programs by
 *  replacing the SetDlgItemTxt() parameters or replacing the function
 *  itself with a MessageBox() call.
 */
void wshout_err (HWND hOurDlg,          /* Window Handle for Dialog Box */
		 int wsa_err,           /* WinSock Error Number */
		 char far *err_prefix)  /* Error prefix string */
{
	char errbuf[PRBUF_LEN];	 /* Error Buffer */

        /* Get Error text */
	WSAsperror(hInst, wsa_err, (LPSTR)errbuf, PRBUF_LEN);
	    
	/* Format error text with user string */    
	wsprintf((LPSTR)prbuf, "%s:%s", (LPSTR) err_prefix, (LPSTR)errbuf);
    
	/* Display formatted error text in Dialog Box */
	SetDlgItemText(hOurDlg, IDD_COMMENT, (LPSTR) prbuf);
	
}  /* end wshout_err() */


/* eof */
/*
 * $Log:   J:/devkit.dos/vcs/srcsmpl/wshout/src/wshout.c_v  $
 * 
 *    Rev 1.3.1.0   26 Apr 1993 18:01:52   rcq
 * added new error message display, updated headers, general cleaning
 * 
 *    Rev 1.3   28 Jan 1993 14:22:32   GAKIO
 * Added ShoutBlockingHook() to allow for use as "fake blocking" hook.
 * Added user-configurable port number.
 * 
 *    Rev 1.2   12 Nov 1992 11:11:22   GAKIO
 * Fixed data transfer interrruption paradigm by using Stop button only
 *  for calling WSACancelBlockingCall and not for closing the socket.
 * 
 *    Rev 1.1   04 Nov 1992 14:19:36   GAKIO
 * Moved SOCKET sd here from wshout.h
 * 
 *    Rev 1.0   05 Oct 1992 17:08:34   GAKIO
 * Initial revision.
 * 
 *    Rev 1.1   08 Sep 1992 16:03:10   arnoff
 * gakio	Added ClearBoxes() to initialize the edit boxes
 * gakio	Removed do_shout().
 * 
 *    Rev 1.0   26 Aug 1992 12:39:26   arnoff
 *  
 */
