/*
 * $Header:   J:/devkit.dos/vcs/srcsmpl/wshout/src/tshout.c_v   1.3.1.0   26 Apr 1993 18:01:28   rcq  $
 */

/*
 * Filename: TSHOUT.C
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 10-Apr-90	daveb 	Ported from jbvb's 2.04pl1 prod tctest\shout.c.
 * 21-May-90	jog	and over to OS/2 without changing a thing; beauteous
 * 25-May-90	jog	cleaned up a bit, print how much have written if get 
 *			error when still writing
 * 13-Jun-90	jog	made arg parsing if/else rather than switch/case, 
 *			cleaned up some more..., prototype main() 
 * 14-Jun-90	jog	AF_INET -> PF_INET
 * 06-Jun-90	jog	added stdlib.h, string.h
 * 04-Feb-91	jog	io.h, data_buffer hold ints, use BUF_SIZE, 
 *			total_time is "double"
 * 20-Aug-91	gakio	Ported to Windows 3.0
 * 26-Mar-92	gakio	Modified to use Dialog Box as main window.
 * 26-May-92	gakio	Removed reference to <ioctl.h>. Handled by winsock.h.
 * 12-Jun-91	gakio	Modified to run on WinsockAPI.
 * 11-Aug-92	gakio	Combined with shout.
 * 12-Oct-92	gakio	Fixed cast of double to LPSTR in wsprintf.
 * 02-Nov-92	gakio	prbuf's must be used as LPSTRs in wsprintf.
 * 03-Nov-92	gakio	Replaced double rtemp with long ltemp.
 * 25-Jan-93	gakio	Added a fake blocking hook to compensate for
 *			 winsock.dll implementation of blocking.
 *			Fixed send() interruption mechanism.
 * 25-Apr-93	rcq	cleaned-up header, removed references to prbufs,
 *			 added MS Headers (that were in wshout.h) and added
 *			 new error message display.
 */

#include "wshout.h"

/* MSC Include files: */
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>


/* Returns the number of bytes written */
long TWriteData(SOCKET hSock, HWND hOurDlg, int send_len) 
{
    int counter;
    static int DataBuffer[BUF_SIZE];	  /* Buffer to hold generated data  */
    long	total_len = 1024L*1024L;  /* Total # of bytes to generate   */
    long	bytes_sent = 0L;	  /* Counter of bytes on connection */
    int 	tmp = 0;		  /* holds count for bytes written  */
    long	write_count = 0L;	  /* number of times		    */
    time_t	start, end;		  /* variables to hold read timing  */
    long	total_time = 0L;	  /* variable to hold delta t       */
    long ltemp = 0L;
    extern int run_cancelled;
    
    /* What makes shout unique is that it generates data*
     * in memory (as opposed to accessing the disk).	*
     * This tests the 'raw' speed of the TCP connection	*
     * as the rate-limiting access time is eliminated.	*
     * First, generate the data and place it into an	*
     * array, data_buffer:				*/
    
    for (counter = 0; counter < BUF_SIZE; counter++)
	DataBuffer[counter] = counter;
    
    /* Write data on the descriptor like a banshee,
     * careful to time the writes and count data
     * transmitted:
     */
    
    SetDlgItemText(hOurDlg, IDD_COMMENT, "...Sending TCP Data");
    time(&start);	
    while ( bytes_sent < total_len) {   /* while still bytes to send... */
	do {
	    ;
	} while (ShoutBlockingHook()); /* Dispatch messages if any */
	
	if (run_cancelled) {
	    WSASetLastError(WSAEINTR);
	    break;	/* Non-blocking mode was cancelled */
	}
	    
	tmp = send(hSock, (char FAR*) &DataBuffer, send_len, 0);
	if (tmp == SOCKET_ERROR) {
	    if (h_errno == WSAEWOULDBLOCK)
		continue;
	    else {
		wshout_err (hOurDlg, WSAGetLastError(), "send()");
	    }
	    
	    /* Calc. time elapsed & stats about any data sent */
	    time(&end);
	    /* exit from the while loop */
	    break;
	    
	} /* end if (tmp == -1) */
	write_count++;	    /* incr. counter of times written */
	bytes_sent += tmp;  /* total # of bytes placed on connection*/
	wsprintf(prbuf,"%ld\n",write_count);
	SetDlgItemText(hOurDlg, IDD_WRITE, (LPSTR) prbuf);

	wsprintf(prbuf,"%ld\n",bytes_sent);
	SetDlgItemText(hOurDlg, IDD_SENT, (LPSTR) prbuf);
    } /* end while */
    time(&end);
    
    if (total_time = (long) difftime(end, start)) {
	/* Print the statistics gathered    */
	wsprintf((LPSTR)prbuf,"%ld\n",total_time);
	SetDlgItemText(hOurDlg, IDD_TIME, (LPSTR) prbuf);
	
	ltemp = write_count/total_time;
	wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
	SetDlgItemText(hOurDlg, IDD_WRITES,(LPSTR) prbuf);
	
	ltemp = bytes_sent/total_time;
	wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
	SetDlgItemText(hOurDlg, IDD_BYTES, (LPSTR) prbuf);
	
	ltemp = 8 * (bytes_sent/total_time);
	wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
	SetDlgItemText(hOurDlg, IDD_BITS,  (LPSTR) prbuf);
    } /* end if (total_time) */
	    
    /* All done */
    SetDlgItemText(hOurDlg, IDD_COMMENT, "...TCP Shout Done");
    return bytes_sent;
}

/* eof */

/*
 * $Log:   J:/devkit.dos/vcs/srcsmpl/wshout/src/tshout.c_v  $
 * 
 *    Rev 1.3.1.0   26 Apr 1993 18:01:28   rcq
 * added new error message display, updated headers, general cleaning
 * 
 *    Rev 1.3   28 Jan 1993 14:08:50   GAKIO
 * Added a fake blocking loop to compensate for winsock.dll changes.
 * Fixed send() interruption mechanism.
 * 
 *    Rev 1.2   04 Nov 1992 14:26:12   GAKIO
 * Replaced double rtemp with long ltemp.
 * prbuf's referred to as LPSTR in wsprintf.
 * 
 *    Rev 1.1   14 Oct 1992 00:38:16   GAKIO
 * Fixed improper cast of double to LPSTR in wsprint
 * 
 *    Rev 1.0   05 Oct 1992 17:07:10   GAKIO
 * Initial revision.
 * 
 *    Rev 1.0   26 Aug 1992 12:39:16   arnoff
 *  
 */
