/*
 * $Header:   J:/devkit.dos/vcs/srcsmpl/wshout/src/tlisten.c_v   1.4.1.0   26 Apr 1993 18:01:46   rcq  $
 */

/*
 * TLISTEN.C
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 10-Apr-90	daveb	Ported from jbvb's 2.04pl1 prod tctest\shout.c.
 * 21-May-90	jog and over to OS/2 without changing a thing; beauteous
 * 25-May-90	jog cleaned up a bit, print how much have written if get 
 *	    error when still writing
 * 13-Jun-90	jog made arg parsing if/else rather than switch/case, 
 *	    cleaned up some more..., prototype main() 
 * 14-Jun-90	jog AF_INET -> PF_INET
 * 06-Jun-90	jog added stdlib.h, string.h
 * 04-Feb-91	jog io.h, data_buffer hold ints, use BUF_SIZE, 
 *	    total_time is "double"
 * 20-Oct-91	gakio	Ported to Windows 3.0
 * 30-Mar-92	gakio	Removed refs to bsd header files, now uses winsock.h
 * 27-Apr-92	gakio	Moved prototype of dll_close() to listen.h
 *			Added init_dll() in order to allow socket dll to 
 *			 track multiple applications.
 * 07-May-92	gakio	Fixed the TCP window going to 0 bug. Added an icon.
 * 30-Jul-92	gakio	Modified for WinsockAPI.
 * 11-Aug-92	gakio	Consolidated with Shout.
 * 20-Aug-92	gakio	Was popping out on WSAEWOULDBLOCK in accept().
 * 26-Aug-92	gakio	Fixed extra char appended to hostname in server mode.
 *			 (replaced wsprintf() with _fmemcpy)
 * 10-Sep-92	gakio	recv() now uses a user configurable no. of read bytes.
 * 12-Oct-92	gakio	Fixed cast of double to LPSTR in wsprintf.
 * 03-Nov-92	gakio	prbuf's must be referred to as (LPSTR) in wsprintf
 * 03-Nov-92	gakio	Changed double rtemp with long ltemp.
 * 12-Nov-92	gakio	Added SO_LINGER to allow graceful close of the socket.
 *			Settled on linger timeout of zero so closesocket()
 *			 returns immediately with a hard close.
 *			Added a blocking hook to give other tasks a chance.
 * 14-Jan-92	gakio	Fixed cancellation of nonblocking accept() and recv()
 * 25-Apr-92	rcq	cleaned-up header, removed references to prbufs,
 *			 added MS hdrs (that were in WSHOUT.H) and added new
 *			 error message display
 */

#include "wshout.h"

/* MSC Include files: */
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>


/* Returns the number of bytes written */
long TReadData(SOCKET hSock, HWND hOurDlg, int read_len)
{
    static char	ReadBuf[BUF_SIZE];
    SOCKET hAcceptSock;
    struct sockaddr_in local;	/* Local machine address structure	*/
    long total_time = 0L;       /* variable to hold delta t		*/
    int	tmp, len   = 0;
    int	num_reads  = 0;
    long bytes_read = 0L;
    long last_time = 0L;
    long now = 0L;
    long ltemp;
    extern long blocking_option;
    extern int run_cancelled;
    struct linger AcceptLinger;

    BOOL running = FALSE;
    BOOL bTemp = TRUE;
    
    SetDlgItemText(hOurDlg, IDD_COMMENT, "Awaiting the TCP Data ...");
    SetDlgItemText(hOurDlg, IDD_HNAME, "                      ");
    
    tmp = sizeof(local);
    if (!blocking_option) {
	hAcceptSock = accept(hSock,(struct sockaddr FAR *)&local,
	    (int FAR *)&tmp);
    }
    else {
	for (;;) {
	    do {
		;
	    } while (ShoutBlockingHook()); /* Dispatch messages if any */
	
	    if (run_cancelled) {
		WSASetLastError(WSAEINTR);
		break;	/* Non-blocking mode was cancelled */
	    }
	    
	    hAcceptSock = accept(hSock,(struct sockaddr FAR *)&local,
			             (int FAR *)&tmp);
	    if (hAcceptSock == INVALID_SOCKET) {
		if (h_errno == WSAEWOULDBLOCK)
		    /* Try again */
		    ;
		else {
		    /* Fatal error -- pop out. */
		    break;
		}
	    } /* end if ((hAcceptSock = .. */
	    else {
		/* Success -- pop out. */
		break;
	    }
	} /* end for */
    } /* end else */
    
    if (hAcceptSock == INVALID_SOCKET) {
	wshout_err (hOurDlg, WSAGetLastError(), "accept()");
	return 0;
    }
    
    /* Now, read the data as fast as we can until no more to read */
    time(&last_time);
    do {
	do {
	    ;
	} while (ShoutBlockingHook()); /* Dispatch messages while available */
	
	if (run_cancelled) {
	    WSASetLastError(WSAEINTR);
	    break;	/* Non-blocking mode was cancelled */
	}
	    
	len = recv(hAcceptSock, ReadBuf, read_len, 0);
	if (len == SOCKET_ERROR) {
	    if (h_errno == WSAEWOULDBLOCK)
		continue;
	    else
		break;
	} 
	else if (len == 0) 
	    break;
	num_reads++;
	bytes_read += len;
	
	wsprintf((LPSTR)prbuf,"%d\n",num_reads);
	SetDlgItemText(hOurDlg, IDD_WRITE, (LPSTR) prbuf);

	wsprintf((LPSTR)prbuf,"%ld\n",bytes_read);
	SetDlgItemText(hOurDlg, IDD_SENT, (LPSTR) prbuf);
	
	if (bTemp) {	/* To update our main display once */
	    /* Do not use wsprintf() or you will add an extra char */
	     _fmemcpy(prbuf, inet_ntoa(local.sin_addr), 4*sizeof(u_long));
	     SetDlgItemText(hOurDlg, IDD_HNAME, (LPSTR) prbuf);
	     SetDlgItemText(hOurDlg, IDD_COMMENT, "Reading TCP Data ...");
	     bTemp = FALSE;
	}
	
    } while ((len != 0) || (len != SOCKET_ERROR));
    time (&now);
    
    if (len == SOCKET_ERROR) {
	if ((h_errno == WSAESHUTDOWN) || (h_errno == WSAENOTCONN)) {
	    /* nothing available for read. */
	    wsprintf((LPSTR)prbuf, 
		"Connection from %s closed.\n",inet_ntoa(local.sin_addr));
	    SetDlgItemText(hOurDlg, IDD_COMMENT, prbuf);
	}
	else { /* Other error */
	    wshout_err (hOurDlg, WSAGetLastError(), "recv()");
	}
    }
    else if (len == 0) {
	/* Other side shut down the connection */
	wsprintf((LPSTR)prbuf, 
	    "Connection from %s closed.\n",inet_ntoa(local.sin_addr));
	SetDlgItemText(hOurDlg, IDD_COMMENT, prbuf);
    }

    AcceptLinger.l_onoff = 1;
    AcceptLinger.l_linger = 0;
    ret = setsockopt(hAcceptSock, SOL_SOCKET, SO_LINGER, 
	             (char FAR *) &AcceptLinger, sizeof(AcceptLinger));
    if (ret == SOCKET_ERROR) {
	wshout_err (hOurDlg, WSAGetLastError(), "setsockopt()");
    }
    
    ret = closesocket(hAcceptSock);
    if (ret == SOCKET_ERROR) {
	wshout_err (hOurDlg, WSAGetLastError(), "closesocket()");
    }
    
    total_time = (long) difftime(now, last_time);
    if (total_time == 0)
	total_time = 1L;     /* Avoid dividing by zero */

    wsprintf((LPSTR)prbuf,"%ld\n",total_time);
    SetDlgItemText(hOurDlg, IDD_TIME, (LPSTR) prbuf);
     
    ltemp = num_reads/total_time;
    wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
    SetDlgItemText(hOurDlg, IDD_WRITES,(LPSTR) prbuf);
    
    ltemp = bytes_read/total_time;
    wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
    SetDlgItemText(hOurDlg, IDD_BYTES, (LPSTR) prbuf);
    
    ltemp = 8 * (bytes_read/total_time);
    wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
    SetDlgItemText(hOurDlg, IDD_BITS,  (LPSTR) prbuf);
     
    if (bytes_read) {
	SetDlgItemText(hOurDlg, IDD_COMMENT, "...TCP Listen Done\n");
    } /* end: if (bytes_read) */
     
    return (bytes_read);
}

/* eof */

/*
 * $Log:   J:/devkit.dos/vcs/srcsmpl/wshout/src/tlisten.c_v  $
 * 
 *    Rev 1.4.1.0   26 Apr 1993 18:01:46   rcq
 * added new error message display, updated headers, general cleaning
 * 
 *    Rev 1.4   28 Jan 1993 14:19:32   GAKIO
 * Added a fake blocking loop to compensate for changes in winsock.dll
 * Fixed cancellation of non-blocking accept() and recv().
 * 
 *    Rev 1.3   12 Nov 1992 11:07:26   GAKIO
 * Bug Fixed: Server (blocking mode) does not allow interruption of data
 *  transmission. Fixed by adding linger and fixing break on WSAEINTR.
 * 
 *    Rev 1.2   04 Nov 1992 14:31:46   GAKIO
 * Replaced double rtemp with long ltemp,
 * prbuf's referred to as LPSTR in wsprintf.
 * 
 *    Rev 1.1   14 Oct 1992 00:39:16   GAKIO
 * Fixed improper cast of double to LPSTR in wsprint
 * 
 *    Rev 1.0   05 Oct 1992 17:06:26   GAKIO
 * Initial revision.
 * 
 *    Rev 1.1   08 Sep 1992 16:06:18   arnoff
 * gakio	Fixed extra char appended to hostname in server mode.
 * 	 (replaced wsprintf() with _fmemcpy)
 * 
 *    Rev 1.0   26 Aug 1992 12:39:12   arnoff
 *  
 */
