/*
 * $Header:   J:/devkit.dos/vcs/srcsmpl/wshout/src/resolve.c_v   1.2.1.0   26 Apr 1993 18:01:36   rcq  $
 */

/*
 * Filename: RESOLVE.C
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 10-Apr-90	daveb	Ported from jbvb's 2.04pl1 prod tctest\shout.c.
 * 21-May-90	jog and over to OS/2 without changing a thing; beauteous
 * 25-May-90	jog cleaned up a bit, print how much have written if get 
 *	    error when still writing
 * 13-Jun-90	jog made arg parsing if/else rather than switch/case, 
 *	    cleaned up some more..., prototype main() 
 * 14-Jun-90	jog AF_INET -> PF_INET
 * 06-Jun-90	jog added stdlib.h, string.h
 * 04-Feb-91	jog io.h, data_buffer hold ints, use BUF_SIZE, 
 *	    total_time is "double"
 * 20-Aug-91	gakio	Ported to Windows 3.0
 * 26-Mar-92	gakio	Modified to use Dialog Box as main window.
 * 26-May-92	gakio	Removed reference to <ioctl.h>. Handled by winsock.h.
 * 12-Jun-91	gakio	Modified to run on WinsockAPI.
 * 24-Aug-91	gakio	Make error announcement more explicit.
 * 03-Nov-92	gakio	prbuf's must be referred to as (LPSTR) in wsprintf
 * 25-Jan-92	gakio	Added port argument to ResolveAndConnectHost() & 
 *			 GetSocketAndBind().
 * 25-Apr-93	rcq	cleaned-up header, added MS Headers (that were in
 *			 WSHOUT.H) and added new error message handler.
 */

#include "wshout.h"

/* MSC Include files: */
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>


SOCKET 
ResolveAndConnectHost(LPSTR lpHostName,HWND hOurDlg,int iproto, int iSockPort)
{
    struct	hostent FAR *host_ptr;		/* Ptr to the host name	*/
    struct	sockaddr_in dest;		/* Addr of target host	*/
    SOCKET	hSock;				/* The socket to create */
    int iSockType;
    extern int iTCP;
    extern int iUDP;

    /* Internet family addressing */
    dest.sin_family = PF_INET;
    if (iproto == iTCP) {
	iSockType = SOCK_STREAM;
    }
    else if (iproto == iUDP) {
	iSockType = SOCK_DGRAM;
    }
    else {
	return (SOCKET) -1;		/* Unknown protocol */
    }
    
    /* default port to connect to. Must be in network byte order	*/
    dest.sin_port = htons((u_int) iSockPort);
    
    SetDlgItemText(hOurDlg, IDD_COMMENT,"Resolving hostname...");
    
    /* Resolve the host name */
    host_ptr = gethostbyname(lpHostName);
    if (host_ptr == NULL) {
	wshout_err (hOurDlg, WSAGetLastError(), "gethostbyname()");
	return (SOCKET) -1;
    }
    /* Patch host address into struct describing conn: */
    bcopy(host_ptr->h_addr,&dest.sin_addr,host_ptr->h_length);
    
    /* Allocate a network (socket) descriptor:	    */
    hSock = socket(PF_INET, iSockType, 0);
    if (hSock == INVALID_SOCKET) {
	wshout_err (hOurDlg, WSAGetLastError(), "socket()");
	return (SOCKET) -1;
    }
    
    /* Start connection process to host described in 'dest'	*
     * struct.	
     */
    SetDlgItemText(hOurDlg, IDD_COMMENT, "Connecting ...");
    ret=connect(hSock,(struct sockaddr FAR *)&dest,sizeof(dest));
    
    if (ret == SOCKET_ERROR) {
	wshout_err (hOurDlg, WSAGetLastError(), "connect()");
	closesocket(hSock);
	return (SOCKET) -1;
    }
    
    SetDlgItemText(hOurDlg, IDD_COMMENT, "...Connected");
    return hSock;
}


SOCKET GetSocketAndBind(HWND hOurDlg, int iProto, int iSockPort) 
{
    SOCKET hSock;			/* Connection socket descriptor	  */
    struct sockaddr_in local;		/* Local machine address structure*/
    int iSockType;
    extern int iTCP;
    extern int iUDP;
    
    /* Internet family addressing */
    if (iProto == iTCP) {
	iSockType = SOCK_STREAM;
    }
    else {
	iSockType = SOCK_DGRAM;
    }
    
    memset(&local, '\0', sizeof (local));
    local.sin_family = PF_INET;
    local.sin_port = htons((u_short)iSockPort);
    
    /* allocate a socket descriptor */
    hSock = socket(PF_INET, iSockType, 0); 
    if (hSock == INVALID_SOCKET) { /* socket() failed	*/
	wshout_err (hOurDlg, WSAGetLastError(), "socket()");
	return (SOCKET) -1;
    }
    
    /* bind socket to a local addr */
    ret = bind(hSock, (struct sockaddr FAR *) &local, sizeof(local));
    if (ret == SOCKET_ERROR){	    /* bind() failed	    */
	wshout_err (hOurDlg, WSAGetLastError(), "bind()");
	return (SOCKET) -1;
    }
    
    if (iProto == iUDP)
	return (hSock);
    
    /* If iProto == iTCP, then must listen() and accept() also */

    ret = listen(hSock, 0);	    /* listen on the socket */
    if (ret == SOCKET_ERROR){   /* listen() failed	    */
	wshout_err (hOurDlg, WSAGetLastError(), "listen()");
	return (SOCKET) -1;
    }
    
    return(hSock);
}

/* eof */
/*
 * $Log:   J:/devkit.dos/vcs/srcsmpl/wshout/src/resolve.c_v  $
 * 
 *    Rev 1.2.1.0   26 Apr 1993 18:01:36   rcq
 * added new error message display, updated headers, general cleaning
 * 
 *    Rev 1.2   28 Jan 1993 14:17:14   GAKIO
 * Modified port number to be user configurable.
 * 
 *    Rev 1.1   04 Nov 1992 14:34:20   GAKIO
 * refer to prbuf's as LPSTR in wsprintf.
 * 
 *    Rev 1.0   05 Oct 1992 17:05:12   GAKIO
 * Initial revision.
 * 
 *    Rev 1.1   08 Sep 1992 16:05:36   arnoff
 * gakio	Make error announcement more explicit.
 * 
 *    Rev 1.0   26 Aug 1992 12:39:10   arnoff
 *  
 */
