#include <windows.h>
#include <winsock.h>

/*
 * Filename: ERRNO.C
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 * 
 * Edit History:
 * 25-Apr-93	rcq	pulled WSAsperror function and error list (added
 *			 to WSHOUT.RC) from WinSockAPI ftp site microdyne.com
 *			 Added header.  Added the hInst parameter to make it 
 *			 more generic.
 */

/*
 * Function: WSAsperror()   
 *
 * Description:
 *
 * Copies string corresponding to the error code provided      
 * into buf, maximum length len. Returns length actually       
 * copied to buffer, or zero if error code is unknown.         
 * String resources should be present for each error code      
 * using the value of the code as the string ID (except for    
 * error = 0, which is mapped to WSABASEERR to keep it with    
 * the others). The DLL is free to use any string IDs that     
 * are less than WSABASEERR for its own use.
 *
 */
int PASCAL FAR WSAsperror (HANDLE hInst,    /* Instance Handle */
			   int errorcode,   /* WSA Error Number */
			   char far * buf,  /* Buffer for error string */
			   int len)         /* Length of buffer */
{
	int err_len;   /* length of error text */
    
        if (errorcode == 0)             /* If error passed is 0, use the */
                errorcode = WSABASEERR; /*  base resource file number */
        if (errorcode < WSABASEERR)     /* If invalid Error code */
                return 0;               /*  return string length of zero */
	    
	/* error string from the table in the Resource file into buffer */
        err_len = LoadString(hInst,errorcode,buf,len);
	
	return (err_len);  /* return length of error string retrieved */
	
}  /* end WSAsperror() */
