/*
 * $Header:   K:/21vcs/srccmd/samples.win/uechos.c_v   1.3   06 May 1992 16:06:44   arnoff  $
 */

/*
 * Copyright (C) 1991-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 05-Sep-90  msd@ayuda	Original author.
 * 04-Oct-90  msd@ayuda	First pre-release.
 * 01-Apr-91  msd@ayuda	To FTP for 2.05 pl 2 beta.
 * 06-May-92  ftp	DevKit 2.1 beta.
 */

/* "uechos.c" -- Simple test application for PC/TCP under Windows 3.x.
   Implements a UDP ECHO server. */

/* Disclaimer: FTP Software provides these sample Windows applications as 
   simple examples of how the PC/TCP PCTCPAPI.DLL can be used. We cannot 
   ensure that all coding conventions used herein are appropriate for all 
   Windows applications. Please consult an official Windows programming
   reference (i.e. Microsoft SDK) for recommended coding conventions which
   best suit your needs.
*/
   
#ifdef	OTHER
#define PAINTOTHER	PaintOther
#define POLLOTHER	PollOther
#endif
#define ASYNCH
  
#include <stdio.h>
#include <dos.h>
#include <memory.h>

/* The following #defines prune the symbol table! */
#define	NORASTEROPS
#define NOSOUND
#define NOCOMM
#define NOKANJI

#include <windows.h>
#include <pctcp/winapp.h>
#include <pctcp/asynch.h>
#include "cgarf.h"
#include "fmters.h"
#include "plaints.h"
#include "uechos.h"

#ifndef	OURPORT
#define	OURPORT		7	/* std ECHO service port # */
#endif


/* local function prototypes */

int InitNet(HWND);
void PaintLine(char *, HDC, TEXTMETRIC *, int *, int *);
void PaintWnd(HWND);
int ParseCmdLine(LPSTR);
int Process1Datagram();


/* global / local variables */

HANDLE hInst;			/* current instance */
HWND hOurWnd = NULL;		/* handle for our root window */

in_name ipAddr;			/* net descriptor's IP address */
int lstMsgLen;			/* length of last dg */
struct addr msgAddr;		/* (usually) address of last peer */
char *msgBufP;			/* buffer for a datagram */
int msgLen = 1024;		/* max length of things to echo */
int nd = -1;			/* datagram net descriptor */
unsigned netVsn;		/* PC/TCP version # */
char prbuf[256];		/* message assembly buffer */
int readNow;			/* Boolean tells main loop to read */
unsigned long recvCounter;	/* # of datagrams received */
unsigned long retryCounter;	/* # of unsuccessful tries to send last dg */
unsigned long sendCounter;	/* # of datagrams send back */
unsigned long sendErrors;	/* # of datagrams not sent due to errors */
unsigned timeout = 30000;	/* # of milliseconds per timeout */
unsigned udpPort = OURPORT;	/* service port number */


/* function bodies */

int PASCAL
WinMain (hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
	MSG msg;

	if (!hPrevInstance)
		if (!InitApplication(hInstance))
			return FALSE;

	if (!InitInstance(hInstance, lpCmdLine, nCmdShow))
		return FALSE;

	/* Message sending is done here and here alone.  Ensures that it is
	   only within the context of the application main loop and not in
	   the MainWndProc (which can be invoked directly, causing *deep*
	   stack nesting explosions). 
	*/
	
#ifdef	ASYNCH
	/* Normal message loop here.  The MainWndProc gets asynch messages
	   and pokes from the timer to try reading datagrams and notes such
	   in 'readNow' (global variable).  Here, we try to read a message. 
	   'readNow' is cleared whenever all inbound data has been consumed. 
	*/

	while (GetMessage(&msg, NULL, NULL, NULL)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		if (readNow)
			Process1Datagram();
	}
#else
	/* Modified main message loop here polls for inbound datagrams
	   vigorously, without asynchronous notification messages.  This is 
	   purely to demonstrate the ability to do so -- it is NOT the 
	   recommended implementation methodology.
	*/
	do {
		Process1Datagram();
		Yield();
		if (!PeekMessage(&msg, NULL, NULL, NULL, PM_REMOVE|PM_NOYIELD))
			continue;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	} while (msg.message != WM_QUIT);
#endif
	return msg.wParam;
}

BOOL
InitApplication (hInstance)
HANDLE hInstance;
{
	WNDCLASS wc;

	wc.style = NULL;
	wc.lpfnWndProc = MainWndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName = "UECHOSMenu";
	wc.lpszClassName = "UECHOSWClass";

	return RegisterClass(&wc);

}

BOOL
InitInstance (hInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
	HWND hWnd;		/* main window */
	char prbuf[128];

	hInst = hInstance;

	hWnd = CreateWindow("UECHOSWClass", "UDP ECHO Server"
	  , WS_OVERLAPPEDWINDOW
	  , CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT
	  , NULL, NULL, hInstance, NULL);

	if (!hWnd)
		return FALSE;

	hOurWnd = hWnd;			/* export for global use */
	if (!ParseCmdLine(lpCmdLine)	/* parse the command line */
	  ||  InitNet(hWnd) < 0) {
		PostQuitMessage(0);
		return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);	/* sends WM_PAINT message */
	return TRUE;
}

long FAR PASCAL
MainWndProc (hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{
	FARPROC lpProcAbout;
	int i;

	switch (message) {
        case WM_COMMAND:    /* message: command from application menu */
		if (wParam == IDM_ABOUT) {
			lpProcAbout = MakeProcInstance(About, hInst);
			DialogBox(hInst, "UECHOSAboutBox", hWnd, lpProcAbout);
			FreeProcInstance(lpProcAbout);
			break;
		} else
			return DefWindowProc(hWnd, message, wParam, lParam);
	case WM_DESTROY:
		/* Terminate access to PCTCPAPI.DLL. */
		net_taskDestroy();
		nd = -1;
		PostQuitMessage(0);
		break;
	case WM_PAINT:
		PaintWnd(hWnd);
		break;
	case WM_TIMER:
		/* Force main loop to try reading.  This forestalls hanging
		   indefinitely on a lost asynch (highly unlikely).
		*/
		readNow = 1;
		/* Force a full repaint. */
		InvalidateRect(hWnd, NULL, TRUE);
		break;
	/* specials in this application */
	case UECHOSM_POLL:

#ifdef	POLLOTHER
		POLLOTHER(hWnd, message, wParam, lParam);
#endif
		/* Force a full repaint. */
		InvalidateRect(hWnd, NULL, TRUE);
		break;
	default:
		/* See if this is an asynch notice from PC/TCP. */
		if (message == net_msgType) {
			/* Expect one per DG. */
			readNow = 1;	/* tell main loop to read */
			break;
		}
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return NULL;
}

BOOL FAR PASCAL
About (hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
	switch (message) {
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:		/* message: received a command */
		if (wParam == IDOK	      /* "OK" box selected? */
		   ||  wParam == IDCANCEL) {  /* System menu close command? */
			/* Tell our WinProc to poll 'things'. */
			PostMessage(hOurWnd, UECHOSM_POLL, 0, 0L);
			EndDialog(hDlg, TRUE);
			return TRUE;
		}
		break;
	}
	return FALSE;		/* Didn't process a message. */
}

int
InitNet (hWnd)
HWND hWnd;
{
	char *errP;

	if (!(msgBufP = my_calloc(msgLen)))
		return otherPlaint("Unable to allocate buffer.", 0);
	/* Initialize access to PCTCPAPI.DLL. */
	if (net_taskInit("uechos") == -1)
		return perrorTypePlaint("net_taskInit", 0);

	/* Get the PC/TCP version. */
	netVsn = (unsigned) get_netversion();
	/* Get a network descriptor. */
	if ((nd = net_getdesc()) == -1) {
		errP = "net_getdesc";
		goto plaintDeregNQuit;
	}
#ifdef	ASYNCH
	/* Register for asynchronous delivery of data arrival notification. */
	if (net_asynchw(nd, NET_AS_RCV, hWnd, NET_ASWM_POST) == -1L) {
		errP = "net_asynchw";
		goto plaintDeregNQuit;
	}
#endif
	/* Listen on the datagram echo socket. */
	msgAddr.lsocket = udpPort;
	msgAddr.protocol = DGRAM;
	if (net_listen(nd, DGRAM, &msgAddr) == -1) {
		errP = "net_listen";
		goto plaintDeregNQuit;
	}
	/* Get our IP address. */
	if ((ipAddr = get_addr(nd)) == 0L) {
		errP = "get_addr";
		goto plaintDeregNQuit;
	}
	/* Register for a Windows timer at periodic intervals. */
	if (timeout  &&  SetTimer(hWnd, 0, timeout, (FARPROC) 0) == NULL) {
		otherPlaint("SetTimer failed", 0);
		goto deregNQuit;
	}
	return 0;

	/* Complain, deregister with PCTCPAPI.DLL and quit. */
plaintDeregNQuit:;
	perrorTypePlaint(errP, 0);
deregNQuit:;
	net_taskDestroy();
	return -1;
}

int
ParseCmdLine (lpCmdLine)
LPSTR lpCmdLine;
{
	register char c;
	char *errP;
	LPSTR fcP;
	auto LPSTR afcP;

	/* Parse the command line.  Look for "/P<portNo>" and/or "/L<msgLen>"
	   and/or "/T<timeout>" options. */
	for (fcP = lpCmdLine; c = *fcP; ++fcP) {
		switch (c) {
		case '/':	/* option delimiter -- MS-DOS style */
			switch (*++fcP) {
			case 'p':  case 'P':	/* UDP service port number */
				afcP = ++fcP;
				udpPort = (unsigned) wstrtol(fcP, &afcP, 10);
				if (afcP == fcP)
					goto usage_err_out;
				fcP = afcP - 1;	/* at end of number parsed */
				break;
			case 'l':  case 'L':	/* datagram size */
				afcP = ++fcP;
				msgLen = (unsigned) wstrtol(fcP, &afcP, 10);
				if (afcP == fcP)
					goto usage_err_out;
				fcP = afcP - 1;	/* at end of number parsed */
				break;
			case 't':  case 'T':	/* refresh timeout */
				afcP = ++fcP;
				timeout = (unsigned) wstrtol(fcP, &afcP, 10);
				if (afcP == fcP)
					goto usage_err_out;
				fcP = afcP - 1;	/* at end of number parsed */
				break;
			default:
				goto usage_err_out;
			}
			break;
		}
	}
	return TRUE;

usage_err_out:;
	errP = "Invalid command line: options are /P<portNo> /L<msgLen> /T<refresh>";
	otherPlaint(errP, 0);
	return FALSE;
}

int
Process1Datagram () {
	int n;

	if (nd == -1)
		return 0;
	if ((n = net_read(nd, msgBufP, msgLen, &msgAddr, 0)) == -1) {
		if (net_errno == NET_ERR_WOULD_BLOCK)
			readNow = 0;
		else
			perrorTypePlaint("net_read", 1);
		return 0;	/* try again later */
	}
	++recvCounter;
	lstMsgLen = n;
	if ((n = net_writeto(nd, msgBufP, lstMsgLen, &msgAddr, 0))
	  != lstMsgLen) {
		++sendErrors;
		if (n >= 0) {
			sprintf(prbuf, "net_writeto length mismatch %u vs %u", n
			  , lstMsgLen);
			otherPlaint(prbuf, 1);
		} else if (net_errno != NET_ERR_NOMEM)
			/* don't complain on NOMEM, just count 'em */
			perrorTypePlaint("net_writeto", 1);
		return 0;	/* try again later */
	}
	++sendCounter;
	return 1;	/* try another, if you dare! */
}

void
PaintLine (txtP, hDC, tmP, nDrawXP, nDrawYP)
char *txtP;
HDC hDC;
TEXTMETRIC *tmP;
int *nDrawXP, *nDrawYP;
{
	unsigned len = strlen(txtP);

	/* Send characters to the screen.  After displaying each line of
	   text, advance the vertical position for the next line of text.
	   The pixel distance between the top of each line of text is equal
	   to the standard height of the font characters (tmHeight), plus
	   the standard amount of spacing (tmExternalLeading) between
	   adjacent lines. 
	*/
	TextOut(hDC, *nDrawXP, *nDrawYP, txtP, len);
	*nDrawYP += tmP->tmExternalLeading + tmP->tmHeight;
}

void
PaintWnd (hWnd)
HWND hWnd;
{
	HDC hDC;
	PAINTSTRUCT ps;
	TEXTMETRIC textmetric;
	int nDrawX, nDrawY;

	hDC = BeginPaint(hWnd, &ps);
	/* Get the size characteristics of the current font.
	   This information will be used for determining the
	   vertical spacing of text on the screen. */
        GetTextMetrics (hDC, &textmetric);
	/* Initialize drawing position to 1/4 inch from the
	   top and from the left of the top, left corner of
	   the client area of the main windows. */
	nDrawX = GetDeviceCaps (hDC, LOGPIXELSX) / 4;
	nDrawY = GetDeviceCaps (hDC, LOGPIXELSY) / 4;

	/* paint out basic app stuff */
	sprintf(prbuf
	  , "PC/TCP Version %u.%02u IP %s port %d -- task %x%s"
	  , netVsn / 256, netVsn % 256, pr_in_name(ipAddr), udpPort
	  , net_dope.netd_hTask
#ifdef	ASYNCH
	  , "");
#else
	  , " **SYNCHRONOUS**");
#endif
	PaintLine(prbuf, hDC, &textmetric, &nDrawX, &nDrawY);

	sprintf(prbuf, "#recvs %lu -- #sends %lu -- #sendErrors %lu"
	  , recvCounter, sendCounter, sendErrors);
	PaintLine(prbuf, hDC, &textmetric, &nDrawX, &nDrawY);

	sprintf(prbuf, "Last was from %s,%u  %u bytes sent w/ %lu retries"
	  , pr_in_name(msgAddr.fhost), msgAddr.fsocket, lstMsgLen
	  , retryCounter);
	PaintLine(prbuf, hDC, &textmetric, &nDrawX, &nDrawY);

#ifdef	PAINTOTHER
	PAINTOTHER(hDC, &textmetric, &nDrawX, &nDrawY);
#endif

	EndPaint(hWnd, &ps);
}

/* eof */

/*
 * $Log:   K:/21vcs/srccmd/samples.win/uechos.c_v  $
 * 
 *    Rev 1.3   06 May 1992 16:06:44   arnoff
 *  * 06-May-92  ftp	DevKit 2.1 beta.
 * 
 *    Rev 1.2   03 Feb 1992 22:01:50   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.1   29 Jan 1992 22:48:26   arnoff
 *  
 */
