/*
 * $Header:   J:/22VCS/SRCCMD/SAMPLES.WIN/DLL/UECHOSDL.C_V   1.2   07 Oct 1992 13:42:52   rcq  $
 */

/*
 * Copyright (C) 1991 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 01-Apr-91  msd@ayuda	To FTP for 2.05 pl 2 beta.
 * 27-Sep-91  msd@ayuda	Improvements to demonstrate use of 'hint's in
 *			asynchronous delivery mechanisms.
 * 04-May-92  kek@ftp	Remove net_taskDestroy() call from WEP().
 * 23-Jul-92  rcq@ftp   change fmters.h and plaints.h header reference
 *			to refer to subdirectory on level up.
 */

/* "uechosdl.c" -- DLL portion of simple test application to exercise
   use of PC/TCP under Windows 3.0 from a user-written DLL.
   Implements a UDP ECHO server. */

/* Disclaimer: this program ISN'T intended to show how to write great
   Windows applications.  Rather, it's to demonstrate how a WinApp
   (or in this case a DLL) might use PC/TCP. */

/*#define PAINTOTHER	PaintOther*/
/*#define POLLOTHER	PollOther*/
  
#include <stdio.h>
#include <dos.h>
#include <memory.h>
	/* do some pruning on the !@#$#% symbol table here! */
#define	NORASTEROPS
#define NOSOUND
#define NOCOMM
#define NOKANJI
#include <windows.h>
#define NET_HTASK		/* force PC/TCP DLL to generate fake hTask */
#include <pctcp/winapp.h>
#include <pctcp/asynch.h>
#include "..\fmters.h"
#include "..\plaints.h"
#define	UECHOSDL_PRIVATE	/* want our private decls / defns too */
#include "uechosdl.h"

#define	ALARM_HINT	0xDAD00D2   /* semi-meaningless illegal selectors */
#define	ASYNCH_HINT	0xFEEDFACE  /*  with perhaps subliminal overtones? */


HWND hOurWnd;			/* static window handle (registered caller's) */

unsigned alarmQuota;		/* # of datagrams to allow during alarm */
unsigned asyncQuota;		/* # of datagrams to allow between alarms */
char errBuf[128];		/* buffer for upcall error */
in_name ipAddr;			/* net descriptor's IP address */
int lstMsgLen;			/* length of last dg */
struct addr msgAddr;		/* (usually) address of last peer */
unsigned msgQuota;		/* # of datagrams left this alarm */
char msgBuf[2048];		/* buffer for a datagram */
int nd = -1;			/* datagram net descriptor */
unsigned netVsn;		/* PC/TCP version # */
char prbuf[256];		/* message assembly buffer */
unsigned long quotaOver = -1L;	/* # of times we went deaf */
unsigned long quotaUnder;	/* # of times we didn't go deaf */
unsigned long recvCounter;	/* # of datagrams received */
unsigned long retryCounter;	/* # of unsuccessful tries to send last dg */
unsigned long sendCounter;	/* # of datagrams send back */
unsigned long sendErrors;	/* # of datagrams not sent due to errors */
unsigned udpPort;		/* port # listening on */

static int DLLRefCount = 0;	/* Count how many apps are using this DLL */

int InitNet(unsigned);
int Process1Datagram();
 PaintLine(char FAR *, HDC, LPTEXTMETRIC, int FAR *, int FAR *);
 PaintWnd(HWND);


int FAR PASCAL
LibMain (hInstance, wDataSeg, cbHeapSize, lpCmdLine)
HANDLE hInstance;
WORD wDataSeg, cbHeapSize;
LPSTR lpCmdLine;
{
	/* DATA segment isn't movable because this DLL gets invoked in
	   the PC/TCP DLL upcall context -- therefore, don't unlock it. */

	/* Register with PC/TCP DLL. Done only once because this DLL
	   has a single 'net_dope' context.  (If it were trying to handle
	   multiple client Apps, with each being known by the PC/TCP DLL,
	   it would have to do this each time on behalf of each App. */

	if (DLLRefCount == 0)
	   if (net_taskInit("uechosdl") == -1)
		return 0;	/* couldn't get to first base */
	DLLRefCount++;

	/* Nothing else spectacular gets done here.  Life begins when the
	   client WinApp calls our 'uechod_init' entrypoint. */
	return 1;
}

/* Function to process an inbound 'net_alarm' upcall, serving as the
   periodic retry timer (in case a 'net_asynch' upcall gets lost). */
int FAR
ProcessAlarm (nd, event, arg, hint)
int nd, event;
unsigned long arg;	/* just garbage for NET_AS_ALARM */
unsigned long hint;
{
	unsigned on = msgQuota;
	int errno_save;

	/* Preserve error codes of foreground call we may be interrupting. */
	errno_save = net_errno;
	/* Sanity check of hint value. */
	if (hint != ALARM_HINT)
		wsprintf(errBuf
		  , "net_alarm delivered hint 0x%lx instead of 0x%lx"
		  , hint, ALARM_HINT);
	/* Don't stay in here forever! */
	for (msgQuota = alarmQuota; msgQuota  &&  Process1Datagram()
	  ; --msgQuota)
		/*empty*/;
	/* Re-register for periodic alarm. */
	if (net_alarm(nd, 110L, _alarm_handler, ALARM_HINT) == -1)
		wsprintf(errBuf, "net_alarm reregistration error @ %lu: %s%s"
		  , recvCounter, (LPSTR) pr_errno()
		  , (LPSTR) pr_suberrno());
	msgQuota += asyncQuota;
	if (on)
		++quotaUnder;
	else {
		++quotaOver;
		/* Reregister for asynchronous delivery of data arrival
		   notification. */
		if (net_asynch(nd, NET_AS_RCV, _asynch_handler, ASYNCH_HINT)
		  == (FpfiT) -1L)
			wsprintf(errBuf
			  , "net_asynch reregistration error @ %lu: %s%s"
			  , recvCounter, (LPSTR) pr_errno()
			  , (LPSTR) pr_suberrno());
	}
	/* Restore error codes. */
	net_errno = errno_save;
	return 0;
}

/* Function to process an inbound 'net_asynch' upcall, indicating that
   there is a datagram to read. */
int FAR
ProcessAsync (nd, event, arg, hint)
int nd, event;
unsigned long FAR *arg;
unsigned long hint;
{
	int errno_save;

	/* Preserve error codes of foreground call we may be interrupting. */
	errno_save = net_errno;
	/* Sanity check of hint value. */
	if (hint != ASYNCH_HINT)
		wsprintf(errBuf
		  , "net_asynch delivered hint 0x%lx instead of 0x%lx"
		  , hint, ASYNCH_HINT);
	if (msgQuota  &&  Process1Datagram()  &&  --msgQuota == 0)
		/* De-register arrival handler -- timer will turn back on. */
		(void) net_asynch(nd, NET_AS_RCV, (FpfiT) 0, 0L);
	/* Restore error codes. */
	net_errno = errno_save;
	return 0;
}

/* Entrypoint from client to destroy the access this DLL has.  Destroys
   the datagram net descriptor. */
int FAR
uechod_destroy (hWnd)
HWND hWnd;
{
	int n;

	if (hWnd != hOurWnd)
		return -1;	/* wrong caller! */
	if (nd == -1)
		return otherPlaint("uechod_paint: not initialized", 0);
	hOurWnd = 0;
	(void) net_abort((n = nd, nd = -1, n));
	if (--DLLRefCount == 0)
		net_taskDestroy();
		
	return 0;
}

/* Entrypoint of client to initialize his/her/its access.  Creates the
   datagram net descriptor, arranges for NET_AS_RCV and a periodic alarm
   via real upcalls. */
int FAR
uechod_init (hWnd, portNo, quota)
HWND hWnd;
unsigned portNo, quota;
{
	hOurWnd = hWnd;		/* so we can use the complaint library */
	if (nd != -1)
		return otherPlaint("uechod_init: reentered", 0);

	/* Calculate quotas for the alarm handler loop and between
	   alarms.  Allow up to four datagrams during the alarm.
	   Divide the rest up evenly. */
	quota = max(quota, 1);
	alarmQuota = min(quota, 4);
	quota -= alarmQuota;
	asyncQuota = (quota + 8) / 9;

	return InitNet(portNo);
}

/* Entrypoint of client to cause the status of the DLL to be dumped to
   the client's root window. */
int FAR
uechod_paint (hWnd)
HWND hWnd;
{
	if (!hOurWnd)
		return 0;
	if (hWnd != hOurWnd)
		return -1;	/* wrong caller! */
	if (nd == -1)
		return otherPlaint("uechod_paint: not initialized", 0);
	PaintWnd(hWnd);
	return 0;
}

/* The special Windows exit procedure.  Called just as the DLL is about to
   be unloaded.  The highly-documentative name of this procedure is a
   Microsoft original. */
VOID FAR PASCAL				/* Get a load of all the CAPS! */
WEP (nParameter)
int nParameter;
{
	switch (nParameter) {
	case WEP_SYSTEM_EXIT:	/* Windows itself is dying. */
	case WEP_FREE_DLL:	/* Last application through with this DLL. */
	default:		/* Windows is having a cosmic experience? */
		return;		/* don't do anything to blow the karma */
	}
}

/* Initialized network descriptor access. */
int
InitNet (portNo)
unsigned portNo;
{
	/* Get the PC/TCP version. */
	netVsn = (unsigned) get_netversion();
	/* Get a network descriptor. */
	if ((nd = net_getdesc()) == -1)
		return perrorTypePlaint("net_getdesc", 0);
	/* Listen on the datagram echo socket. */
	msgAddr.lsocket = udpPort = portNo;
	msgAddr.protocol = DGRAM;
	if (net_listen(nd, DGRAM, &msgAddr) == -1)
		return perrorTypePlaint("net_listen", 0);
	/* Get our IP address. */
	if ((ipAddr = get_addr(nd)) == 0L)
		return perrorTypePlaint("get_addr", 0);
	/* Register for the first alarm. */
	if (net_alarm(nd, 1L, _alarm_handler, ALARM_HINT) == -1)
		return perrorTypePlaint("net_alarm", 0);
	return 0;
}

/* Process a single datagram, and echo it back at the sender. */
int
Process1Datagram () {
	int n;

	if (nd == -1  ||  errBuf[0])
		return 0;
	if ((n = net_read(nd, msgBuf, sizeof msgBuf, &msgAddr, 0)) == -1) {
		if (net_errno != NET_ERR_WOULD_BLOCK)
			wsprintf(errBuf, "net_read error @ %lu: %s%s"
			  , recvCounter, (LPSTR) pr_errno()
			  , (LPSTR) pr_suberrno());
		return 0;	/* try again later */
	}
	++recvCounter;
	lstMsgLen = n;
	if ((n = net_writeto(nd, msgBuf, lstMsgLen, &msgAddr, 0))
	  != lstMsgLen) {
		++sendErrors;
		if (n >= 0) {
			wsprintf(errBuf
			  , "net_writeto length mismatch %u vs %u @ %lu"
			  , n, lstMsgLen, sendCounter);
		} else if (net_errno != NET_ERR_NOMEM)
			/* don't complain on NOMEM, just count 'em */
			wsprintf(errBuf, "net_writeto error @ %lu: %s%s"
			  , sendCounter, (LPSTR) pr_errno()
			  , (LPSTR) pr_suberrno());
		return 0;	/* try again later */
	}
	++sendCounter;
	return 1;	/* try another, if you dare! */
}

/* Note: this DLL paints to the calling App's window. */
PaintLine (txtP, hDC, tmP, nDrawXP, nDrawYP)
char FAR *txtP;
HDC hDC;
LPTEXTMETRIC tmP;
int FAR *nDrawXP, FAR *nDrawYP;
{
	unsigned len = strlen(txtP);

	/* Send characters to the screen.  After displaying each line of
	   text, advance the vertical position for the next line of text.
	   The pixel distance between the top of each line of text is equal
	   to the standard height of the font characters (tmHeight), plus
	   the standard amount of spacing (tmExternalLeading) between
	   adjacent lines. */
	TextOut(hDC, *nDrawXP, *nDrawYP, txtP, len);
	*nDrawYP += tmP->tmExternalLeading + tmP->tmHeight;
}

PaintWnd (hWnd)
HWND hWnd;
{
	HDC hDC;
	auto int nDrawX, nDrawY;
	auto PAINTSTRUCT ps;
	auto TEXTMETRIC textmetric;

	hDC = BeginPaint(hWnd, &ps);
	/* Get the size characteristics of the current font.
	   This information will be used for determining the
	   vertical spacing of text on the screen. */
        GetTextMetrics (hDC, &textmetric);
	/* Initialize drawing position to 1/4 inch from the
	   top and from the left of the top, left corner of
	   the client area of the main windows. */
	nDrawX = GetDeviceCaps (hDC, LOGPIXELSX) / 4;
	nDrawY = GetDeviceCaps (hDC, LOGPIXELSY) / 4;

	/* paint out basic app stuff */
	wsprintf(prbuf
	  , "PC/TCP Version %u.%02u IP %s port %d -- task %x"
	  , netVsn / 256, netVsn % 256, (LPSTR) pr_in_name(ipAddr), udpPort
	  , net_dope.netd_hTask);
	PaintLine(prbuf, hDC, &textmetric, &nDrawX, &nDrawY);

	wsprintf(prbuf, "#recvs %lu -- #sends %lu -- #sendErrors %lu"
	  , recvCounter, sendCounter, sendErrors);
	PaintLine(prbuf, hDC, &textmetric, &nDrawX, &nDrawY);

	wsprintf(prbuf, "Last was from %s,%u  %u bytes sent w/ %lu retries"
	  , (LPSTR) pr_in_name(msgAddr.fhost), msgAddr.fsocket, lstMsgLen
	  , retryCounter);
	PaintLine(prbuf, hDC, &textmetric, &nDrawX, &nDrawY);

	wsprintf(prbuf
	  , "quota %u pkts/sec -- #quotaOverruns %lu -- #quotaUnderruns %lu"
	  , alarmQuota + 9*asyncQuota, quotaOver == -1L ? 0L : quotaOver
	  , quotaUnder);
	PaintLine(prbuf, hDC, &textmetric, &nDrawX, &nDrawY);

	if (errBuf[0]) {
		wsprintf(prbuf, " **ERROR** %s", (LPSTR) errBuf);
		PaintLine(prbuf, hDC, &textmetric, &nDrawX, &nDrawY);
		errBuf[0] = 0;		/* re-arm the receiver */
	}

#ifdef	PAINTOTHER
	PAINTOTHER(hDC, &textmetric, &nDrawX, &nDrawY);
#endif

	EndPaint(hWnd, &ps);
}

/* eof */

/*
 * $Log:   J:/22VCS/SRCCMD/SAMPLES.WIN/DLL/UECHOSDL.C_V  $
 * 
 *    Rev 1.2   07 Oct 1992 13:42:52   rcq
 * changed fmters.h and pplaint.h path to ..\
 * 
 *    Rev 1.0   26 Aug 1992 21:25:36   arnoff
 * Initial revision.
 * 
 *    Rev 1.1   05 May 1992 11:55:02   arnoff
 *  * 04-May-92  kek@ftp	Remove net_taskDestroy() call from WEP().
 */
