;
; Copyright (C) 1991 by FTP Software, Inc.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; 
; EDIT HISTORY:
; 01-Apr-91  msd@ayuda	To FTP for 2.05 pl 2 beta.
; 27-Sep-91  msd@ayuda	Better decoding of upcall arguments -- yo Mark!
;

; "dllglue.asm" -- Glue routines for interfacing upcalls from the
; PC/TCP Windows DLL to our DLL.  Such routines are needed to
; establish segment registers.

		; Yes boys and girls -- finally protected-mode code!
	.286p
	extrn	_ProcessAlarm: far
	extrn	_ProcessAsync: far

_TEXT	segment byte public 'CODE'
_TEXT	ends
_DATA	segment word public 'DATA'
_DATA	ends
CONST	segment word public 'CONST'
CONST	ends
_BSS	segment word public 'BSS'
_BSS	ends

DGROUP	group _DATA, CONST, _BSS

	assume cs:_TEXT, ds:DGROUP, ss:NOTHING, es:NOTHING

_TEXT	segment

; Upcall from the DLL to dispatch to the C routine for handling
; 'net_alarm' notification:  Assembly language FAR calls us here
; with:
; 	bx	nd
;	cx	event
;	ds:dx	arg (pointer thereto in PM)
;	es:di	hint (pointer thereto in PM)
; Establishes the data segment selector in DS, then pushes arguments on
; the stack and makes the C-style FAR call:
;	int ProcessAlarm(nd, event, arg, hint)
; Note that the 'arg' and 'hint' pointers are unraveled to look like they
; do in the non-PM case using FTP's 'asynch_stub' helper function.
; Nothing is expected to be returned by 'ProcessAlarm'.
;
; It is called on the PC/TCP DLL's upcall stack.
	public	__alarm_handler
	assume cs:_TEXT, ds:NOTHING, ss:NOTHING, es:NOTHING
__alarm_handler		proc	far
;;;;	int 3			; Danger, Will Robinson!
	push	bp		; C linkage -- make backtraces readable
	mov	bp, sp
	push	es:[di+2]	; arg4: hint (deref the PM pointer 
	push	es:[di]		;  and push the value here)
	mov	si, dx		; arg3: arg (deref the PM pointer
	push	ds:[si+2]	;  and push the value here)
	push	ds:[si]
	push	cx		; arg2: event
	push	bx		; arg1: nd
	mov	bx, SEG DGROUP	; load up the DS register for our
	mov	ds, bx		;  small-minded program
	call	_ProcessAlarm
	assume	ds:NOTHING
	mov	sp, bp		; clean-up -- don't worry about restoring
				;  any squashed registers because the						;  PC/TCP DLL can take it
	pop	bp		; undo C linkage
	ret
__alarm_handler		endp


; Upcall from the DLL to dispatch to the C routine for handling
; 'net_asynch' notification:  Assembly language FAR calls us here
; with:
; 	bx	nd
;	cx	event
;	ds:dx	arg (pointer thereto in PM)
;	es:di	hint (pointer thereto in PM)
; Establishes the data segment selector in DS, then pushes arguments on
; the stack and makes the C-style FAR call:
;	int ProcessAsync(nd, event, arg, hint)
; Note that the 'arg' and 'hint' pointers are unraveled to look like they
; do in the non-PM case using FTP's 'asynch_stub' helper function.
; Nothing is expected to be returned by 'ProcessAsync'.
;
; It is called on the PC/TCP DLL's upcall stack.
	public	__asynch_handler
	assume cs:_TEXT, ds:NOTHING, ss:NOTHING, es:NOTHING
__asynch_handler	proc	far
;;;;	int 3			; Danger, Will Robinson!
	push	bp		; C linkage -- make backtraces readable
	mov	bp, sp
	push	es:[di+2]	; arg4: hint (deref the PM pointer 
	push	es:[di]		;  and push the value here)
	mov	si, dx		; arg3: arg (deref the PM pointer
	push	ds:[si+2]	;  and push the value here)
	push	ds:[si]
	push	cx		; arg2: event
	push	bx		; arg1: nd
	mov	bx, SEG DGROUP	; load up the DS register for our
	mov	ds, bx		;  small-minded program
	call	_ProcessAsync
	assume	ds:NOTHING
	mov	sp, bp		; clean-up -- don't worry about restoring
				;  any squashed registers because the						;  PC/TCP DLL can take it
	pop	bp		; undo C linkage
	ret
__asynch_handler	endp


_TEXT	ends
	end

; eof
