
/*
 * src\trans\set_win.c
 *
 * Copyright (C) 1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 21-Jun-92	Ben	Created this file.
 * 21-jul-92	rcq	changed <rwconf.h> to <pctcp/rwconf.h> and
 *			added some printf()'s to display to user
 *			added config_close()
 * 20-aug-92    rcq     renamed from sample.c to setwin.c to match docs
 * 11-sep-92    rcq     renamed from setwin.c to set_win.c to *really*
 *			match docs
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pctcp/types.h>

#include <pctcp/rwconf.h>

/* Prototypes */
get_windows (int *windows_ptr, int *low_window_ptr);
set_windows (int windows, int low_window);

main ()
{
    int	window_ptr, low_window_ptr;

    get_windows (&window_ptr, &low_window_ptr);
    set_windows (window_ptr, low_window_ptr);

}  /* end of main() */


get_windows (int *window_ptr, int *low_window_ptr)
{
    char	buffer[512];

    if (config_open (NULL, 0) == FALSE)
    {
	pconferror ("Couldn't open ini file");
	return (FALSE);
    }
    else
	printf("\nPCTCP initialization file opened successfully.");
    
    if (config_seek ("pctcp", "kernel", NULL, 0) == FALSE)
    {
	pconferror ("Couldn't find [pctcp kernel]");
	return (FALSE);
    }
    else
	printf("\nFound [pctcp kernel] section in ini file.");

    if (config_read ("window", CONF_ANY_INSTANCE, buffer, sizeof(buffer),0) &&
	strlen (buffer))
	*window_ptr = atoi (buffer);
    else 
	*window_ptr = 1024;
    
    if (config_read ("low-window", CONF_ANY_INSTANCE, buffer, sizeof(buffer),0) &&
	strlen (buffer)) {
	*low_window_ptr = atoi (buffer);
	printf ("\nFound 'low-window' setting: %d bytes.", *low_window_ptr);   
    }
    else {
	*low_window_ptr = *window_ptr/2;
	printf ("\nlow-window setting NOT found, defaulting to %d bytes.",
	    *low_window_ptr);
    }
    
    if (config_close(0) == FALSE)
    {
	pconferror ("Couldn't close PCTCP initialization file");
	return(FALSE);
    }
    else
	printf ("\nPCTCP initialization file closed successfully.");
	
    return (TRUE);
} /* end of get_windows() */


set_windows (int window, int low_window)
{
    char	buffer[512];

    itoa (window, buffer, 10);
    if (config_write (NULL, "kernel", NULL, "window", buffer, 0) == FALSE)
    {
	pconferror ("Couldn't write [pctcp kernel] - window");
	return (FALSE);
    }
    else
	printf ("\nwrote %s to window setting in [pctcp kernel] section",
	    buffer);

    itoa (low_window, buffer, 10);
    if (config_write (NULL, "kernel", NULL, "low_window", buffer, 0) == FALSE)
    {
	pconferror ("Couldn't write [pctcp kernel] - low_window");
	return (FALSE);
    }
    else
	printf ("\nwrote %s to low-window setting in [pctcp kernel] section",
	    buffer);

    if (config_flush (NULL, "", 0) == 0)
    {
	pconferror ("Couldn't save changes to PCTCP.INI file");
	return (FALSE);
    }
    else
	printf ("\n ---Changes now saved to PCTCP initialization file---\n");

    return (TRUE);
} /* end of set_windows() */



