/*
 * $Header:   J:/22vcs/srclib/socket/syslog.c_v   1.3   02 Oct 1992 18:59:24   rcq  $
 */

/*
 * SYSLOG.C - lightweight unix style syslog
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 	edit history:
 * 		MAY88	stev	wrote openlog() and syslog().
 * 		SEP89	stev	added setlogmask(), 4.3ize.
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 25-Feb-92	paul	fixed instances of ( *string++; ) in syslog()
 *			changed syslog decl to match 4bsddefs.h and our doc
 * 14-Aug-92    rcq     updated the copyright in comments
 */

#include <pctcp/error.h>		/* error return codes (syslog()	*/
#include <pctcp/types.h>		/* ushort and such		*/
#include <syslog.h>			/* #defines for LOG_*		*/
#include <io.h>				/* file i/o prototypes		*/
#include <stdio.h>			/* std prototypes		*/
#include <stdarg.h>			/* for the varargs in syslog()	*/
#include <stdlib.h>			/* more function prototypes	*/
#include <time.h>			/* time structures		*/

FILE 	*syslogOut = NULL;		/* output file			*/
int	logLevel = LOG_NOTHING,		/* maxium level to log		*/
	logOptions = 0;			/* printing options		*/

void
openlog (char *ident, int logopt, int facility)
/* ident	string to prefix to message	*/
/* logopt	printing options		*/
/* facility	process type generating mess (NOT USED)	*/
{
	time_t longTime;

	/* facility isnt usefull here, so we dont use it (imagine that)	*/

	syslogOut = fopen(ident,"a");
	if (!syslogOut)			/* i lost badly here		*/
	    fprintf(stderr,"syslog: i lost opening %s (*sigh*)\n",ident);
	
	logOptions = logopt;		/* save the options here	*/
	time(&longTime);
	fprintf(syslogOut, "Syslog started at %s", ctime(&longTime));
}

int
closelog()			/* close out the syslog file		*/
{
	time_t longTime;
	
	time(&longTime);
	fprintf(syslogOut, "Syslog closed at %s", ctime(&longTime));
	return fclose(syslogOut);
}

void
setlogmask(int level)
{
	logLevel = level;		/* save this for later		*/
}

void
syslog(int flag, char *string, ...)
{
	va_list	argument_list;		/* pointer to argument list	*/
	char *frag;
	int i;

	va_start(argument_list, string);
	
	if (syslogOut == NULL)  {
	    fprintf(stderr,"syslog: sorry, openlog() was not called");
	    }

	if ((logLevel == LOG_NOTHING) || (logLevel < flag))  {
		return;	/* if flag > logLevel, i dont want to see it	*/
		}
	
 	while (*string) {
		if (*string != '%')  {
			putc(*string,syslogOut);
			putchar(*string++);
			}
		else  {
			switch (*++string) {
			case 's':
				frag = va_arg(argument_list,char *);
				puts(frag);
				fputs(frag,syslogOut);
				string++;
				break;
			case 'd':
				i = va_arg(argument_list,int);
				printf("%d",i);
				fprintf(syslogOut,"%d",i);
				string++;
				break;
			case 'm':
				if (neterrno)  {
					pneterror("");
					fprintf(syslogOut, " %s\n", neterr_list[neterrno]);
					neterrno = 0;
					}
				if (errno)  {
					perror("");
					fprintf(syslogOut, " %s\n", sys_errlist[errno]);
					errno = 0;
					}
				string++;
				break;
			case '%':
				putc('%',syslogOut);
				putc(*string,syslogOut);
				putchar('%');
				putchar(*string++);
				break;
			default:
				putc('%',syslogOut);
				putc(*string,syslogOut);
				putchar('%');
				putchar(*string++);
				}
			}
		}
	if (*--string != '\n')  {
		putc('\n',syslogOut);
		putchar('\n');
		}
}
	


/*
 * $Log:   J:/22vcs/srclib/socket/syslog.c_v  $
 * 
 *    Rev 1.3   02 Oct 1992 18:59:24   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 16:01:58   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.2   13 Apr 1992 16:10:58   arnoff
 * Fixed instances of ( *string++; ) in syslog()
 * Changed syslog decl to match 4bsddefs.h and our doc
 * 
 *    Rev 1.1   30 Jan 1992 00:51:58   arnoff
 *  
 */
