/*
 * $Header:   J:/22vcs/srclib/socket/socket.c_v   1.2   02 Oct 1992 18:59:02   rcq  $
 */

/*
 * SOCKET.C - Allocate a socket & associated frobs.
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 05-Nov-87	jbvb	Put check for duplicate network descriptor ahead
 *			 of malloc().
 * 14-Jan-88	jbvb	Change ENFILE on too many descriptors to EMFILE.
 *			 Fixes HP #775.
 * 21-Jan-88	jbvb	Initialize l_intrvl, default to SO_DONTLINGER (for
 *			 proper 4.2 linger implementation).
 * 23-Jan-88	jbvb	Initialize socket structure to 0 with calloc().
 * 04-Feb-88	jbvb	Fix arguments to calloc().
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92    rcq     updated the copyright in comments
 * 09-Sep-92	rcq	replaced call to panic() with return(-1)
 */

#include <stdio.h>
#include <stdlib.h>

#include <pctcp/error.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <debug.h>

#include "4bsd.h"

static int	init = 0;

/* extern void panic(char *s, int a); */
static void initialize(void);

/*
 * Create a network descriptor.  bind attributes to it.
 */

int
socket(int af, int type, int protocol)
/* af		Address family */
{
	SOCKET	*sp;
	int	deflt, nd;

#ifdef	DEBUG
	printf("socket(af = %s, type = %s, protocol = %d)",
		af_name(af), sock_type(type), protocol);
#endif

	if(! init)
		initialize();

	if(af != AF_INET)
		bomb(EAFNOSUPPORT);	/* if it ain't IP, I don't want it */

	switch(type) {			/* should be done via lookup... */
	case SOCK_STREAM:
		type = STREAM;
		deflt = IPPROTO_TCP;
		break;
	case SOCK_DGRAM:
		type = DGRAM;
		deflt = IPPROTO_UDP;
		break;
	case SOCK_RAW:
		type = RAW_NET;
		deflt = IPPROTO_RAW;
		break;
	default:
		bomb(ESOCKTNOSUPPORT);		/* don't like it one bit */
	}

	/* if protocol specified, make sure it is allowed.  if one
	 * wasn't specified, assign the default.
	 */
	if(protocol != deflt)
		if(protocol != 0)
			bomb(EPROTOTYPE)	/* PAP's lovely macro */
		else
			protocol = deflt;

	if((nd = net_getdesc()) == -1)
		bomb(EMFILE);		/* no descriptors available */

	if(NSOCK(nd) != NULL)		/* Test this as soon as we can */
	/* panic("socket: descriptor %d already taken!\n", nd); */
	    return(-1);

	if ((sp = (SOCKET *) calloc(1, sizeof(SOCKET))) == NULL)
		bomb(ENOBUFS);

/*	sp->options = 0;		taken care of by calloc() */
/*	sp->lhost = sp->fhost = 0L;	*/
/*	sp->fsocket = sp->lsocket = 0;	*/
/*	sp->l_intrvl = 0;		*/
/*	sp->nconn_q = NULL;		*/
/*	sp->cur_q_len = 0;		*/
	sp->state = SI_OPEN;
	sp->flags = SO_DONTLINGER;	/* Indicate default of no linger. */
	sp->af = af;
	sp->type = type;
	sp->protocol = protocol;
	sp->nd = nd;
	sp->cd = -1;
	NSOCK(sp->nd) = sp;			/* install it */

	dreturn(" = %d\n", sp->nd);
}

static void
initialize()
{
	int	i;

	++init;

	for(i = 0; i < MAXSOCK; ++i)
		NSOCK(i) = NULL;
}

/*
 * $Log:   J:/22vcs/srclib/socket/socket.c_v  $
 * 
 *    Rev 1.2   02 Oct 1992 18:59:02   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.2   27 Aug 1992 16:01:10   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.1   30 Jan 1992 00:51:56   arnoff
 *  
 */
