/*
 * $Header:   J:/22vcs/srclib/socket/perror.c_v   1.5   02 Oct 1992 18:57:16   rcq  $
 */

/*
 * SRCLIB\SOCKET\PERROR.C - perror() that knows network errors.
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 06-Jun-88	jbvb	Get MSC5.1-compatible definition of errno from errno.h
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92    rcq     updated the copyright in comments
 */

#include <stdio.h>
#include <stdlib.h>

#include <errno.h>		/* This one is ours... */

#if _MSC_VER
char * _near _cdecl sys_errlist[] = {
#else /* __TURBOC__ */
char *       _Cdecl sys_errlist[] = {
#endif
	"No error",
	"Not owner",
	"No such file or directory",
	"No such process",
	"Interrupted system call",
	"I/O error",
	"No such device or address",
	"Arg list too long",
	"Exec format error",
	"Bad file number",
	"No children",
	"No more processes",
	"Not enough core",
	"Permission denied",
	"Bad address",
	"Block device required",
	"Mount device busy",
	"File exists",
	"Cross-device link",
	"No such device",
	"Not a directory",
	"Is a directory",
	"Invalid argument",
	"File table overflow",
	"Too many open files",
	"Not a typewriter",
	"Text file busy",
	"File too large",
	"No space left on device",
	"Illegal seek",
	"Read-only file system",
	"Too many links",
	"Broken pipe",
	"Math argument",
	"Result too large",
	"Operation would block",
	"Operation now in progress",
	"Operation already in progress",
	"Socket operation on non-socket",
	"Destination address required",
	"Message too long",
	"Protocol wrong type for socket",
	"Bad protocol option",
	"Protocol not supported",
	"Socket type not supported",
	"Operation not supported on socket",
	"Protocol family not supported",
	"Address family not supported by protocol family",
	"Address already in use",
	"Can't assign requested address",
	"Network is down",
	"Network is unreachable",
	"Network dropped connection or reset",
	"Software caused connection abort",
	"Connection reset by peer",
	"No buffer space available",
	"Socket is already connected",
	"Socket is not connected",
	"Can't send after socket shutdown",
	"(unused -- 59)",
	"Connection timed out",
	"Connection refused",
	"Too many levels of symbolic links",
	"File name too long",
	"Directory not empty"
};

#if _MSC_VER
int _near _cdecl sys_nerr = sizeof(sys_errlist) / sizeof(sys_errlist[0]);
#else /* __TURBOC__ */
int       _Cdecl sys_nerr = sizeof(sys_errlist) / sizeof(sys_errlist[0]);
#endif

void
perror(const char *s)
{
	if(s)
		fprintf(stderr, "%s: ", s);

	if(errno < 0 || errno >= sys_nerr)
		fprintf(stderr, "Unknown error %d.\n", errno);
	else {
		fputs(sys_errlist[errno], stderr);
		fputc('\n', stderr);
	}
}

/*
 * $Log:   J:/22vcs/srclib/socket/perror.c_v  $
 * 
 *    Rev 1.5   02 Oct 1992 18:57:16   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.5   27 Aug 1992 15:57:06   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.4   13 Apr 1992 17:14:44   arnoff
 * Added missing comment-end to TURBOC.  Paul
 * 
 *    Rev 1.3   13 Apr 1992 16:53:20   arnoff
 * Backed out my last change -- they really wanted to be _near in MSC
 *    
 *    Rev 1.2   13 Apr 1992 16:07:58   arnoff
 * Removed _near _cdecl from sys_errlist, sys_nerr (not portable)
 * 
 *    Rev 1.1   30 Jan 1992 00:51:42   arnoff
 *  
 */
