/*
 * $Header:   J:/22vcs/srclib/socket/io.c_v   1.6   01 Nov 1992 15:45:24   rcq  $
 */

/*
 * IO.C - Intercept calls to MSC library, handle sockets specially.
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 27-Jul-87	philip	His final version.
 * 01-Oct-87	jbvb	Eliminate call to is_netnd() (temporary workaround?)
 *			 in bsd_close().
 * 27-Oct-87	jbvb	Do the above, correctly.
 * 16-Nov-87	jbvb	Allow shutdown() on DGRAM sockets (no-op).
 * 17-Nov-87	jbvb	Call net_abort() on close w/o LINGER (this needs
 *			 a kernel change to be useful)
 *			Prevent race w/listen() while freeing a socket.
 *			Only do net_eof() in shutdown(n, 2) - wait till
 *			 the close() to do net_release().
 * 07-Dec-87	jbvb	Set the read/write flags on DGRAM sockets, too.
 * 14-Jan-88	jbvb	Allow shutdown on unconnected sockets - HP #803.
 * 21-Jan-88	jbvb	Handle SO_LINGER & SO_DONTLINGER according to 4.2
 *			Add the sleep(3) that Microsoft doesn't have.
 * 28-Jan-88	jbvb	Rework sleep() to fix bug & return right value.
 * 01-Mar-88	jbvb	Add cast of NULL so net_read() will get passed right
 *			 size pointers in large data models.
 * 21-Jul-88	jbvb	bsd_close() w/SO_LINGER uses timeout on net_release()
 * 22-AUG-89	stev	fix sleep, takes a unsigned not a int
 * 23 AUG 89	stev	fix call to set_option (takes char far *)
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 25-Feb-92	paul	changed bsd_write buf param from char * to void *
 * 13-May-92	paul	crockery to avoid redefinition of ioctl() in TurboC
 * 23-Sep-92	rcq	sleep() ifdef'd out if TurboC used (they have one).
 *			took out ioctl() crockery, not needed, ioctl() fixed
 *			and bsd_read() and bsd_write() prototypes updated
 * 26-Oct-92	rcq	fixed bad ifdef on __TURBOC__ manifest
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>	/* time */
#include <io.h>		/* read, write, close */

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <pctcp/types.h>
#include <pctcp/error.h>
#include <pctcp/pctcp.h>
#include <pctcp/options.h>

#include <debug.h>

#include "4bsd.h"

/*
 * This file contains:
 *
 *	bsd_read()		Trap MSC read() call, see if it's for socket.
 *	bsd_write()		Ditto for MSC write()
 *	bsd_close()		Dittto for MSC close()
 *	shutdown()		Here because it seemed reasonable?
 *
 * We must flush the normal Microsoft definitions of these guys...
 */
#undef	read
#undef	write
#undef	close

int
bsd_read(int fd, void *buf, unsigned n)
/* fd		socket (file descriptor) to read	*/
/* buf		Buffer to put the bytes in		*/
/* n		Number of bytes to read			*/
{
	SOCKET	*sp = NSOCK(fd);

	if(sp == NULL || is_netnd(sp->nd)) 	/* MSDOS file 		*/
		return(read(fd, buf, n));

	return(recv(fd, buf, n, 0));	/* network descriptor		*/
}

int
bsd_write(int fd, void *buf, unsigned n)
/* fd		socket (file descriptor) to write	*/
/* buf		Buffer to put the bytes in		*/
/* n		Number of bytes to write		*/
{
	SOCKET	*sp = NSOCK(fd);
	u_short	flags = 0;

	if(sp == NULL || is_netnd(sp->nd))	/* MSDOS file		*/
		return(write(fd, buf, n));

	if(sp->type != STREAM && sp->fhost == INADDR_ANY)
		flags |= NET_FLG_BROADCAST;

	return(send(fd, buf, n, flags));	/* kind of simplistic... */
}

/*
 * bsd_close() - Intercepts close() call, handles sockets specially.
 *
 * Uses timeout on net_release() to implement linger interval.
 */
int
bsd_close(int fd)
/* fd		Socket (file descriptor) to close? 	*/
{
	SOCKET	*sp = NSOCK(fd);
	NCONN	*nc;
	u_long	linger_time;
	
/*	if(sp == NULL || is_netnd(sp->nd))	*/
	if (sp == NULL)			/* is_netnd() returned false neg*/
		return(close(fd));	/* MSDOS file			*/

#ifdef	DEBUG
	printf("close(fd = %d)", fd);
#endif

	if(SFLAGS(sp) & SO_LINGER) {		/* close() with LINGER 	*/
	    if ((sp->state & (SI_LISTENING|SI_CONNECTED)) != 0) {
		if (sp->l_intrvl == 0) {	/* No linger interval 	*/
		    net_abort(sp->nd);		/* Send RST if STREAM 	*/
	        } else {			/* Normal close w/LINGER*/
		    linger_time = sp->l_intrvl * 1000;	/* Make it msec */
		    set_option(sp->nd, STREAM,NET_OPT_TIMEOUT,(char far *)linger_time,
			    sizeof(u_long));	/* & fall through */
		}
	    }
	}
	sp->state = 0;			/* Close this sucker */

	net_release(sp->nd);		/* Orderly shutdown (ignore error) */

	while (nc = sp->nconn_q) {	/* Clean out the pending queue */
		if (nc->nd < 0)		/* If the descriptor is unclaimed */
			nc->nd *= -1;	/*  fix it up for the kernel */
		net_abort(nc->nd);	/* Free the kernel resources */
		sp->nconn_q = nc->next;	/* Follow the link */
		free(nc);		/* Free the memory */
	}

	free(sp);		/* When net_release() returns, we can't get */
	NSOCK(fd) = NULL;	/*  any more asynch activity - all clear. */

	dreturn(" = %d\n", 0);
}

int
shutdown(int s, int dir)
/* s		File descriptor to shut down		*/
/* dir		Direction: 0 = rcv, 1 = xmt, 2 = both	*/
{
	SOCKET	*sp = NSOCK(s);

#ifdef	DEBUG
	printf("shutdown(s = %d, dir = x%x)", s, dir);
#endif

	if(sp == NULL || is_netnd(sp->nd))
		bomb(ENOTSOCK);

	switch(dir) {				/* What does caller want? */
	case 0:					/* No more receives */
		sp->state &= ~SI_CAN_RECV;
		break;
	case 2:					/* Neither rcvs nor sends */
		sp->state &= ~SI_CAN_RECV;	/* Fall through... */
	case 1:					/* No more sends */
		if ((sp->type == STREAM) &&	/* Only on STREAM sockets */
		    (sp->state & SI_CONNECTED))	/*  that are connected */
			net_eof(sp->nd);	/*  do we do the net_eof() */
		sp->state &= ~SI_CAN_SEND;
		break;
	default:
		bomb(EINVAL);
	}
	dreturn(" = %d\n", 0);
}

#ifndef __TURBOC__
/*
 * Microsoft doesn't have this, but I wanted it.  I'll foist it off on the
 * world, as well.
 */
int
sleep(unsigned s_time)
{
	long	start, now, end;

	time(&start);
	end = start + (long) s_time;
#ifdef DEBUG
	printf ("sleep_time = %d, end time = %ld\n", s_time, end);
#endif
	for (;;) {
		time(&now);
		if (now > end)
			break;
	}
	return (0);
}
#endif /* ifdef __TURBOC__ */

/*
 * $Log:   J:/22vcs/srclib/socket/io.c_v  $
 * 
 *    Rev 1.6   01 Nov 1992 15:45:24   rcq
 * fixed bad ifdef on __TURBOC__ manifest (made it ifndef)
 * 
 *    Rev 1.5   02 Oct 1992 18:56:08   rcq
 *  * 23-Sep-92	rcq	sleep() ifdef'd out if TurboC used (they have one).
 *  *			took out ioctl() crockery, not needed, ioctl() fixed
 *  *			and bsd_read() and bsd_write() prototypes updated
 * 
 *    Rev 1.4   17 Jun 1992 15:35:50   paul
 * 
 * 
 *    Rev 1.3   13 May 1992 14:26:24   paul
 * crockery to avoid redefintion of ioctl() in TurboC
 * 
 *    Rev 1.1   30 Jan 1992 00:51:28   arnoff
 *  
 */
