/*
 * $Header:   J:/22vcs/srclib/socket/getsockn.c_v   1.3   02 Oct 1992 18:53:22   rcq  $
 */

/* 
 * SRCLIB/SOCKET/GETSOCKN.C - Get socket name
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * EDIT HISTORY:
 * 	10/11/87	romkey	Fixed getpeername() to treat namelen as an
 * 				int * instead of an int, and to properly
 * 				return length of the name.
 * 	10/30/87	jbvb	Changes to debugging messages.
 * 	18-Jan-88	jbvb	Require namelen to be exactly right in both
 * 				 getpeername() and getsockname(), require that
 * 				 name be valid in getsockname().  Fixes HP
 * 				 #933 and #934.
 * 	23 AUG 89	stev	fixed sockaddr_in problem
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92    rcq     updated the copyright in comments
 */

#include <stdio.h>
#include <stdlib.h>

#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/ipconfig.h>
#include <pctcp/error.h>
#include <pctcp/protocol.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <debug.h>

#include "4bsd.h"

int
getpeername(int s, struct sockaddr *name_passed, int *namelen)
{
	struct sockaddr_in	*name;
	SOCKET	*sp = NSOCK(s);

	name = (struct sockaddr_in *)name_passed;
#ifdef	DEBUG
	printf("getpeername(s = %d, name = x%Np, namelen = %d)",
		s, name, namelen);
#endif

	if(is_netnd(sp->nd))
		bomb(ENOTSOCK);

	if(! (STATE(sp) & SI_CONNECTED))
		bomb(ENOTCONN);

	if(name == NULL || (*namelen != sizeof(*name)))
		bomb(EFAULT);

	name->sin_family = sp->af;
	name->sin_port = htons(sp->fsocket);
	name->sin_addr.s_addr = sp->fhost;

	*namelen = sizeof(sp->af) + sizeof(sp->fsocket) + sizeof(sp->fhost);


#if	DEBUG > 5
	fputs("getpeername: ", stdout);
	dump_sockaddr(name);
	{
		ADDR	a;
		int	n;

		n = get_peer(sp->nd, &a);
		printf("getpeername: get_peer() returned %d\n", n);
		if(n)
			pneterror("get_peer");
		else
			dump_addr(&a);
	}
#endif

	dreturn(" = %d\n", 0);
}

int
getsockname(int s, struct sockaddr *name_passed, int *namelen)
{
	struct sockaddr_in	*name;
	SOCKET	*sp = NSOCK(s);

	name = (struct sockaddr_in *)name_passed;
#ifdef	DEBUG
	printf("getsockname(s = %d, name = x%Np, *namelen = %d)",
		s, name, *namelen);
#endif

	if(is_netnd(sp->nd))
		bomb(ENOTSOCK);

	if(name == NULL || (*namelen != sizeof(*name)))
		bomb(EFAULT);

	name->sin_family = sp->af;
	name->sin_port = htons(sp->lsocket);
	name->sin_addr.s_addr = sp->lhost;
				/* ? sock[s].lhost : get_addr(sp->nd); */
#if	DEBUG > 5
	{
		long	a;
		int	n;

		a = (long)get_addr(sp->nd);
		printf("getsockname: get_addr() returned %s\n", inet_ntoa(a));
		if(! a)
			pneterror("get_addr");
	}
#endif

	*namelen = sizeof(*name);

#ifdef	DEBUG
	fputs("getsockname: ", stdout);
	dump_sockaddr(name);
#endif

	dreturn(" = %d\n", 0);
}

/*
 * $Log:   J:/22vcs/srclib/socket/getsockn.c_v  $
 * 
 *    Rev 1.3   02 Oct 1992 18:53:22   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 15:52:38   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.2   13 Apr 1992 16:01:02   arnoff
 * Minor syntax fix for lint warning in getsockname
 * 
 *    Rev 1.1   30 Jan 1992 00:51:16   arnoff
 *  
 */
