/*
 * $Header:   J:/22vcs/srclib/socket/getserve.c_v   1.4   19 Oct 1992 14:44:24   rcq  $
 */

/*
 * GETSERVE.C - Socket routines for manipulating "/etc/services".
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 03-Sep-87	Romkey?	?some change?
 * 16-Nov-87	jbvb	Try environment variable to locate /etc/services.
 * 07-Jan-88	jbvb	Accept trailing '\' or '/' on environment variable.
 * 06-Feb-88	jbvb	Fix bug in above.
 * 25-Apr-88	jbvb	DDP says 4BSD parses protocol names containing '.'
 * 29-Jul-91	clennox	fixed endservent() to check for null pointers.
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 26-Feb-92	paul	added include netinet/in.h for htons prototype
 * 14-Aug-92    rcq     updated the copyright in comments
 * 09-Sep-92	rcq	perror() and exit() only if DEBUGging (changed
 *			setservent() to return integer indicating success
 *			or failure so function calling can act accordingly).
 * 15-Oct-92	rcq	added logic to getservent to check config file
 *			for services location ...and search more persistently
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include <netdb.h>
#include <errno.h>              /* for ENOENT error definition */
#include <sys/types.h>
#include <netinet/in.h>		/* htons */
#include <debug.h>
#include <pctcp/rwconf.h>
#include "4bsdconf.h"


#define	dreturn(s, r)	return(r);

#ifndef	ETC_LOC
#define	ETC_LOC		"FTP_ETC"	/* Env. vbl. pointing to /etc */
#endif

#define	TEST(c, i)	(isalpha(c) || (i && (isdigit(c)  || ((c) == '-') \
			|| ((c) == '_') || ((c) == '.'))))

static FILE	*sfp = NULL;
static struct   servent	se;
static int	dontclose = 0;

#define		BUFLEN 128
static char	buf[BUFLEN], *ptr[10];

int
setservent(int stayopen)
{
	int	i;
	int	check = 0;

	dontclose = stayopen;		/* Save the flag for later */

	if(sfp != NULL)
		rewind(sfp);
	else do {  /* We've got to open it: Look for etc directory ptr in
	           config file ...or for FTP_ETC env var ...or look in
		   current directory ...or in default */
	    if ((!check) &&
		((getconf("general","etc-dir",buf,BUFLEN)) 
		  || (ptr[0] = getenv(ETC_LOC)))) {
		if (ptr[0])
		        strcpy(buf, ptr[0]);
		i = strlen(buf);
		i--;
		if ((buf[i] == '\\') ||
		    (buf[i] == '/'))
			buf[i] = '\0';
			strcat(buf, "\\services");
			check = 2;
	    } else if (check < 3) {
		strcpy (buf, "services");
		check = 3;  
	    } else {
		strcpy (buf, "c:\\etc\\services");
		check = 4;
	    }
	    
	    sfp = fopen(buf, "r");   /* Try Opening File */
#ifdef DEBUG		
	    if (sfp == NULL)
			perror(buf);
#endif		
	} while (!sfp && (check < 4));

	if (!sfp)
	     i = -1;  /* failure! */
	else
	     i = 0;   /* success! */
	 
	return(i);
}

void
endservent()
{
	/*
	 * 29-Jul-91 clennox added the following conditional
	 *	to avoid writing to a null pointer if endservent()
	 *	is accidentally called for a nonexistent server.
	 */
	if (sfp) {
		fclose(sfp);
		sfp = NULL;
	}
	return;
}

/* this code is called by the other routines, so it probably isn't
 * worth tracing it.
 */

struct servent *
getservent()
{
	char	*p;
	int	i, j, n;

	if(sfp == NULL) {
		if (setservent(1) < 0) {         /* If we can't open file */
		    errno = ENOENT;              /* error "No Such File" */
		    return ((struct servent*)0); /* Return NULL pointer */
		}
	}

	do {
		if(fgets(buf, sizeof(buf), sfp) == NULL)
			goto quit;
	} while(buf[0] == '#' || buf[0] == '\n');

	se.s_name = buf;
	for(i = 0, p = buf; TEST(*p, i); ++i)
		++p;

	if(! i) {
quit:		endservent();
		return(NULL);
	}
	*p++ = '\0';

	while(isspace(*p))
		++p;

	for(n = i = 0; isdigit(*p); ++i)
		n = n * 10 + *p++ - '0';

	if(! i)
		goto quit;

	se.s_port = htons((int)n);

	if(*p++ != '/')
		goto quit;

	se.s_proto = p;

	for(i = 0; isalpha(*p) || (i && isdigit(*p)); ++i)
		++p;

	if(! i)
		return(NULL);
	*p++ = '\0';

	for(j = 0; *p;) {
		while(isspace(*p))
			++p;

		if(! *p || *p == '#')
			break;

		ptr[j] = p;

		for(i = 0; TEST(*p, i); ++i)
			++p;
		if(! i)
			continue;

		*p++ = '\0';
		++j;
	}

	ptr[j] = NULL;		/* terminate array of ptr's */
	se.s_aliases = ptr;

#if	DEBUG >= 10
	printf("getservent:\t\"%s\"\t%d/%s\t", se.s_name, se.s_port,
		se.s_proto);
	for(i = 0; se.s_aliases[i]; ++i)
		printf(" \"%s\"", se.s_aliases[i]);
	fputc('\n', stdout);
#endif

	return(&se);
}

struct servent *
getservbyport(int port, char *proto)
{
	struct servent	*sp;

#ifdef	DEBUG
	printf("getservbyport(port = %d, proto = \"%s\")", ntohs(port), proto);
#endif

	if (setservent(dontclose) < 0) { /* If we can't open file */
	    errno = ENOENT;              /* error "No Such File" */
	    return ((struct servent*)0); /* Return NULL pointer */
	}

	while((sp = getservent()) != NULL)
		if(sp->s_port == port
		&& (proto == NULL || strcmp(sp->s_proto, proto) == 0))
			break;

	if(! dontclose)
		endservent();

	dreturn(" = x%Np\n", sp);
}

struct servent *
getservbyname(char *name, char *proto)
{
	struct servent	*sp;
	int	i, quit;

#ifdef	DEBUG
	printf("getservbyname(name = \"%s\", proto = \"%s\")", name, proto);
#endif

	if (setservent(dontclose) < 0) { /* If we can't open file */
	    errno = ENOENT;              /* error "No Such File" */
	    return ((struct servent*)0); /* Return NULL pointer */
	}

	/* I'm not sure if I'm supposed to search the alias list,
	 * but I might as well, since it doesn't really hurt (too bad).
	 */
	for(quit = 0; ! quit && (sp = getservent()) != NULL; ) {
		if(proto != NULL && strcmp(sp->s_proto, proto) != 0)
			continue;
		if(strcmp(sp->s_name, name) == 0)
			break;
		for(i = 0; sp->s_aliases[i]; ++i)
			if(strcmp(sp->s_aliases[i], name) == 0) {
				++quit;
				break;
			}
	}

	if(! dontclose)
		endservent();

	dreturn(" = x%Np\n", sp);
}

/*
 * $Log:   J:/22vcs/srclib/socket/getserve.c_v  $
 * 
 *    Rev 1.4   19 Oct 1992 14:44:24   rcq
 *  * 15-Oct-92	rcq	added logic to getservent to check config file
 *  *			for services location ...and search more persistently
 * 
 *    Rev 1.3   02 Oct 1992 18:43:16   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 15:51:50   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.2   13 Apr 1992 15:59:38   arnoff
 * Added include netinet/in.h for htons prototype
 * 
 *    Rev 1.1   30 Jan 1992 00:51:12   arnoff
 *  
 */
