/*
 * $Header:   J:/22vcs/srclib/socket/getprote.c_v   1.4   19 Oct 1992 14:44:02   rcq  $
 */

/*
 * GETPROTE.C - Socket routines for manipulating "/etc/protocols".
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 16-Nov-87	jbvb	Try environment variable to locate /etc/protocols.
 * 07-Jan-87	jbvb	Accept trailing '\' or '/' on environment variable.
 * 21-Jun-91	Ben	Added missing type "int" to function argument for
 *			 getprotobynumber().
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 25-Feb-92	paul	changed LIBTRACE conditional code to DEBUG
 * 14-Aug-92    rcq     updated the copyright in comments
 * 09-Sep-92	rcq	perror() and exit() only if DEBUGging (changed
 *			setprotent() to return integer indicating success
 *			or failure so function calling can act accordingly).
 * 15-Oct-92	rcq	added logic to getservent to check config file
 *			for protocol location ...and search more persistently
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include <netdb.h>
#include <errno.h>    /* Added for ENOENT error definition */
#include <debug.h>
#include <pctcp\rwconf.h>
#include "4bsdconf.h"    /* Defines FTP_ETC and filename(s) */

#define	dreturn(s, r)	return(r);

#ifndef	ETC_LOC
#define	ETC_LOC		"FTP_ETC"	/* Env. vbl. pointing to /etc */
#endif

#define	TEST(c, i)	(isalpha(c) \
			 || (i && (isdigit(c) || (c) == '-' || (c) == '_')))

static FILE	*pfp = NULL;
static struct	protoent	pe;
static int	dontclose = 0;

#define		BUFLEN 128
static char	buf[BUFLEN], *ptr[10];

int
setprotoent(int stayopen)
{
	int	check = 0;
	int	i;

	dontclose = stayopen;
	
	ptr[0] = (char *)0;

	if(pfp != NULL)
		rewind(pfp);
	else do {  /* We've got to open it: Look for etc directory ptr in
	           config file ...or for FTP_ETC env var ...or look in
		   current directory ...or in default */
	    if ((!check) &&
		((getconf("general","etc-dir",buf,BUFLEN)) 
		  || (ptr[0] = getenv(ETC_LOC)))) {
		if (ptr[0])
		        strcpy(buf, ptr[0]);
		i = strlen(buf);
		i--;
		if ((buf[i] == '\\') ||
		    (buf[i] == '/'))
			buf[i] = '\0';
			strcat(buf, "\\protocol");
			check = 2;
	    } else if (check < 3) {
		strcpy (buf, "protocol");
		check = 3;  
	    } else {
		strcpy (buf, "c:\\etc\\protocol");
		check = 4;
	    }
	    
	    pfp = fopen(buf, "r");   /* Try Opening File */
#ifdef DEBUG		
	    if (pfp == NULL)
			perror(buf);
#endif		
	} while (!pfp && (check < 4));

	if (!pfp)
	     i = -1;  /* failure! */
	else
	     i = 0;   /* success! */
	 
	return(i);
}

void
endprotoent()

{
	fclose(pfp);
	pfp = NULL;
	return;
}

/* this code is called by the other routines, so it probably isn't
 * worth tracing it.
 */

struct protoent *
getprotoent()
{
	char	*p;
	int	i, j;
	long	n;

	if(pfp == NULL)	{	/* if not there, open the protocols file*/
	    if (setprotoent(1) < 0) {         /* If we can't open file */
		errno = ENOENT;              /* error "No Such File" */
		return ((struct protoent*)0);/* Return NULL pointer */
	    }
	}

	do {			/* stream past the comments		*/
		if(fgets(buf, sizeof(buf), pfp) == NULL)
			return(NULL);
	} while(buf[0] == '#' || buf[0] == '\n');

	pe.p_name = buf;
	for(i = 0, p = buf; TEST(*p, i); ++i)
		++p;

	if(! i)
		return(NULL);
	*p++ = '\0';

	while(isspace(*p))
		++p;

	for(n = i = 0; isdigit(*p); ++i)
		n = n * 10 + *p++ - '0';

	if(! i)
		return(NULL);
	*p++ = '\0';	/* not really necessary, but... */

	pe.p_proto = (int)n;

	for(j = 0; *p; j++) {
		while(isspace(*p))
			++p;

		if(! *p || *p == '#')
			break;

		ptr[j] = p;

		for(i = 0; isalpha(*p) || (i && isdigit(*p)); ++i)
			++p;
		if(! i)
			continue;

		*p++ = '\0';
	}

	ptr[j] = NULL;		/* terminate array of ptr's */
	pe.p_aliases = ptr;

#ifdef DEBUG
	printf("getprotoent:\t\"%s\"\t%d", pe.p_name, pe.p_proto);
	for(i = 0; pe.p_aliases[i]; ++i)
		printf(" \"%s\"", pe.p_aliases[i]);
	fputc('\n', stdout);
#endif

	return(&pe);
}

struct protoent *
getprotobynumber(int num)
{
	struct protoent	*pp;

#ifdef	DEBUG
	printf("getprotobynumber(num = %d)", num);
#endif

	if (setprotoent(dontclose) < 0) { /* If we can't open file */
	    errno = ENOENT;              /* error "No Such File" */
	    return ((struct protoent*)0);/* Return NULL pointer */
	}

	while((pp = getprotoent()) != NULL && pp->p_proto != num)
		;

	if(! dontclose)
		endprotoent();

	dreturn(" = x%Np\n", pp);
}

struct protoent *
getprotobyname(char *name)
{
	struct protoent	*pp;
	int	i, quit;

#ifdef	DEBUG
	printf("getprotobyname(name = \"%s\")", name);
#endif

	if (setprotoent(dontclose) < 0) { /* If we can't open file */
	    errno = ENOENT;              /* error "No Such File" */
	    return ((struct protoent*)0);/* Return NULL pointer */
	}

	/* I'm not sure if I'm supposed to search the alias list,
	 * but I might as well, since it doesn't really hurt (too bad).
	 */
	for(quit = 0; ! quit && (pp = getprotoent()) != NULL; ) {
		if(strcmp(pp->p_name, name) == 0)
			break;
		for(i = 0; pp->p_aliases[i]; ++i)
			if(strcmp(pp->p_aliases[i], name) == 0) {
				++quit;
				break;
			}
	}

	if(! dontclose)
		endprotoent();

	dreturn(" = x%Np\n", pp);
}

/*
 * $Log:   J:/22vcs/srclib/socket/getprote.c_v  $
 * 
 *    Rev 1.4   19 Oct 1992 14:44:02   rcq
 *  * 15-Oct-92	rcq	added logic to getprotent to check config file
 *  *			for protocol location ...and search more persistently
 * 
 *    Rev 1.3   02 Oct 1992 18:40:08   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 15:51:16   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.2   13 Apr 1992 15:58:04   arnoff
 * Changed LIBTRACE conditional code to DEBUG
 * 
 *    Rev 1.1   30 Jan 1992 00:51:10   arnoff
 *  
 */
