/*
 * $Header:   J:/22vcs/srclib/socket/gethosti.c_v   1.6   02 Oct 1992 18:28:46   rcq  $
 */

/* 
 * SRCLIB/SOCKET/GETHOSTI.C - Get host ID
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 *
 * edit history:
 * 
 * 19OCT89	stev	added EIO for the error return;
 * 09-Aug-91 Ben	replaced get/set_ifconfig with getconf/net_config.
 * 		Dropped ?if_info.
 * 31-Oct-91 Ben	Use get_kernel_info instead of getconf.
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 09-Nov-91 Ben	Cleaned up gethostid a little bit.
 * 25-Feb-92	paul	still include !@#$ ipconfig.h for benefit of config.h
 *			changed LIBTRACE conditional code to DEBUG
 * 19-Mar-92 Ben	get rid of get_kernel call, use get_addr instead.
 * 08-May-92 Ben	Put get_kernel_info() back in.
 * 14-Aug-92 rcq	changed from <ipconfig.h> and <config.h> to
 *			<pctcp/ipconfig.h> and <pctcp/config.h>
 */

#include <stdio.h>
#include <stdlib.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/netinfo.h>
#include <pctcp/error.h>
#include <pctcp/protocol.h>
#include <pctcp/ipconfig.h>		/* definitions for config.h */
#include <pctcp/config.h>		/* for TAGS */
#include <netinet/in.h>

#include <debug.h>

#include "4bsd.h"

long
gethostid()
{
	in_name addr;
	int size;

#ifdef DEBUG
	printf("gethostid()");
#endif
	    
	size = sizeof (addr);
    
	if (get_kernel_info(0, TAG_IP_ADDR, (byte) 0, (void far *) &addr, (int far *) &size)) {
		errno = EIO;	    
		return(0L);
	}

	myaddr = addr;

	return(myaddr);
}


long
sethostid(long hostid)
{
#ifdef DEBUG
	printf("sethostid(hostid = %s)", inet_ntoa(hostid));
#endif

	if (net_config(TAG_IP_ADDR, (byte) 0, (void far *) &hostid, sizeof(hostid)))
		dreturn(" = %d\n", -1);

	dreturn(" = %d\n", 0);
}

/*
 * $Log:   J:/22vcs/srclib/socket/gethosti.c_v  $
 * 
 *    Rev 1.6   02 Oct 1992 18:28:46   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.5   27 Aug 1992 15:39:42   arnoff
 *  * 14-Aug-92 rcq	changed from <ipconfig.h> and <config.h> to
 *  *			<pctcp/ipconfig.h> and <pctcp/config.h>
 * 
 *    Rev 1.4   08 May 1992 17:21:26   arnoff
 * Put get_kernel_info() back in.   ---Ben
 * 
 * 
 *    Rev 1.3   13 Apr 1992 15:53:06   arnoff
 * Still include !@#$ ipconfig.h for benefit of config.h
 * Changed LIBTRACE conditional code to DEBUG
 * 
 *    Rev 1.2   19 Mar 1992 18:05:12   arnoff
 * Get rid of get_kernel call, use get_addr instead.   ---Ben
 * 
 *    Rev 1.1   30 Jan 1992 00:51:04   arnoff
 *  
 */
