/*
 * $Header:   J:/22vcs/srclib/socket/gethoste.c_v   1.3   02 Oct 1992 18:27:22   rcq  $
 */

/* 
 * GETHOSTE.C - Various hostent-related routines for PC/TCP SOCKET library.
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 28-Oct-87	jbvb	Added debugging messages for gethostbyname()
 * 23 AUG 89	stev	add the correct parameters to gethostbyaddr()
 * 27OCT89	stev	fix NULL pointer, need to calloc() h_addr now.
 * 9NOV89	stev	fixed bug introduced on 23AUG (*sigh*)
 * 16NOV89	stev	went to static allocation of more stuff (*sigh*)
 * 13-Dec-89	jbvb	Fix compiler warning (& on array).
 * 26-Mar-90	jbvb	Correct size of Internet address.
 * 27-Mar-90	jbvb	Initialize he.h_addr_list before using it.
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 05-Dec-91	paul	fixed debugging reports of ip addresses
 * 25-Feb-92	paul	changed include memory.h to string.h for portability
 *			removed unused local var 'n' in gethostbyaddr
 * 26-Feb-92	paul	include pctcp/pctcp.h for name resolver prototypes
 * 14-Aug-92    rcq     updated the copyright in comments
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>			/* memcpy */

#include <netdb.h>			/* struct hostent		*/
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <debug.h>

#include <pctcp/types.h>	/* stuff needed for pctcp/pctcp.h */
#include <pctcp/error.h>
#include <pctcp/pctcp.h>	/* ad_*, nm_* */


#define	dreturn(s, r)	return(r);

static struct hostent	he;		/* static structure i return	*/
static char		buf[128], *ptr[10];
static long		taddr[2];	/* only return one address	*/
static long		*tptr[2];	/* he.h_addr_list wants this	*/

/* this hook may be set to whichever name resolution
 * function you please.
 *	for 4.2/hosttable compatibility, set it to nm_htable
 * 	for 4.3/bind compatibility, set it to nm_domain
 *	for our own mark of wickedness, set it to nm_res_name.  why?
 *		because the powers-that-be said sooooo....
 *
 * the args should be that same for all three varieties.
 */

/* nm_res_name returns in_name (typedef'd long), but the sockets lib uses 
 * long or struct in_addr for IP addresses
 */
u_long	(*nm_hook)(char *, char *, int) = (u_long (*)())nm_res_name;
int	(*ad_hook)(in_name, char *, unsigned) = ad_res_name;

void
sethostent(int stayopen)
{
}

void
endhostent()
{
}

/* since we use the name server, this is not supported... */
struct hostent *
gethostent()
{
	return(NULL);
}

struct hostent *
gethostbyaddr(char *addr_passed, int len, int type)
/* addr_passed	address passed in (generic)	*/
/* len		sizeof(addr_passed)		*/
/* type		always AF_INET currently 	*/
{
#if 0
	memcpy(&taddr[0], addr_passed, 4);
#else
	taddr[0] = *(long *)addr_passed;
#endif
#ifdef	DEBUG
	printf("gethostbyaddr(addr = %s)", inet_ntoa(taddr[0]));
#endif

	if (type != AF_INET)  {		/* bomb if not AF_INET		*/
	    errno = EPROTOTYPE;
	    return((struct hostent *)0);
	}
	
	if((*ad_hook)(taddr[0], buf, sizeof(buf)) != 0)
		dreturn(" = x%Np\n", NULL);

	he.h_name = buf;		/* got CNAME back from resolver	*/
	he.h_aliases = ptr;		/* return no aliases		*/
	ptr[0] = NULL;
	he.h_addrtype = AF_INET;	/* type internet		*/
	he.h_length = sizeof(long);	/* Sizeof 32-bit value		*/
	tptr[0] = &taddr[0];		/* Point at first real address	*/
	tptr[1] = (long *)0;		/* List only has one address	*/
	he.h_addr_list = (char **) tptr;	/*all the world a static*/

	dreturn(" = x%Np\n", &he);
}

struct hostent *
gethostbyname(char *name)
{
#ifdef	DEBUG
	printf("gethostbyname(name = \"%s\")", name);
#endif

	/* I'm not sure if I'm supposed to search the alias list,
	 * but I might as well, since it doesn't really hurt (too bad).
	 */
	if((taddr[0] = (*nm_hook)(name, buf, sizeof(buf))) == 0L)
		dreturn(" = x%Np\n", NULL);

	he.h_name = buf;		/* got CNAME from the resolver	*/
	he.h_aliases = ptr;		/* no aliases			*/
	ptr[0] = NULL;			
	he.h_addrtype = AF_INET;	/* Type Internet		*/
	he.h_length = sizeof(long);
	tptr[0] = &taddr[0];		/* Point at first real address	*/
	tptr[1] = (char *)0;		/* List only has one address	*/
	he.h_addr_list = (char **) tptr;/* i'm a pepper, you're a pepper*/

#ifdef	DEBUG
	printf (" cname %s xlates to %s\n", buf, inet_ntoa(taddr[0]));
#endif
	dreturn(" = x%Np\n", &he);
}

/*
 * $Log:   J:/22vcs/srclib/socket/gethoste.c_v  $
 * 
 *    Rev 1.3   02 Oct 1992 18:27:22   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 15:50:40   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.2   13 Apr 1992 15:50:36   arnoff
 * Changed include memory.h to string.h for portability
 * Removed unused local var 'n' in gethostbyaddr
 * Include pctcp/pctcp.h for name resolver prototypes
 *  
 * 
 *    Rev 1.1   30 Jan 1992 00:51:02   arnoff
 *  
 */
