/*
 * $Header:   J:/22vcs/srclib/socket/fcntl.c_v   1.4   04 Oct 1992 09:05:16   rcq  $
 */

/*
 * FCNTL.C - file control
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit history:
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92    rcq     updated the copyright in comments
 * 09-Sep-92	rcq	eliminated printf()'s (unless DEBUGging)
 * 04-Oct-92	rcq	replace panic() call with return (-1)
 */

#include <stdio.h>
#include <stdlib.h>

#include <pctcp/error.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/options.h>

#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>

#include <debug.h>

#include "4bsd.h"

/* fcntl -- file control.  well, not really.   we just implement the
 * socket specific stuff.  whatever else isn't too much trouble I might
 * add, but I doubt it...
 */

int
fcntl(int fd, int cmd, int arg)
{
	SOCKET	*sp = NSOCK(fd);
	int	non_block_on;

#ifdef	DEBUG
	printf("fcntl(fd = %d, cmd = x%x, arg = x%x)",
		fd, cmd, arg);
#endif

	if(sp == NULL || is_netnd(sp->nd))
		bomb(ENOTSOCK);

	switch(cmd) {
	case F_SETFL:
		switch(arg) {

		case FNDELAY:
		        /* Is it non-blocking already? */
			non_block_on = SOPTIONS(sp) & NET_FLG_NONBLOCKING;
			if (non_block_on) {  /* if so, make it blocking */
			    SOPTIONS(sp) &= ~NET_FLG_NONBLOCKING;
			}
			else {               /* if not, make non-blocking */
			    SOPTIONS(sp) |= NET_FLG_NONBLOCKING;
			}
			/* Toggle blocking to non-blocking (and visa versa) */
			if (set_option(sp->nd,sp->type, NET_OPT_NONBLOCKING,
			              (char far *)non_block_on,0) == -1) {
			/* panic("ioctl: set_option %d\n", neterrno); */
				      return(-1);
			}
			break;
		case FASYNC:
#ifdef DEBUG		    
			printf("fcntl: asynch handlers not implemented.\n");
#endif		    
		default:
#ifdef DEBUG		    
			printf("fcntl: arg %d unknown\n", arg);
#endif		    
			bomb(EINVAL);
		}
		dreturn(" = %d\n", 0);
	case F_GETFL:
		non_block_on = 0;
		/* we need a better way, here... */
		if(SOPTIONS(sp) & NET_FLG_NONBLOCKING)
			non_block_on |= FNDELAY;
		dreturn(" = %d\n", non_block_on);
	default:
#ifdef DEBUG	    
		printf("fcntl: cmd x%x not implemented\n", cmd);
#endif	    
		bomb(EINVAL);
	}
}

/*
 * $Log:   J:/22vcs/srclib/socket/fcntl.c_v  $
 * 
 *    Rev 1.4   04 Oct 1992 09:05:16   rcq
 * replaced panic() with return (-1)
 * 
 *    Rev 1.3   02 Oct 1992 18:26:42   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.2   27 Aug 1992 15:50:02   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.1   30 Jan 1992 00:51:00   arnoff
 *  
 */
