/*
 * $Header:   J:/22vcs/srclib/socket/dump.c_v   1.3   02 Oct 1992 18:26:12   rcq  $
 */

/*
 * DUMP.C - useful debugging information
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit history:
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92    rcq     updated the copyright in comments
 */

#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <pctcp/types.h>
#include <pctcp/pctcp.h>

#include <debug.h>

#include "4bsd.h"

char *
af_name(int i)
{
	char	*p;
	static char	buf[16];

	switch(i) {
	case AF_UNIX:
		p = "AF_UNIX";
		break;
	case AF_INET:
		p = "AF_INET";
		break;
	case AF_IMPLINK:
		p = "AF_IMPLINK";
		break;
	case AF_PUP:
		p = "AF_PUP";
		break;
	default:
		sprintf(p = buf, "unknown (%d)", i);
		break;
	}
	return(p);
}
		
char *		
sock_type(int i)
{
	char	*p;
	static char	buf[16];

	switch(i) {
	case SOCK_STREAM:
		p = "SOCK_STREAM";
		break;
	case SOCK_DGRAM:
		p = "SOCK_DGRAM";
		break;
	case SOCK_RAW:
		p = "SOCK_RAW";
		break;
	default:
		sprintf(p = buf, "unknown (%d)", i);
		break;
	}
	return(p);
}

void
dump_sockaddr(struct sockaddr_in *s)
{
	printf("sin_family = %s, sin_port = %u, sin_addr = %s\n",
		af_name(s->sin_family), ntohs(s->sin_port),
		inet_ntoa(s->sin_addr.s_addr));
}

void
dump_addr(ADDR *a)
{
	printf("fhost = %s, fsocket = %d, lsocket = %d, protocol = %d\n",
		inet_ntoa(a->fhost), a->fsocket, a->lsocket, a->protocol);
}

/*
 * $Log:   J:/22vcs/srclib/socket/dump.c_v  $
 * 
 *    Rev 1.3   02 Oct 1992 18:26:12   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.2   27 Aug 1992 15:42:32   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.1   30 Jan 1992 00:50:56   arnoff
 *  
 */
