/*
 * $Header:   J:/22vcs/srclib/socket/connect.c_v   1.7.1.0   13 Apr 1993 18:38:24   rcq  $
 */


/*
 * CONNECT.C - Emulate 4BSD connect() function.
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * ??-Jul-87	philip	Written
 * 20-Sep-87	romkey	Did ?something?
 * 02-Oct-87	jbvb	Correct error return on RST per HP.
 * 13-Oct-87	jbvb	Normal error return on IP address of 0.0.0.0
 * 05-Nov-87	jbvb	Return ENOBUFS for kernel NET_ERR_NOMEM
 * 07-Dec-87	jbvb	Change check for 0.0.0.0, since HP said earlier try
 *			 didn't work.
 * 14-Dec-87	jbvb	If options set on the socket, do a set_option() before
 *			 doing the net_listen().
 * 18-Dec-87	jbvb	Finally understand whole scope of Philip's lossage:
 *			 The SADDR() macro is baroque, but entrenched.
 *		jbvb	I tracked one of Philip's crocks - fix it & fix #807.
 * 14-Jan-88	jbvb	Don't allow connect to port 0 on STREAM.  HP #955
 * 18-Jan-88	jbvb	Require "name" arg, and exact match on "namelen".
 *			 Fixes HP #928.
 * 23 AUG 89	stev	fixed compiler warning about types mismatch on 
 *			 routines using sockaddr_in here but sockaddr 
 *			 in the header file.
 *			fixed cast in call to set_option()
 * 12-SEP-89	stev	progress progresses slowly . . . . add seperation
 *			 of EBADF (not a descriptor) and ENOTSOCK (descriptor
 *			 is a file, not a socket)
 * 26-Jul-91	wcl	Fixed debugging message where we were printing out
 *			 ->type as a string (now %d).
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 25-Feb-92	paul	moved include stat.h (vendor-supplied) before
 *			 our headers, to avoid redefinition of stat flags
 *			removed unused local var 'result' from connect()
 * 04-Apr-92    rcq     added init of local port (addr.lsocket) to the
 *                      "wildcard" (0) if not already bound
 * 14-Aug-92    rcq     updated the copyright in comments
 * 09-Sep-92	rcq	replaced call to panic() with return(-1)
 * 11-Sep-92	rcq	check with kernel (with peek read) when non-blocking
 *			socket is trying to connect (to report a valid state).
 * 15-Sep-92	rcq	eliminated set_option() if NET_FLG_NONBLOCKING set
 *			since ioctl() & fcntl() now do it.
 * 02-Nov-92    rcq     don't return EINPROGRESS if DGRAM
 * 12-Nov-92	rcq	surrounded pneterror() with "ifdef DEBUG"
 * 18-Mar-93	rcq	added error parsing after peek read to bomb if an err
 *			 has occurred (i.e. "in progress" not really the case)
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>				/* for fstat() proto	*/

#include <pctcp/error.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/options.h>

#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <debug.h>

#include "4bsd.h"

/* extern void panic(char *s, int a); */

int
connect(int s, struct sockaddr *name_passed, int namelen)
{
	SOCKET			*sp = NSOCK(s);
	int			nd,
				result;         /* work variable */
	struct	stat		buf;		/* for fstat()		*/
	struct	sockaddr_in	*name;		/* shut up the compiler	*/
	
	name = (struct sockaddr_in *)name_passed; /*(23AUG89)*/


#ifdef	DEBUG
	printf("connect(s = %d, name = x%Np, namelen = %d)",
		s, name, namelen);
#endif

	if(is_netnd(sp->nd))  {		/* fix for EBADF/ENOTSOCK (12SEP89)*/
	    if (fstat( sp->nd, &buf) == 0)  {
		bomb(EBADF);		/* its a file, joe-bob!		*/
	    }
	    else 
		bomb(ENOTSOCK);		/* its just bullshit, joe-bob!	*/
	}

	if(name == NULL || (namelen != sizeof(*name)))
		bomb(EFAULT);

	if(name->sin_family != AF_INET)
		bomb(EAFNOSUPPORT);

	if ((sp->type == STREAM) && (name->sin_port == 0))
		bomb(EINVAL);	/* Must specify a port for TCP */

	/* non-blocking socket, where connect() called at least once
	   already but connection not yet completed ...check if done. */
	if ((SOPTIONS(sp) & NET_FLG_NONBLOCKING) &&
	    (STATE(sp) & (SI_BOUND|SI_CAN_SEND|SI_CAN_RECV)) &&
	    (!((STATE(sp) & SI_CONNECTED)))) {
		result = net_read (sp->nd,(char*)0,256,(struct addr*)0,0);
#ifdef	DEBUG
		pneterror ("non-block peek net_read");
#endif	
		if ((result >= 0) || /* if data or would block error... */
		   ((result < 0) && (neterrno == NET_ERR_WOULD_BLOCK))){
			sp->state |= SI_CONNECTED;  /* ...we're connected! */
			bomb(EISCONN);
		}
		switch (neterrno) {
			case NET_ERR_NOTNETCONN:
			case NET_ERR_NOTESTAB:
				/* connection still in progress */
				bomb(EINPROGRESS);  
			default:
				/* else we've got a real problem */
				bomb(-1);
		}
	} /* end non-blocking check */

	/* must be open (and may or may not be bound to a local address) */
	if((STATE(sp) & ~(SI_BOUND|SI_CAN_SEND|SI_CAN_RECV)) != SI_OPEN)
		bomb(EISCONN);		/* ??? */

	/* set up association */
	if ((SADDR(sp)->fhost = name->sin_addr.s_addr) == 0L)
		bomb(EADDRNOTAVAIL);

	sp->fsocket = ntohs(name->sin_port);  /* init foreign port */
	if (!(STATE(sp) & SI_BOUND)) {        /* if NOT bound already */
	    sp->lsocket = 0;                  /*   init local port to "any" */
	}


#ifdef	DEBUG
 	printf("net_connect() on %d, type is %d, addr is\n\t",
		sp->nd, sp->type);
	dump_addr(SADDR(sp));
#endif

	/* bind() on a datagram socket implies a wild-card connected
	 * descriptor.  It must be released, then reconnected. yetch.
	 *
	 * Also, we need to preserve the network descriptor number.
	 * To do this, we grab a new one, and swap its number with the
	 * old one, the flush the new one (which is really the old one
	 * -- simple, eh?).
	 */
	if(sp->type == DGRAM && (STATE(sp) & SI_BOUND)) {
		if((nd = net_getdesc()) == -1)
			bomb(EMFILE);
		if(net_swap(sp->nd, nd) == -1)
		/* panic("connect: net_swap %d\n", neterrno); */
		    return(-1);
		net_release(nd);
	}

#if 0
/* ioctl() or fcntl() now do the set_option()!  rcq 9/15/92 */
	/*
	 * ioctl() doesn't tell the kernel about the options it has set,
	 * so we have to make nonblocking explicit.
	 */
	if (SOPTIONS(sp) & NET_FLG_NONBLOCKING) {
	    if (set_option(sp->nd,sp->type,
		NET_OPT_NONBLOCKING,(char far *)1L,0) == -1)
	              /* panic("connect: set_option %d\n", neterrno); */
		      return(-1);
	}
#endif
	
	if(net_connect(sp->nd, sp->type, SADDR(sp)) == -1)
		switch(neterrno) {
		case NET_ERR_INUSE:
			bomb(EADDRINUSE);
		case NET_ERR_NOMEM:		/* too many connections */
			bomb(ENOBUFS);
		case NET_ERR_NOTNETCONN:
			bomb(ENOTCONN);
		case NET_ERR_NET_UNREACHABLE:
		case NET_ERR_HOST_UNREACHABLE:
			bomb(ENETUNREACH);
		case NET_ERR_PROT_UNREACHABLE:
		case NET_ERR_PORT_UNREACHABLE:
			bomb(ECONNREFUSED);
		case NET_ERR_TIMEOUT:
			bomb(ETIMEDOUT);
		case NET_ERR_RESET:
			bomb(ECONNREFUSED);
		case NET_ERR_WOULD_BLOCK:
			bomb(EWOULDBLOCK);
		case NET_ERR_UNBOUND:
			bomb(EDESTADDRREQ);
		default:
#ifdef DEBUG		    
			pneterror("bsd_connect");
#endif		    
			abort();
		}

	/* Kernel doesn't return error if non-blocking, so we have to
	 * do so explicitly.
	 */
	sp->lhost = 0L;
	if ((SOPTIONS(sp) & NET_FLG_NONBLOCKING) && (sp->type == STREAM))
	{
		sp->state |= (SI_BOUND|SI_CAN_SEND|SI_CAN_RECV);
		bomb(EINPROGRESS);    /* not quite "connected" yet */
	} else {
		sp->state |= (SI_CONNECTED|SI_BOUND|SI_CAN_SEND|SI_CAN_RECV);
	}

	dreturn(" = %d\n", 0);
}

/*
 * $Log:   J:/22vcs/srclib/socket/connect.c_v  $
 * 
 *    Rev 1.7.1.0   13 Apr 1993 18:38:24   rcq
 * added error parsing after peek read to bomb if error
 * 
 *    Rev 1.7.1.0   09 Apr 1993 15:11:04   rcq
 * added error parsing after peek read to bomb if error
 * 
 *    Rev 1.7   11 Nov 1992 19:53:54   rcq
 * pneterror() only if DEBUG manifest defined
 * 
 *    Rev 1.6   10 Nov 1992 10:59:04   rcq
 * Don't return EINPROGRESS if DGRAM
 * 
 *    Rev 1.5   02 Oct 1992 18:25:42   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.4   27 Aug 1992 16:04:18   arnoff
 *  * 04-Apr-92    rcq     added init of local port (addr.lsocket) to the
 *  *                      "wildcard" (0) if not already bound
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.3   13 Apr 1992 16:32:16   arnoff
 *    
 *    Rev 1.2   13 Apr 1992 15:47:36   arnoff
 * Moved include stat.h (vendor-supplied) before our headers, 
 *   to avoid redefinition of stat flags
 * Removed unused local var 'result' from connect()
 * 
 *    Rev 1.1   30 Jan 1992 00:50:54   arnoff
 *  
 */
